/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;

public abstract class KettleFileRepositoryTestBase {
    protected KettleFileRepository repository;
    protected RepositoryDirectoryInterface tree;
    protected String virtualFolder;

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        this.virtualFolder = "ram://file-repo/" + UUID.randomUUID();
        KettleVFS.getFileObject((String)this.virtualFolder).createFolder();
        KettleFileRepositoryMeta repositoryMeta = new KettleFileRepositoryMeta("KettleFileRepository", "FileRep", "File repository", this.virtualFolder);
        this.repository = new KettleFileRepository();
        this.repository.init((RepositoryMeta)repositoryMeta);
        this.repository.connect(null, null);
        Assert.assertTrue((boolean)this.repository.isConnected());
        this.tree = this.repository.loadRepositoryDirectoryTree();
        Assert.assertNotNull((Object)this.tree);
    }

    @After
    public void tearDown() throws Exception {
        try {
            KettleVFS.getFileObject((String)this.virtualFolder).deleteAll();
            FileUtils.deleteDirectory((File)Paths.get(this.virtualFolder, new String[0]).getParent().getParent().toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

