/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.util.HashMap;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.filerep.KettleFileRepositoryMeta;

public class KettleFileRepositoryMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String THIS_IS_THE_PATH = "/this/is/the/path";
    public static final String JSON_OUTPUT = "{\"isDefault\":true,\"displayName\":\"Name\",\"showHiddenFolders\":true,\"description\":\"Description\",\"location\":\"\\/this\\/is\\/the\\/path\",\"id\":\"KettleFileRepository\",\"doNotModify\":true}";
    private RepositoriesMeta repositoriesMeta = (RepositoriesMeta)Mockito.mock(RepositoriesMeta.class);
    KettleFileRepositoryMeta kettleFileRepositoryMeta;

    @Before
    public void setup() {
        this.kettleFileRepositoryMeta = new KettleFileRepositoryMeta();
    }

    @Test
    public void testPopulate() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("displayName", NAME);
        properties.put("showHiddenFolders", true);
        properties.put("description", DESCRIPTION);
        properties.put("location", THIS_IS_THE_PATH);
        properties.put("doNotModify", true);
        properties.put("isDefault", true);
        this.kettleFileRepositoryMeta.populate(properties, this.repositoriesMeta);
        Assert.assertEquals((Object)NAME, (Object)this.kettleFileRepositoryMeta.getName());
        Assert.assertEquals((Object)true, (Object)this.kettleFileRepositoryMeta.isHidingHiddenFiles());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.kettleFileRepositoryMeta.getDescription());
        Assert.assertEquals((Object)THIS_IS_THE_PATH, (Object)this.kettleFileRepositoryMeta.getBaseDirectory());
        Assert.assertEquals((Object)true, (Object)this.kettleFileRepositoryMeta.isReadOnly());
        Assert.assertEquals((Object)true, (Object)this.kettleFileRepositoryMeta.isDefault());
    }

    @Test
    public void testToJSONString() {
        this.kettleFileRepositoryMeta.setName(NAME);
        this.kettleFileRepositoryMeta.setHidingHiddenFiles(true);
        this.kettleFileRepositoryMeta.setDescription(DESCRIPTION);
        this.kettleFileRepositoryMeta.setBaseDirectory(THIS_IS_THE_PATH);
        this.kettleFileRepositoryMeta.setReadOnly(true);
        this.kettleFileRepositoryMeta.setDefault(Boolean.valueOf(true));
        JSONObject json = this.kettleFileRepositoryMeta.toJSONObject();
        Assert.assertEquals((Object)JSON_OUTPUT, (Object)json.toString());
    }
}

