/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.HasRepositoryDirectories;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryImporterTest {
    private static final String ROOT_PATH = "/test_root";
    private static final String USER_NAME_PATH = "/userName";
    @Mock
    private RepositoryImportFeedbackInterface feedback;
    private RepositoryDirectoryInterface baseDirectory;
    private Node entityNode;

    @Before
    public void beforeTest() {
        NodeList nodeList = (NodeList)Mockito.mock(NodeList.class);
        this.entityNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.entityNode.getChildNodes()).thenReturn((Object)nodeList);
        this.baseDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)this.baseDirectory.getPath()).thenReturn((Object)ROOT_PATH);
    }

    @Test
    public void testImportJob_patchJobEntries_without_variables() throws KettleException {
        JobEntryInterface jobEntry = RepositoryImporterTest.createJobEntry(USER_NAME_PATH);
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntry, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntry))).setDirectories(new String[]{"/test_root/userName"});
    }

    @Test
    public void testImportJob_patchJobEntries_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("${USER_VARIABLE}");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntryInterface))).setDirectories(new String[]{"${USER_VARIABLE}"});
    }

    @Test
    public void testImportJob_patchJobEntries_when_directory_path_starts_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("${USER_VARIABLE}/myDir");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntryInterface))).setDirectories(new String[]{"${USER_VARIABLE}/myDir"});
        JobEntryInterface jobEntryInterface2 = RepositoryImporterTest.createJobEntry("${USER_VARIABLE}/myDir");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface2, stepMeta, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntryInterface2))).setDirectories(new String[]{"/test_root/${USER_VARIABLE}/myDir"});
    }

    @Test
    public void testImportJob_patchJobEntries_when_directory_path_ends_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("/myDir/${USER_VARIABLE}");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntryInterface))).setDirectories(new String[]{"/myDir/${USER_VARIABLE}"});
        JobEntryInterface jobEntryInterface2 = RepositoryImporterTest.createJobEntry("/myDir/${USER_VARIABLE}");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface2, stepMeta, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importJob(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)jobEntryInterface2))).setDirectories(new String[]{"/test_root/myDir/${USER_VARIABLE}"});
    }

    @Test
    public void testImportTrans_patchTransEntries_without_variables() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta(USER_NAME_PATH);
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta))).setDirectories(new String[]{"/test_root/userName"});
    }

    @Test
    public void testImportTrans_patchTransEntries_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("${USER_VARIABLE}");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta))).setDirectories(new String[]{"${USER_VARIABLE}"});
    }

    @Test
    public void testImportTrans_patchTransEntries_when_directory_path_starts_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("${USER_VARIABLE}/myDir");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta))).setDirectories(new String[]{"${USER_VARIABLE}/myDir"});
        StepMetaInterface stepMeta2 = RepositoryImporterTest.createStepMeta("${USER_VARIABLE}/myDir");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta2, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta2))).setDirectories(new String[]{"/test_root/${USER_VARIABLE}/myDir"});
    }

    @Test
    public void testImportTrans_patchTransEntries_when_directory_path_ends_with_variable() throws KettleException {
        JobEntryInterface jobEntryInterface = RepositoryImporterTest.createJobEntry("");
        StepMetaInterface stepMeta = RepositoryImporterTest.createStepMeta("/myDir/${USER_VARIABLE}");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta))).setDirectories(new String[]{"/myDir/${USER_VARIABLE}"});
        StepMetaInterface stepMeta2 = RepositoryImporterTest.createStepMeta("/myDir/${USER_VARIABLE}");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryInterface, stepMeta2, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importTransformation(this.entityNode, this.feedback);
        ((HasRepositoryDirectories)Mockito.verify((Object)((HasRepositoryDirectories)stepMeta2))).setDirectories(new String[]{"/test_root/myDir/${USER_VARIABLE}"});
    }

    /*
     * Exception decompiling
     */
    private static JobEntryInterface createJobEntry(String directory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static StepMetaInterface createStepMeta(String directory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RepositoryImporter createRepositoryImporter(final JobEntryInterface jobEntryInterface, final StepMetaInterface stepMetaInterface, final boolean needToCheckPathForVariables) {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        RepositoryImporter importer = new RepositoryImporter(repository, log){

            JobMeta createJobMetaForNode(Node jobnode) throws KettleXMLException {
                JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
                JobEntryCopy jec = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
                Mockito.when((Object)jec.isTransformation()).thenReturn((Object)true);
                Mockito.when((Object)jec.getEntry()).thenReturn((Object)jobEntryInterface);
                Mockito.when((Object)meta.getJobCopies()).thenReturn(Collections.singletonList(jec));
                return meta;
            }

            TransMeta createTransMetaForNode(Node transnode) throws KettleMissingPluginsException, KettleXMLException {
                TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
                StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
                Mockito.when((Object)stepMeta.isMapping()).thenReturn((Object)true);
                Mockito.when((Object)stepMeta.getStepMetaInterface()).thenReturn((Object)stepMetaInterface);
                Mockito.when((Object)meta.getSteps()).thenReturn(Collections.singletonList(stepMeta));
                return meta;
            }

            protected void replaceSharedObjects(JobMeta transMeta) throws KettleException {
            }

            protected void replaceSharedObjects(TransMeta transMeta) throws KettleException {
            }

            boolean needToCheckPathForVariables() {
                return needToCheckPathForVariables;
            }
        };
        return importer;
    }

    private static /* synthetic */ Object lambda$createStepMeta$3(String directory, InvocationOnMock invocationOnMock) throws Throwable {
        return new String[]{directory};
    }

    private static /* synthetic */ Object lambda$createJobEntry$1(String directory, InvocationOnMock invocationOnMock) throws Throwable {
        return new String[]{directory};
    }
}

