/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import org.apache.commons.vfs2.FileObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rules.JobHasDescriptionImportRule;
import org.pentaho.di.imp.rules.TransformationHasDescriptionImportRule;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ExportFeedback;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExporter;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.utils.TestUtils;
import org.xml.sax.InputSource;

public class RepositoryExporterTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Mock
    Repository repository;
    @Mock
    LogChannelInterface log;
    @Mock
    private RepositoryDirectoryInterface root;
    private FileObject fileObject;
    private String xmlFileName;

    @Before
    public void beforeTest() throws IOException, KettleException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.repository.getLog()).thenReturn((Object)this.log);
        ObjectId id = new ObjectId(){

            public String getId() {
                return "1";
            }
        };
        Mockito.when((Object)this.root.getDirectoryIDs()).thenReturn((Object)new ObjectId[]{id});
        Mockito.when((Object)this.root.findDirectory((ObjectId)Mockito.any(ObjectId.class))).thenReturn((Object)this.root);
        Mockito.when((Object)this.repository.getJobNames((ObjectId)Mockito.any(ObjectId.class), Mockito.anyBoolean())).thenReturn((Object)new String[]{"job1"});
        Mockito.when((Object)this.repository.getTransformationNames((ObjectId)Mockito.any(ObjectId.class), Mockito.anyBoolean())).thenReturn((Object)new String[]{"trans1"});
        Mockito.when((Object)this.root.getPath()).thenReturn((Object)"path");
        Answer<JobMeta> jobLoader = new Answer<JobMeta>(){

            public JobMeta answer(InvocationOnMock invocation) throws Throwable {
                String jobName = (String)String.class.cast(invocation.getArguments()[0]);
                JobMeta jobMeta = (JobMeta)Mockito.mock(JobMeta.class);
                Mockito.when((Object)jobMeta.getXML()).thenReturn((Object)("<" + jobName + ">found</" + jobName + ">"));
                Mockito.when((Object)jobMeta.getName()).thenReturn((Object)jobName);
                return jobMeta;
            }
        };
        Mockito.when((Object)this.repository.loadJob(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(RepositoryDirectoryInterface.class), (ProgressMonitorListener)Mockito.any(ProgressMonitorListener.class), Mockito.anyString())).thenAnswer((Answer)jobLoader);
        Answer<TransMeta> transLoader = new Answer<TransMeta>(){

            public TransMeta answer(InvocationOnMock invocation) throws Throwable {
                String transName = (String)String.class.cast(invocation.getArguments()[0]);
                TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
                Mockito.when((Object)transMeta.getXML()).thenReturn((Object)("<" + transName + ">found</" + transName + ">"));
                Mockito.when((Object)transMeta.getName()).thenReturn((Object)transName);
                return transMeta;
            }
        };
        Mockito.when((Object)this.repository.loadTransformation(Mockito.anyString(), (RepositoryDirectoryInterface)Mockito.any(RepositoryDirectoryInterface.class), (ProgressMonitorListener)Mockito.any(ProgressMonitorListener.class), Mockito.anyBoolean(), Mockito.anyString())).thenAnswer((Answer)transLoader);
        this.xmlFileName = TestUtils.createRamFile(this.getClass().getSimpleName() + "/export.xml");
        this.fileObject = TestUtils.getFileObject(this.xmlFileName);
    }

    @Test
    public void testExportJobsWithFeedback() throws Exception {
        RepositoryExporter exporter = new RepositoryExporter(this.repository);
        List feedback = exporter.exportAllObjectsWithFeedback(null, this.xmlFileName, this.root, RepositoryExporter.ExportType.JOBS.toString());
        Assert.assertEquals((String)"Feedback contains all items recorded", (int)2, (int)feedback.size());
        ExportFeedback fb = (ExportFeedback)feedback.get(1);
        Assert.assertEquals((String)"Job1 was exproted", (String)"job1", (String)fb.getItemName());
        Assert.assertEquals((String)"Repository path for Job1 is specified", (String)"path", (String)fb.getItemPath());
        String res = this.validateXmlFile(this.fileObject.getContent().getInputStream(), "//job1");
        Assert.assertEquals((String)"Export xml contains exported job xml", (String)"found", (String)res);
    }

    @Test
    public void testExportTransformationsWithFeedback() throws Exception {
        RepositoryExporter exporter = new RepositoryExporter(this.repository);
        List feedback = exporter.exportAllObjectsWithFeedback(null, this.xmlFileName, this.root, RepositoryExporter.ExportType.TRANS.toString());
        Assert.assertEquals((String)"Feedback contains all items recorded", (int)2, (int)feedback.size());
        ExportFeedback fb = (ExportFeedback)feedback.get(1);
        Assert.assertEquals((String)"Job1 was exproted", (String)"trans1", (String)fb.getItemName());
        Assert.assertEquals((String)"Repository path for Job1 is specified", (String)"path", (String)fb.getItemPath());
        String res = this.validateXmlFile(this.fileObject.getContent().getInputStream(), "//trans1");
        Assert.assertEquals((String)"Export xml contains exported job xml", (String)"found", (String)res);
    }

    @Test
    public void testExportAllRulesViolation() throws Exception {
        RepositoryExporter exporter = new RepositoryExporter(this.repository);
        exporter.setImportRulesToValidate(this.getImportRules());
        List feedback = exporter.exportAllObjectsWithFeedback(null, this.xmlFileName, this.root, RepositoryExporter.ExportType.ALL.toString());
        Assert.assertEquals((String)"Feedback contains all items recorded", (int)3, (int)feedback.size());
        for (ExportFeedback feed : feedback) {
            if (feed.isSimpleString()) continue;
            Assert.assertEquals((String)("all items rejected: " + feed.toString()), (Object)ExportFeedback.Status.REJECTED, (Object)feed.getStatus());
        }
        Assert.assertTrue((String)"Export file is deleted", (!this.fileObject.exists() ? 1 : 0) != 0);
    }

    @Test(expected=KettleException.class)
    public void testExportAllExceptionThrown() throws KettleException {
        RepositoryExporter exporter = new RepositoryExporter(this.repository);
        exporter.setImportRulesToValidate(this.getImportRules());
        exporter.exportAllObjects(null, this.xmlFileName, this.root, RepositoryExporter.ExportType.ALL.toString());
    }

    private ImportRules getImportRules() {
        ImportRules imp = new ImportRules();
        ArrayList<Object> impRules = new ArrayList<Object>(1);
        JobHasDescriptionImportRule rule = new JobHasDescriptionImportRule();
        rule.setEnabled(true);
        rule.setMinLength(19000);
        impRules.add(rule);
        TransformationHasDescriptionImportRule trRule = new TransformationHasDescriptionImportRule(){

            public String toString() {
                return "stub to avoid call to Plugin registry";
            }
        };
        trRule.setEnabled(true);
        trRule.setMinLength(19001);
        impRules.add(trRule);
        imp.setRules(impRules);
        return imp;
    }

    private String validateXmlFile(InputStream is, String xpath) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression expression = xPath.compile(xpath);
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF8"));
        InputSource input = new InputSource(in);
        String result = expression.evaluate(input);
        return result;
    }
}

