/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.repository.RepositoryElementReadListener;
import org.pentaho.di.repository.RepositoryExportSaxParser;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.xml.sax.SAXParseException;

public class RepositoryExportSaxParserTest {
    private static final String PKG = "org/pentaho/di/repository/";
    private static final String REPOSITORY_FILE = "test_repo";
    private static final String DIR_WITH_SPECIFIC_CHARS = "\u30a2\u30ff\u30cf";
    private static final String BASE_TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final File TEMP_DIR_WITH_REP_FILE = new File(BASE_TEMP_DIR, "\u30a2\u30ff\u30cf");
    private RepositoryExportSaxParser repExpSAXParser;
    private RepositoryImportFeedbackInterface repImpPgDlg = (RepositoryImportFeedbackInterface)Mockito.mock(RepositoryImportFeedbackInterface.class);
    private RepositoryImporter repImpMock = (RepositoryImporter)Mockito.mock(RepositoryImporter.class);

    @Before
    public void setUp() throws IOException, URISyntaxException {
        System.out.println("Temp Dir: " + BASE_TEMP_DIR);
        RepositoryExportSaxParserTest.createTempDirWithSpecialCharactersInName();
        this.copyTestResourceIntoTempDir();
    }

    @After
    public void tearDown() throws IOException {
        RepositoryExportSaxParserTest.cleanTempDir();
    }

    @Test
    public void testNoExceptionOccurs_WhenNameContainsJapaneseCharacters() throws Exception {
        this.repExpSAXParser = new RepositoryExportSaxParser(this.getRepositoryFile().getCanonicalPath(), this.repImpPgDlg);
        try {
            this.repExpSAXParser.parse((RepositoryElementReadListener)this.repImpMock);
        }
        catch (Exception e) {
            Assert.fail((String)("No exception is expected But occured: " + e));
        }
    }

    @Test(expected=SAXParseException.class)
    public void exceptionIsThrownWhenParsingXmlWithBigAmountOfExternalEntities() throws Exception {
        File file = this.createTmpFile("<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n <!ENTITY lol \"lol\">\n <!ELEMENT lolz (#PCDATA)>\n <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n]>\n<lolz>&lol9;</lolz>");
        this.repExpSAXParser = new RepositoryExportSaxParser(file.getAbsolutePath(), null);
        this.repExpSAXParser.parse((RepositoryElementReadListener)this.repImpMock);
    }

    private File createTmpFile(String content) throws Exception {
        File tmpFile = File.createTempFile("RepositoryExportSaxParserTest", ".xml");
        tmpFile.deleteOnExit();
        try (PrintWriter writer = new PrintWriter(tmpFile);){
            writer.write(content);
        }
        return tmpFile;
    }

    private static void createTempDirWithSpecialCharactersInName() throws IOException {
        if (!TEMP_DIR_WITH_REP_FILE.exists()) {
            if (TEMP_DIR_WITH_REP_FILE.mkdir()) {
                System.out.println("CREATED: " + TEMP_DIR_WITH_REP_FILE.getCanonicalPath());
            } else {
                System.out.println("NOT CREATED: " + TEMP_DIR_WITH_REP_FILE.toString());
            }
        }
    }

    private void copyTestResourceIntoTempDir() throws IOException, URISyntaxException {
        File destFile = this.getRepositoryFile();
        File sourceFile = new File(RepositoryExportSaxParserTest.class.getClassLoader().getResource("org/pentaho/di/repository/test_repo").toURI());
        RepositoryExportSaxParserTest.copyFile(sourceFile, destFile);
        System.out.println("Copied: " + sourceFile + "-->" + destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static void cleanTempDir() throws IOException {
        RepositoryExportSaxParserTest.delete(TEMP_DIR_WITH_REP_FILE);
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String tempFile : files = file.list()) {
                    File fileDelete = new File(file, tempFile);
                    RepositoryExportSaxParserTest.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Deleted: " + file);
                }
            }
        } else {
            file.delete();
            System.out.println("Deleted: " + file);
        }
    }

    private File getRepositoryFile() {
        return new File(TEMP_DIR_WITH_REP_FILE, REPOSITORY_FILE);
    }
}

