/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;

public class RepositoriesMetaTest {
    private RepositoriesMeta repoMeta;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpClass() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.repoMeta = (RepositoriesMeta)Mockito.spy((Object)new RepositoriesMeta());
    }

    @Test
    public void testToString() throws Exception {
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        Assert.assertEquals((Object)"RepositoriesMeta", (Object)repositoriesMeta.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadData_closeInput() throws Exception {
        String repositoriesFile = this.getClass().getResource("repositories.xml").getPath();
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)this.repoMeta.getKettleUserRepositoriesFile()).thenReturn((Object)repositoriesFile);
        Mockito.when((Object)this.repoMeta.newLogChannel()).thenReturn((Object)log);
        this.repoMeta.readData();
        try (RandomAccessFile fos = null;){
            File file = new File(repositoriesFile);
            if (file.exists()) {
                fos = new RandomAccessFile(file, "rw");
            }
        }
    }

    @Test
    public void testReadData() throws Exception {
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        ((RepositoriesMeta)Mockito.doReturn((Object)this.getClass().getResource("repositories.xml").getPath()).when((Object)this.repoMeta)).getKettleUserRepositoriesFile();
        ((RepositoriesMeta)Mockito.doReturn((Object)log).when((Object)this.repoMeta)).newLogChannel();
        this.repoMeta.readData();
        String repositoriesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR + "<repositories>" + Const.CR + "  <connection>" + Const.CR + "    <name>local postgres</name>" + Const.CR + "    <server>localhost</server>" + Const.CR + "    <type>POSTGRESQL</type>" + Const.CR + "    <access>Native</access>" + Const.CR + "    <database>hibernate</database>" + Const.CR + "    <port>5432</port>" + Const.CR + "    <username>auser</username>" + Const.CR + "    <password>Encrypted 2be98afc86aa7f285bb18bd63c99dbdde</password>" + Const.CR + "    <servername/>" + Const.CR + "    <data_tablespace/>" + Const.CR + "    <index_tablespace/>" + Const.CR + "    <attributes>" + Const.CR + "      <attribute><code>FORCE_IDENTIFIERS_TO_LOWERCASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>FORCE_IDENTIFIERS_TO_UPPERCASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>IS_CLUSTERED</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>PORT_NUMBER</code><attribute>5432</attribute></attribute>" + Const.CR + "      <attribute><code>PRESERVE_RESERVED_WORD_CASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>QUOTE_ALL_FIELDS</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>SUPPORTS_BOOLEAN_DATA_TYPE</code><attribute>Y</attribute></attribute>" + Const.CR + "      <attribute><code>SUPPORTS_TIMESTAMP_DATA_TYPE</code><attribute>Y</attribute></attribute>" + Const.CR + "      <attribute><code>USE_POOLING</code><attribute>N</attribute></attribute>" + Const.CR + "    </attributes>" + Const.CR + "  </connection>" + Const.CR + "  <repository>    <id>KettleFileRepository</id>" + Const.CR + "    <name>Test Repository</name>" + Const.CR + "    <description>Test Repository Description</description>" + Const.CR + "    <is_default>false</is_default>" + Const.CR + "    <base_directory>test-repository</base_directory>" + Const.CR + "    <read_only>N</read_only>" + Const.CR + "    <hides_hidden_files>N</hides_hidden_files>" + Const.CR + "  </repository>  </repositories>" + Const.CR;
        Assert.assertEquals((Object)repositoriesXml, (Object)this.repoMeta.getXML());
        RepositoriesMeta clone = this.repoMeta.clone();
        Assert.assertEquals((Object)repositoriesXml, (Object)this.repoMeta.getXML());
        Assert.assertNotSame((Object)clone, (Object)this.repoMeta);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrRepositories());
        RepositoryMeta repository = this.repoMeta.getRepository(0);
        Assert.assertEquals((Object)"Test Repository", (Object)repository.getName());
        Assert.assertEquals((Object)"Test Repository Description", (Object)repository.getDescription());
        Assert.assertEquals((Object)("  <repository>    <id>KettleFileRepository</id>" + Const.CR + "    <name>Test Repository</name>" + Const.CR + "    <description>Test Repository Description</description>" + Const.CR + "    <is_default>false</is_default>" + Const.CR + "    <base_directory>test-repository</base_directory>" + Const.CR + "    <read_only>N</read_only>" + Const.CR + "    <hides_hidden_files>N</hides_hidden_files>" + Const.CR + "  </repository>"), (Object)repository.getXML());
        Assert.assertSame((Object)repository, (Object)this.repoMeta.searchRepository("Test Repository"));
        Assert.assertSame((Object)repository, (Object)this.repoMeta.findRepositoryById("KettleFileRepository"));
        Assert.assertSame((Object)repository, (Object)this.repoMeta.findRepository("Test Repository"));
        Assert.assertNull((Object)this.repoMeta.findRepository("not found"));
        Assert.assertNull((Object)this.repoMeta.findRepositoryById("not found"));
        Assert.assertEquals((long)0L, (long)this.repoMeta.indexOfRepository(repository));
        this.repoMeta.removeRepository(0);
        Assert.assertEquals((long)0L, (long)this.repoMeta.nrRepositories());
        Assert.assertNull((Object)this.repoMeta.searchRepository("Test Repository"));
        this.repoMeta.addRepository(0, repository);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrRepositories());
        this.repoMeta.removeRepository(1);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrRepositories());
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrDatabases());
        Assert.assertEquals((Object)"local postgres", (Object)this.repoMeta.getDatabase(0).getName());
        DatabaseMeta searchDatabase = this.repoMeta.searchDatabase("local postgres");
        Assert.assertSame((Object)searchDatabase, (Object)this.repoMeta.getDatabase(0));
        Assert.assertEquals((long)0L, (long)this.repoMeta.indexOfDatabase(searchDatabase));
        this.repoMeta.removeDatabase(0);
        Assert.assertEquals((long)0L, (long)this.repoMeta.nrDatabases());
        Assert.assertNull((Object)this.repoMeta.searchDatabase("local postgres"));
        this.repoMeta.addDatabase(0, searchDatabase);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrDatabases());
        this.repoMeta.removeDatabase(1);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrDatabases());
        Assert.assertEquals((Object)"Unable to read repository with id [junk]. RepositoryMeta is not available.", (Object)this.repoMeta.getErrorMessage());
    }

    @Test
    public void testNothingToRead() throws Exception {
        ((RepositoriesMeta)Mockito.doReturn((Object)"filedoesnotexist.xml").when((Object)this.repoMeta)).getKettleUserRepositoriesFile();
        Assert.assertTrue((boolean)this.repoMeta.readData());
        Assert.assertEquals((long)0L, (long)this.repoMeta.nrDatabases());
        Assert.assertEquals((long)0L, (long)this.repoMeta.nrRepositories());
    }

    @Test
    public void testReadDataFromInputStream() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("repositories.xml");
        this.repoMeta.readDataFromInputStream(inputStream);
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrDatabases());
        Assert.assertEquals((long)1L, (long)this.repoMeta.nrRepositories());
    }

    @Test
    public void testErrorReadingInputStream() throws Exception {
        try {
            this.repoMeta.readDataFromInputStream(this.getClass().getResourceAsStream("filedoesnotexist.xml"));
        }
        catch (KettleException e) {
            Assert.assertEquals((Object)(Const.CR + "Error reading information from file:" + Const.CR + "InputStream cannot be null" + Const.CR), (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorReadingFile() throws Exception {
        Mockito.when((Object)this.repoMeta.getKettleUserRepositoriesFile()).thenReturn((Object)this.getClass().getResource("bad-repositories.xml").getPath());
        try {
            this.repoMeta.readData();
        }
        catch (KettleException e) {
            Assert.assertEquals((Object)(Const.CR + "Error reading information from file:" + Const.CR + "The element type \"repositories\" must be terminated by the matching end-tag \"</repositories>\"." + Const.CR), (Object)e.getMessage());
        }
    }

    @Test
    public void testWriteFile() throws Exception {
        String path = this.getClass().getResource("repositories.xml").getPath().replace("repositories.xml", "new-repositories.xml");
        ((RepositoriesMeta)Mockito.doReturn((Object)path).when((Object)this.repoMeta)).getKettleUserRepositoriesFile();
        this.repoMeta.writeData();
        InputStream resourceAsStream = this.getClass().getResourceAsStream("new-repositories.xml");
        Assert.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR + "<repositories>" + Const.CR + "  </repositories>" + Const.CR), (Object)IOUtils.toString((InputStream)resourceAsStream));
        new File(path).delete();
    }

    @Test
    public void testErrorWritingFile() throws Exception {
        Mockito.when((Object)this.repoMeta.getKettleUserRepositoriesFile()).thenReturn(null);
        try {
            this.repoMeta.writeData();
        }
        catch (KettleException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Const.CR + "Error writing repositories metadata"));
        }
    }

    @Test(expected=KettleException.class)
    public void exceptionThrownWhenParsingXmlWithBigAmountOfExternalEntitiesFromInputStream() throws Exception {
        this.repoMeta.readDataFromInputStream((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n <!ENTITY lol \"lol\">\n <!ELEMENT lolz (#PCDATA)>\n <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n]>\n<lolz>&lol9;</lolz>".getBytes()));
    }
}

