/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Permission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.pan.Pan;
import org.pentaho.di.pan.PanCommandExecutor;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;

public class PanTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String TEST_PARAM_NAME = "testParam";
    private static final String DEFAULT_PARAM_VALUE = "default value";
    private static final String NOT_DEFAULT_PARAM_VALUE = "not the default value";
    private ByteArrayOutputStream sysOutContent;
    private ByteArrayOutputStream sysErrContent;
    private SecurityManager oldSecurityManager;
    RepositoriesMeta mockRepositoriesMeta;
    RepositoryMeta mockRepositoryMeta;
    Repository mockRepository;
    RepositoryDirectoryInterface mockRepositoryDirectory;

    @BeforeClass
    public static void setUpClass() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.oldSecurityManager = System.getSecurityManager();
        this.sysOutContent = new ByteArrayOutputStream();
        this.sysErrContent = new ByteArrayOutputStream();
        System.setSecurityManager(new MySecurityManager(this.oldSecurityManager));
        this.mockRepositoriesMeta = (RepositoriesMeta)Mockito.mock(RepositoriesMeta.class);
        this.mockRepositoryMeta = (RepositoryMeta)Mockito.mock(RepositoryMeta.class);
        this.mockRepository = (Repository)Mockito.mock(Repository.class);
        this.mockRepositoryDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.oldSecurityManager);
        this.sysOutContent = null;
        this.sysErrContent = null;
        this.mockRepositoriesMeta = null;
        this.mockRepositoryMeta = null;
        this.mockRepository = null;
        this.mockRepositoryDirectory = null;
    }

    @Test
    public void testPanStatusCodes() throws Exception {
        Assert.assertNull((Object)CommandExecutorCodes.Pan.getByCode((int)9999));
        Assert.assertNotNull((Object)CommandExecutorCodes.Pan.getByCode((int)0));
        Assert.assertEquals((Object)CommandExecutorCodes.Pan.UNEXPECTED_ERROR, (Object)CommandExecutorCodes.Pan.getByCode((int)2));
        Assert.assertEquals((Object)CommandExecutorCodes.Pan.CMD_LINE_PRINT, (Object)CommandExecutorCodes.Pan.getByCode((int)9));
        Assert.assertEquals((Object)"The transformation ran without a problem", (Object)CommandExecutorCodes.Pan.getByCode((int)0).getDescription());
        Assert.assertEquals((Object)"The transformation couldn't be loaded from XML or the Repository", (Object)CommandExecutorCodes.Pan.getByCode((int)7).getDescription());
        Assert.assertTrue((boolean)CommandExecutorCodes.Pan.isFailedExecution((int)CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode()));
        Assert.assertTrue((boolean)CommandExecutorCodes.Pan.isFailedExecution((int)CommandExecutorCodes.Pan.ERROR_LOADING_STEPS_PLUGINS.getCode()));
        Assert.assertFalse((boolean)CommandExecutorCodes.Pan.isFailedExecution((int)CommandExecutorCodes.Pan.SUCCESS.getCode()));
        Assert.assertFalse((boolean)CommandExecutorCodes.Pan.isFailedExecution((int)CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode()));
    }

    @Test
    public void testConfigureParameters() throws Exception {
        TransMeta transMeta = new TransMeta();
        transMeta.addParameterDefinition(TEST_PARAM_NAME, DEFAULT_PARAM_VALUE, "This tests a default parameter");
        Assert.assertEquals((String)"Default parameter was not set correctly on TransMeta", (Object)DEFAULT_PARAM_VALUE, (Object)transMeta.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in TransMeta", (Object)"", (Object)transMeta.getParameterValue(TEST_PARAM_NAME));
        Trans trans = new Trans(transMeta);
        Assert.assertEquals((String)"Default parameter was not set correctly on Trans", (Object)DEFAULT_PARAM_VALUE, (Object)trans.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in Trans", (Object)"", (Object)trans.getParameterValue(TEST_PARAM_NAME));
        NamedParamsDefault params = new NamedParamsDefault();
        params.addParameterDefinition(TEST_PARAM_NAME, NOT_DEFAULT_PARAM_VALUE, "This tests a non-default parameter");
        params.setParameterValue(TEST_PARAM_NAME, NOT_DEFAULT_PARAM_VALUE);
        Pan.configureParameters((Trans)trans, (NamedParams)params, (TransMeta)transMeta);
        Assert.assertEquals((String)"Parameter was not set correctly in Trans", (Object)NOT_DEFAULT_PARAM_VALUE, (Object)trans.getParameterValue(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter was not set correctly in TransMeta", (Object)NOT_DEFAULT_PARAM_VALUE, (Object)transMeta.getParameterValue(TEST_PARAM_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRepos() throws Exception {
        String TEST_REPO_DUMMY_NAME = "dummy-repo-name";
        String TEST_REPO_DUMMY_DESC = "dummy-repo-description";
        Mockito.when((Object)this.mockRepositoryMeta.getName()).thenReturn((Object)"dummy-repo-name");
        Mockito.when((Object)this.mockRepositoryMeta.getDescription()).thenReturn((Object)"dummy-repo-description");
        Mockito.when((Object)this.mockRepositoriesMeta.nrRepositories()).thenReturn((Object)1);
        Mockito.when((Object)this.mockRepositoriesMeta.getRepository(0)).thenReturn((Object)this.mockRepositoryMeta);
        PanCommandExecutorForTesting testPanCommandExecutor = new PanCommandExecutorForTesting(null, null, this.mockRepositoriesMeta);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Pan.setCommandExecutor((PanCommandExecutor)testPanCommandExecutor);
            Pan.main((String[])new String[]{"/listrep"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("dummy-repo-name"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("dummy-repo-description"));
            Result result = Pan.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Pan.SUCCESS.getCode());
        }
        finally {
            Pan.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListDirs() throws Exception {
        String DUMMY_DIR_1 = "test-dir-1";
        String DUMMY_DIR_2 = "test-dir-2";
        Mockito.when((Object)this.mockRepository.getDirectoryNames((ObjectId)Matchers.anyObject())).thenReturn((Object)new String[]{"test-dir-1", "test-dir-2"});
        Mockito.when((Object)this.mockRepository.loadRepositoryDirectoryTree()).thenReturn((Object)this.mockRepositoryDirectory);
        PanCommandExecutorForTesting testPanCommandExecutor = new PanCommandExecutorForTesting(this.mockRepository, this.mockRepositoryMeta, null);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Pan.setCommandExecutor((PanCommandExecutor)testPanCommandExecutor);
            Pan.main((String[])new String[]{"/listdir:true", "/rep:test-repo", "/level:Basic"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-dir-1"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-dir-2"));
            Result result = Pan.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Pan.SUCCESS.getCode());
        }
        finally {
            Pan.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTrans() throws Exception {
        String DUMMY_TRANS_1 = "test-trans-name-1";
        String DUMMY_TRANS_2 = "test-trans-name-2";
        Mockito.when((Object)this.mockRepository.getTransformationNames((ObjectId)Matchers.anyObject(), Matchers.anyBoolean())).thenReturn((Object)new String[]{"test-trans-name-1", "test-trans-name-2"});
        Mockito.when((Object)this.mockRepository.loadRepositoryDirectoryTree()).thenReturn((Object)this.mockRepositoryDirectory);
        PanCommandExecutorForTesting testPanCommandExecutor = new PanCommandExecutorForTesting(this.mockRepository, this.mockRepositoryMeta, null);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Pan.setCommandExecutor((PanCommandExecutor)testPanCommandExecutor);
            Pan.main((String[])new String[]{"/listtrans:Y", "/rep:test-repo", "/level:Basic"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-trans-name-1"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-trans-name-2"));
            Result result = Pan.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Pan.SUCCESS.getCode());
        }
        finally {
            Pan.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    public class MySecurityManager
    extends SecurityManager {
        private SecurityManager baseSecurityManager;

        public MySecurityManager(SecurityManager baseSecurityManager) {
            this.baseSecurityManager = baseSecurityManager;
        }

        @Override
        public void checkPermission(Permission permission) {
            if (permission.getName().startsWith("exitVM")) {
                throw new SecurityException("System exit not allowed");
            }
            if (this.baseSecurityManager == null) {
                return;
            }
            this.baseSecurityManager.checkPermission(permission);
        }
    }

    private class PanCommandExecutorForTesting
    extends PanCommandExecutor {
        private Repository testRepository;
        private RepositoryMeta testRepositoryMeta;
        private RepositoriesMeta testRepositoriesMeta;

        public PanCommandExecutorForTesting(Repository testRepository, RepositoryMeta testRepositoryMeta, RepositoriesMeta testRepositoriesMeta) {
            super(Pan.class);
            this.testRepository = testRepository;
            this.testRepositoryMeta = testRepositoryMeta;
            this.testRepositoriesMeta = testRepositoriesMeta;
        }

        public RepositoriesMeta loadRepositoryInfo(String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn) throws KettleException {
            return this.testRepositoriesMeta != null ? this.testRepositoriesMeta : super.loadRepositoryInfo(loadingAvailableRepMsgTkn, noRepsDefinedMsgTkn);
        }

        public RepositoryMeta loadRepositoryConnection(String repoName, String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn, String findingRepMsgTkn) throws KettleException {
            return this.testRepositoryMeta != null ? this.testRepositoryMeta : super.loadRepositoryConnection(repoName, loadingAvailableRepMsgTkn, noRepsDefinedMsgTkn, findingRepMsgTkn);
        }

        public Repository establishRepositoryConnection(RepositoryMeta repositoryMeta, String username, String password, RepositoryOperation ... operations) throws KettleException, KettleSecurityException {
            return this.testRepository != null ? this.testRepository : super.establishRepositoryConnection(repositoryMeta, username, password, operations);
        }
    }
}

