/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.File;
import java.io.Serializable;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.pan.PanCommandExecutor;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;

public class PanCommandExecutorTest {
    private static final String FS_METASTORE_NAME = "FS_METASTORE";
    private static final String REPO_METASTORE_NAME = "REPO_METASTORE";
    private static final String SAMPLE_KTR = "hello-world.ktr";
    private DelegatingMetaStore metastore = new DelegatingMetaStore();
    private Repository repository;
    private IMetaStore fsMetaStore;
    private IMetaStore repoMetaStore;
    private RepositoryDirectoryInterface directoryInterface;
    private PanCommandExecutor mockedPanCommandExecutor;

    @Before
    public void setUp() throws Exception {
        this.repository = (Repository)Mockito.mock(Repository.class);
        this.fsMetaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.repoMetaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.directoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        this.mockedPanCommandExecutor = (PanCommandExecutor)Mockito.mock(PanCommandExecutor.class);
        Mockito.when((Object)this.fsMetaStore.getName()).thenReturn((Object)FS_METASTORE_NAME);
        Mockito.when((Object)this.repoMetaStore.getName()).thenReturn((Object)REPO_METASTORE_NAME);
        this.metastore.addMetaStore(this.fsMetaStore);
        Mockito.when((Object)this.repository.getMetaStore()).thenReturn((Object)this.repoMetaStore);
        Mockito.when((Object)this.mockedPanCommandExecutor.getMetaStore()).thenReturn((Object)this.metastore);
        Mockito.when((Object)this.mockedPanCommandExecutor.loadRepositoryDirectory((Repository)Matchers.anyObject(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.directoryInterface);
        Mockito.when((Object)this.mockedPanCommandExecutor.loadTransFromFilesystem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Serializable)Matchers.anyObject())).thenCallRealMethod();
        Mockito.when((Object)this.mockedPanCommandExecutor.loadTransFromRepository((Repository)Matchers.anyObject(), Matchers.anyString(), Matchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.mockedPanCommandExecutor.decodeBase64ToZipFile((Serializable)Matchers.anyObject(), Matchers.anyBoolean())).thenCallRealMethod();
        Mockito.when((Object)this.mockedPanCommandExecutor.decodeBase64ToZipFile((Serializable)Matchers.anyObject(), Matchers.anyString())).thenCallRealMethod();
    }

    @After
    public void tearDown() {
        this.metastore = null;
        this.repository = null;
        this.fsMetaStore = null;
        this.repoMetaStore = null;
        this.directoryInterface = null;
        this.mockedPanCommandExecutor = null;
    }

    @Test
    public void testMetastoreFromRepoAddedIn() throws Exception {
        TransMeta t = new TransMeta(this.getClass().getResource(SAMPLE_KTR).getPath());
        Mockito.when((Object)this.repository.loadTransformation(Matchers.anyString(), (RepositoryDirectoryInterface)Matchers.anyObject(), (ProgressMonitorListener)Matchers.anyObject(), Matchers.anyBoolean(), Matchers.anyString())).thenReturn((Object)t);
        Trans trans = this.mockedPanCommandExecutor.loadTransFromRepository(this.repository, "", SAMPLE_KTR);
        Assert.assertNotNull((Object)trans);
        Assert.assertNotNull((Object)trans.getMetaStore());
        Assert.assertTrue((boolean)(trans.getMetaStore() instanceof DelegatingMetaStore));
        Assert.assertNotNull((Object)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList());
        Assert.assertEquals((long)2L, (long)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList().size());
        Assert.assertTrue((boolean)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList().stream().anyMatch(m -> {
            try {
                return REPO_METASTORE_NAME.equals(m.getName());
            }
            catch (Exception e) {
                return false;
            }
        }));
    }

    @Test
    public void testMetastoreFromFilesystemAddedIn() throws Exception {
        String fullPath = this.getClass().getResource(SAMPLE_KTR).getPath();
        Trans trans = this.mockedPanCommandExecutor.loadTransFromFilesystem("", fullPath, "", (Serializable)((Object)""));
        Assert.assertNotNull((Object)trans);
        Assert.assertNotNull((Object)trans.getMetaStore());
        Assert.assertTrue((boolean)(trans.getMetaStore() instanceof DelegatingMetaStore));
        Assert.assertNotNull((Object)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList());
        Assert.assertEquals((long)1L, (long)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList().size());
        Assert.assertTrue((boolean)((DelegatingMetaStore)trans.getMetaStore()).getMetaStoreList().stream().anyMatch(m -> {
            try {
                return FS_METASTORE_NAME.equals(m.getName());
            }
            catch (Exception e) {
                return false;
            }
        }));
    }

    @Test
    public void testFilesystemBase64Zip() throws Exception {
        String fileName = "test.ktr";
        File zipFile = new File(this.getClass().getResource("testKtrArchive.zip").toURI());
        String base64Zip = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)zipFile));
        Trans trans = this.mockedPanCommandExecutor.loadTransFromFilesystem(null, fileName, null, (Serializable)((Object)base64Zip));
        Assert.assertNotNull((Object)trans);
    }
}

