/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Permission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.kitchen.Kitchen;
import org.pentaho.di.kitchen.KitchenCommandExecutor;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;

public class KitchenTest {
    private static final String TEST_PARAM_NAME = "testParam";
    private static final String DEFAULT_PARAM_VALUE = "default value";
    private static final String NOT_DEFAULT_PARAM_VALUE = "not the default value";
    private ByteArrayOutputStream sysOutContent;
    private ByteArrayOutputStream sysErrContent;
    private SecurityManager oldSecurityManager;
    RepositoriesMeta mockRepositoriesMeta;
    RepositoryMeta mockRepositoryMeta;
    Repository mockRepository;
    RepositoryDirectoryInterface mockRepositoryDirectory;

    @Before
    public void setUp() throws KettleException {
        KettleEnvironment.init();
        this.oldSecurityManager = System.getSecurityManager();
        this.sysOutContent = new ByteArrayOutputStream();
        this.sysErrContent = new ByteArrayOutputStream();
        System.setSecurityManager(new MySecurityManager(this.oldSecurityManager));
        this.mockRepositoriesMeta = (RepositoriesMeta)Mockito.mock(RepositoriesMeta.class);
        this.mockRepositoryMeta = (RepositoryMeta)Mockito.mock(RepositoryMeta.class);
        this.mockRepository = (Repository)Mockito.mock(Repository.class);
        this.mockRepositoryDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.oldSecurityManager);
        this.sysOutContent = null;
        this.sysErrContent = null;
        this.mockRepositoriesMeta = null;
        this.mockRepositoryMeta = null;
        this.mockRepository = null;
        this.mockRepositoryDirectory = null;
    }

    @Test
    public void testKitchenStatusCodes() throws Exception {
        Assert.assertNull((Object)CommandExecutorCodes.Kitchen.getByCode((int)9999));
        Assert.assertNotNull((Object)CommandExecutorCodes.Kitchen.getByCode((int)0));
        Assert.assertEquals((Object)CommandExecutorCodes.Kitchen.UNEXPECTED_ERROR, (Object)CommandExecutorCodes.Kitchen.getByCode((int)2));
        Assert.assertEquals((Object)CommandExecutorCodes.Kitchen.CMD_LINE_PRINT, (Object)CommandExecutorCodes.Kitchen.getByCode((int)9));
        Assert.assertEquals((Object)"The job ran without a problem", (Object)CommandExecutorCodes.Kitchen.getByCode((int)0).getDescription());
        Assert.assertEquals((Object)"The job couldn't be loaded from XML or the Repository", (Object)CommandExecutorCodes.Kitchen.getByCode((int)7).getDescription());
        Assert.assertTrue((boolean)CommandExecutorCodes.Kitchen.isFailedExecution((int)CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode()));
        Assert.assertTrue((boolean)CommandExecutorCodes.Kitchen.isFailedExecution((int)CommandExecutorCodes.Kitchen.ERROR_LOADING_STEPS_PLUGINS.getCode()));
        Assert.assertFalse((boolean)CommandExecutorCodes.Kitchen.isFailedExecution((int)CommandExecutorCodes.Kitchen.SUCCESS.getCode()));
        Assert.assertFalse((boolean)CommandExecutorCodes.Kitchen.isFailedExecution((int)CommandExecutorCodes.Kitchen.ERRORS_DURING_PROCESSING.getCode()));
    }

    @Test
    public void testConfigureParameters() throws Exception {
        JobMeta jobMeta = new JobMeta();
        jobMeta.addParameterDefinition(TEST_PARAM_NAME, DEFAULT_PARAM_VALUE, "This tests a default parameter");
        Assert.assertEquals((String)"Default parameter was not set correctly on JobMeta", (Object)DEFAULT_PARAM_VALUE, (Object)jobMeta.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in JobMeta", (Object)"", (Object)jobMeta.getParameterValue(TEST_PARAM_NAME));
        Job job = new Job(null, jobMeta);
        job.copyParametersFrom((NamedParams)jobMeta);
        Assert.assertEquals((String)"Default parameter was not set correctly on Job", (Object)DEFAULT_PARAM_VALUE, (Object)job.getParameterDefault(TEST_PARAM_NAME));
        Assert.assertEquals((String)"Parameter value should be blank in Job", (Object)"", (Object)job.getParameterValue(TEST_PARAM_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRepos() throws Exception {
        String TEST_REPO_DUMMY_NAME = "dummy-repo-name";
        String TEST_REPO_DUMMY_DESC = "dummy-repo-description";
        Mockito.when((Object)this.mockRepositoryMeta.getName()).thenReturn((Object)"dummy-repo-name");
        Mockito.when((Object)this.mockRepositoryMeta.getDescription()).thenReturn((Object)"dummy-repo-description");
        Mockito.when((Object)this.mockRepositoriesMeta.nrRepositories()).thenReturn((Object)1);
        Mockito.when((Object)this.mockRepositoriesMeta.getRepository(0)).thenReturn((Object)this.mockRepositoryMeta);
        KitchenCommandExecutorForTesting testPanCommandExecutor = new KitchenCommandExecutorForTesting(null, null, this.mockRepositoriesMeta);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Kitchen.setCommandExecutor((KitchenCommandExecutor)testPanCommandExecutor);
            Kitchen.main((String[])new String[]{"/listrep"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("dummy-repo-name"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("dummy-repo-description"));
            Result result = Kitchen.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
        }
        finally {
            Kitchen.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListDirs() throws Exception {
        String DUMMY_DIR_1 = "test-dir-1";
        String DUMMY_DIR_2 = "test-dir-2";
        Mockito.when((Object)this.mockRepository.getDirectoryNames((ObjectId)Matchers.anyObject())).thenReturn((Object)new String[]{"test-dir-1", "test-dir-2"});
        Mockito.when((Object)this.mockRepository.loadRepositoryDirectoryTree()).thenReturn((Object)this.mockRepositoryDirectory);
        KitchenCommandExecutorForTesting testPanCommandExecutor = new KitchenCommandExecutorForTesting(this.mockRepository, this.mockRepositoryMeta, null);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Kitchen.setCommandExecutor((KitchenCommandExecutor)testPanCommandExecutor);
            Kitchen.main((String[])new String[]{"/listdir:true", "/rep:test-repo", "/level:Basic"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-dir-1"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-dir-2"));
            Result result = Kitchen.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Kitchen.SUCCESS.getCode());
        }
        finally {
            Kitchen.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListJobs() throws Exception {
        String DUMMY_JOB_1 = "test-job-name-1";
        String DUMMY_JOB_2 = "test-job-name-2";
        Mockito.when((Object)this.mockRepository.getJobNames((ObjectId)Matchers.anyObject(), Matchers.anyBoolean())).thenReturn((Object)new String[]{"test-job-name-1", "test-job-name-2"});
        Mockito.when((Object)this.mockRepository.loadRepositoryDirectoryTree()).thenReturn((Object)this.mockRepositoryDirectory);
        KitchenCommandExecutorForTesting testPanCommandExecutor = new KitchenCommandExecutorForTesting(this.mockRepository, this.mockRepositoryMeta, null);
        PrintStream origSysOut = System.out;
        PrintStream origSysErr = System.err;
        try {
            System.setOut(new PrintStream(this.sysOutContent));
            System.setErr(new PrintStream(this.sysErrContent));
            Kitchen.setCommandExecutor((KitchenCommandExecutor)testPanCommandExecutor);
            Kitchen.main((String[])new String[]{"/listjobs:Y", "/rep:test-repo", "/level:Basic"});
        }
        catch (SecurityException e) {
            System.out.println(this.sysOutContent);
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-job-name-1"));
            Assert.assertTrue((boolean)this.sysOutContent.toString().contains("test-job-name-2"));
            Result result = Kitchen.getCommandExecutor().getResult();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)result.getExitStatus(), (long)CommandExecutorCodes.Kitchen.SUCCESS.getCode());
        }
        finally {
            Kitchen.setCommandExecutor(null);
            System.setOut(origSysOut);
            System.setErr(origSysErr);
        }
    }

    public class MySecurityManager
    extends SecurityManager {
        private SecurityManager baseSecurityManager;

        public MySecurityManager(SecurityManager baseSecurityManager) {
            this.baseSecurityManager = baseSecurityManager;
        }

        @Override
        public void checkPermission(Permission permission) {
            if (permission.getName().startsWith("exitVM")) {
                throw new SecurityException("System exit not allowed");
            }
            if (this.baseSecurityManager == null) {
                return;
            }
            this.baseSecurityManager.checkPermission(permission);
        }
    }

    private class KitchenCommandExecutorForTesting
    extends KitchenCommandExecutor {
        private Repository testRepository;
        private RepositoryMeta testRepositoryMeta;
        private RepositoriesMeta testRepositoriesMeta;

        public KitchenCommandExecutorForTesting(Repository testRepository, RepositoryMeta testRepositoryMeta, RepositoriesMeta testRepositoriesMeta) {
            super(Kitchen.class);
            this.testRepository = testRepository;
            this.testRepositoryMeta = testRepositoryMeta;
            this.testRepositoriesMeta = testRepositoriesMeta;
        }

        public RepositoriesMeta loadRepositoryInfo(String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn) throws KettleException {
            return this.testRepositoriesMeta != null ? this.testRepositoriesMeta : super.loadRepositoryInfo(loadingAvailableRepMsgTkn, noRepsDefinedMsgTkn);
        }

        public RepositoryMeta loadRepositoryConnection(String repoName, String loadingAvailableRepMsgTkn, String noRepsDefinedMsgTkn, String findingRepMsgTkn) throws KettleException {
            return this.testRepositoryMeta != null ? this.testRepositoryMeta : super.loadRepositoryConnection(repoName, loadingAvailableRepMsgTkn, noRepsDefinedMsgTkn, findingRepMsgTkn);
        }

        public Repository establishRepositoryConnection(RepositoryMeta repositoryMeta, String username, String password, RepositoryOperation ... operations) throws KettleException, KettleSecurityException {
            return this.testRepository != null ? this.testRepository : super.establishRepositoryConnection(repositoryMeta, username, password, operations);
        }
    }
}

