/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import java.io.File;
import java.io.Serializable;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.job.Job;
import org.pentaho.di.kitchen.KitchenCommandExecutor;
import org.pentaho.di.repository.Repository;

public class KitchenCommandExecutorTest {
    private KitchenCommandExecutor mockedKitchenCommandExecutor;

    @Before
    public void setUp() throws Exception {
        this.mockedKitchenCommandExecutor = (KitchenCommandExecutor)Mockito.mock(KitchenCommandExecutor.class);
        Mockito.when((Object)this.mockedKitchenCommandExecutor.loadJobFromFilesystem(Matchers.anyString(), Matchers.anyString(), (Serializable)Matchers.anyObject())).thenCallRealMethod();
        Mockito.when((Object)this.mockedKitchenCommandExecutor.loadJobFromRepository((Repository)Matchers.anyObject(), Matchers.anyString(), Matchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.mockedKitchenCommandExecutor.decodeBase64ToZipFile((Serializable)Matchers.anyObject(), Matchers.anyBoolean())).thenCallRealMethod();
        Mockito.when((Object)this.mockedKitchenCommandExecutor.decodeBase64ToZipFile((Serializable)Matchers.anyObject(), Matchers.anyString())).thenCallRealMethod();
    }

    @After
    public void tearDown() {
        this.mockedKitchenCommandExecutor = null;
    }

    @Test
    public void testFilesystemBase64Zip() throws Exception {
        String fileName = "hello-world.kjb";
        File zipFile = new File(this.getClass().getResource("testKjbArchive.zip").toURI());
        String base64Zip = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)zipFile));
        Job job = this.mockedKitchenCommandExecutor.loadJobFromFilesystem(null, fileName, (Serializable)((Object)base64Zip));
        Assert.assertNotNull((Object)job);
    }
}

