/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.loadSave;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.base.LoadSaveBase;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.initializer.JobEntryInitializer;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.w3c.dom.Node;

public class LoadSaveTester<T extends JobEntryInterface>
extends LoadSaveBase<T> {
    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, JobEntryInitializer<T> jobEntryInitializer) {
        super(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, (JobEntryInitializer<T>)null);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, Arrays.asList(new String[0]), Arrays.asList(new String[0]), getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, new HashMap(), new HashMap());
    }

    public LoadSaveTester(Class<T> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, Arrays.asList(new String[0]), Arrays.asList(new String[0]), getterMap, setterMap, new HashMap(), new HashMap());
    }

    @Override
    protected void validateLoadedMeta(List<String> attributes, Map<String, FieldLoadSaveValidator<?>> validatorMap, T metaSaved, T metaLoaded) {
        super.validateLoadedMeta(attributes, validatorMap, metaSaved, metaLoaded);
        boolean checkDatabases = false;
        for (FieldLoadSaveValidator<?> validator : validatorMap.values()) {
            if (!(validator instanceof DatabaseMetaLoadSaveValidator)) continue;
            checkDatabases = true;
        }
        if (checkDatabases) {
            try {
                this.validateJobEntryUsesDatabaseMeta(metaSaved);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void validateJobEntryUsesDatabaseMeta(T metaSaved) throws KettleException {
        DatabaseMeta[] declaredConnections = metaSaved.getUsedDatabaseConnections();
        if (declaredConnections == null || declaredConnections.length <= 0) {
            throw new KettleException("The job entry did not report any used database connections.");
        }
        List<DatabaseMeta> declaredConnectionsList = Arrays.asList(declaredConnections);
        for (DatabaseMeta usedDatabase : this.databases) {
            if (declaredConnectionsList.contains(usedDatabase)) continue;
            throw new KettleException("The job entry did not declare that a connection was used.");
        }
    }

    public void testSerialization() throws KettleException {
        this.testXmlRoundTrip();
        this.testRepoRoundTrip();
        this.testClone();
    }

    public void testXmlRoundTrip() throws KettleException {
        JobEntryInterface metaToSave = (JobEntryInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.xmlAttributes, metaToSave);
        JobEntryInterface metaLoaded = (JobEntryInterface)this.createMeta();
        String xml = "<step>" + metaToSave.getXML() + "</step>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        metaLoaded.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"step"), this.databases, null, null, null);
        this.validateLoadedMeta((List<String>)this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
    }

    public void testRepoRoundTrip() throws KettleException {
        JobEntryInterface metaToSave = (JobEntryInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.repoAttributes, metaToSave);
        JobEntryInterface metaLoaded = (JobEntryInterface)this.createMeta();
        MemoryRepository rep = new MemoryRepository();
        metaToSave.saveRep((Repository)rep, null, null);
        metaLoaded.loadRep((Repository)rep, null, null, this.databases, null);
        this.validateLoadedMeta((List<String>)this.repoAttributes, validatorMap, metaToSave, metaLoaded);
    }

    protected void testClone() {
        JobEntryInterface metaToSave = (JobEntryInterface)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.xmlAttributes, metaToSave);
        JobEntryInterface metaLoaded = (JobEntryInterface)metaToSave.clone();
        this.validateLoadedMeta((List<String>)this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
    }
}

