/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobEntryCopyTest {
    private static final String ATTRIBUTE_GROUP = "aGroupName";
    private static final String ATTRIBUTE_KEY = "someKey";
    private static final String ATTRIBUTE_VALUE = "aValue";
    private JobEntryCopy originJobEntry;
    private JobEntryCopy copyJobEntry;
    private JobEntryInterface originEntry;

    @Before
    public void setUp() throws Exception {
        this.originJobEntry = new JobEntryCopy();
        this.copyJobEntry = new JobEntryCopy();
        this.originEntry = new JobEntrySpecial("EntrySpecial", false, false);
        this.originEntry.setChanged(false);
        this.originJobEntry.setEntry(this.originEntry);
        this.originJobEntry.setAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY, ATTRIBUTE_VALUE);
    }

    @Test
    public void testReplaceMetaCloneEntryOfOrigin() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertNotSame((String)"Entry of origin and copy JobEntry should be different objects: ", (Object)this.copyJobEntry.getEntry(), (Object)this.originJobEntry.getEntry());
    }

    @Test
    public void testReplaceMetaDoesNotChangeEntryOfOrigin() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertEquals((String)"hasChanged in Entry of origin JobEntry should not be changed. ", (Object)false, (Object)this.originJobEntry.getEntry().hasChanged());
    }

    @Test
    public void testReplaceMetaChangesEntryOfCopy() throws Exception {
        this.copyJobEntry.replaceMeta(this.originJobEntry);
        Assert.assertEquals((String)"hasChanged in Entry of copy JobEntry should be changed. ", (Object)true, (Object)this.copyJobEntry.getEntry().hasChanged());
    }

    @Test
    public void testSetParentMeta() throws Exception {
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        this.originJobEntry.setParentJobMeta(meta);
        Assert.assertEquals((Object)meta, (Object)this.originEntry.getParentJobMeta());
    }

    @Test
    public void testCloneClonesAttributesMap() throws Exception {
        JobEntryCopy clonedJobEntry = (JobEntryCopy)this.originJobEntry.clone();
        Assert.assertNotNull((Object)clonedJobEntry.getAttributesMap());
        Assert.assertEquals((Object)this.originJobEntry.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY), (Object)clonedJobEntry.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY));
    }

    @Test
    public void testCloneClearsObjectId() throws Exception {
        JobEntryCopy clonedJobEntry = (JobEntryCopy)this.originJobEntry.clone();
        Assert.assertNull((Object)clonedJobEntry.getObjectId());
    }

    @Test
    public void testDeepCloneClonesAttributesMap() throws Exception {
        JobEntryCopy deepClonedJobEntry = (JobEntryCopy)this.originJobEntry.clone_deep();
        Assert.assertNotNull((Object)deepClonedJobEntry.getAttributesMap());
        Assert.assertEquals((Object)this.originJobEntry.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY), (Object)deepClonedJobEntry.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY));
    }

    @Test
    public void testDeepCloneClearsObjectId() throws Exception {
        JobEntryCopy deepClonedJobEntry = (JobEntryCopy)this.originJobEntry.clone_deep();
        Assert.assertNull((Object)deepClonedJobEntry.getObjectId());
    }
}

