/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.zipfile;

import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.job.entries.zipfile.JobEntryZipFile;

public class ZipJobEntryPatternFileSelectorTest {
    private FileSelector fileSelector;
    private FileSelectInfo fileSelectInfoMock;
    private FileObject fileObjectMock;
    FileName fileNameMock;
    private static final String PATTERN = "^.*\\.(txt)$";
    private static final String PATTERN_FILE_NAME = "do-not-open.txt";
    private static final String EXCLUDE_PATTERN = "^.*\\.(sh)$";
    private static final String EXCLUDE_PATTERN_FILE_NAME = "performance-boost.sh";

    @Before
    public void init() throws FileSystemException {
        this.fileSelectInfoMock = (FileSelectInfo)Mockito.mock(FileSelectInfo.class);
        this.fileSelector = new JobEntryZipFile.ZipJobEntryPatternFileSelector(Pattern.compile(PATTERN), Pattern.compile(EXCLUDE_PATTERN));
        this.fileObjectMock = (FileObject)Mockito.mock(FileObject.class);
        this.fileNameMock = (FileName)Mockito.mock(FileName.class);
        Mockito.when((Object)this.fileSelectInfoMock.getFile()).thenReturn((Object)this.fileObjectMock);
        Mockito.when((Object)this.fileObjectMock.getType()).thenReturn((Object)FileType.FILE);
        Mockito.when((Object)this.fileObjectMock.getName()).thenReturn((Object)this.fileNameMock);
        Mockito.when((Object)this.fileNameMock.getBaseName()).thenReturn((Object)PATTERN_FILE_NAME);
    }

    @Test
    public void testPatternNull() throws Exception {
        this.fileSelector = new JobEntryZipFile.ZipJobEntryPatternFileSelector(null, Pattern.compile(EXCLUDE_PATTERN));
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertTrue((boolean)includeFile);
        Mockito.when((Object)this.fileNameMock.getBaseName()).thenReturn((Object)EXCLUDE_PATTERN_FILE_NAME);
        includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertFalse((boolean)includeFile);
    }

    @Test
    public void testExcludePatternNull() throws Exception {
        this.fileSelector = new JobEntryZipFile.ZipJobEntryPatternFileSelector(Pattern.compile(PATTERN), null);
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertTrue((boolean)includeFile);
        Mockito.when((Object)this.fileNameMock.getBaseName()).thenReturn((Object)EXCLUDE_PATTERN_FILE_NAME);
        includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertFalse((boolean)includeFile);
    }

    @Test
    public void testPatternAndExcludePatternNull() throws Exception {
        this.fileSelector = new JobEntryZipFile.ZipJobEntryPatternFileSelector(null, null);
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertTrue((boolean)includeFile);
        Mockito.when((Object)this.fileNameMock.getBaseName()).thenReturn((Object)EXCLUDE_PATTERN_FILE_NAME);
        includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertTrue((boolean)includeFile);
    }

    @Test
    public void testMatchesPattern() throws Exception {
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertTrue((boolean)includeFile);
    }

    @Test
    public void testMatchesExcludePattern() throws Exception {
        Mockito.when((Object)this.fileNameMock.getBaseName()).thenReturn((Object)EXCLUDE_PATTERN_FILE_NAME);
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertFalse((boolean)includeFile);
    }

    @Test
    public void testMatchesPatternAndExcludePattern() throws Exception {
        this.fileSelector = new JobEntryZipFile.ZipJobEntryPatternFileSelector(Pattern.compile(PATTERN), Pattern.compile(PATTERN));
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertFalse((boolean)includeFile);
    }

    @Test
    public void testDifferentFileType() throws Exception {
        Mockito.when((Object)this.fileObjectMock.getType()).thenReturn((Object)FileType.IMAGINARY);
        boolean includeFile = this.fileSelector.includeFile(this.fileSelectInfoMock);
        Assert.assertFalse((boolean)includeFile);
    }
}

