/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.writetolog;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.writetolog.JobEntryWriteToLog;

public class JobEntryWriteToLogTest {
    private Job parentJob;
    private JobEntryWriteToLog jobEntry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleLogStore.init();
    }

    @Before
    public void setUp() throws Exception {
        this.parentJob = (Job)Mockito.mock(Job.class);
        ((Job)Mockito.doReturn((Object)false).when((Object)this.parentJob)).isStopped();
        this.jobEntry = new JobEntryWriteToLog();
        this.jobEntry = (JobEntryWriteToLog)Mockito.spy((Object)this.jobEntry);
    }

    @Test
    public void errorMessageIsNotLoggedWhenParentJobLogLevelIsNothing() {
        this.verifyErrorMessageForParentJobLogLevel(LogLevel.NOTHING, Mockito.never());
    }

    @Test
    public void errorMessageIsLoggedWhenParentJobLogLevelIsError() {
        this.verifyErrorMessageForParentJobLogLevel(LogLevel.ERROR, Mockito.times((int)1));
    }

    @Test
    public void errorMessageIsLoggedWhenParentJobLogLevelIsMinimal() {
        this.verifyErrorMessageForParentJobLogLevel(LogLevel.MINIMAL, Mockito.times((int)1));
    }

    private void verifyErrorMessageForParentJobLogLevel(LogLevel parentJobLogLevel, VerificationMode mode) {
        this.jobEntry.setLogMessage("TEST");
        this.jobEntry.setEntryLogLevel(LogLevel.ERROR);
        ((Job)Mockito.doReturn((Object)parentJobLogLevel).when((Object)this.parentJob)).getLogLevel();
        this.jobEntry.setParentJob(this.parentJob);
        LogChannelInterface logChannel = (LogChannelInterface)Mockito.spy((Object)this.jobEntry.createLogChannel());
        ((JobEntryWriteToLog)Mockito.doReturn((Object)logChannel).when((Object)this.jobEntry)).createLogChannel();
        this.jobEntry.evaluate(new Result());
        ((LogChannelInterface)Mockito.verify((Object)logChannel, (VerificationMode)mode)).logError("TEST" + Const.CR);
    }
}

