/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.trans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.listeners.CurrentDirectoryChangedListener;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.powermock.reflect.Whitebox;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobEntryTransTest {
    private final String JOB_ENTRY_TRANS_NAME = "JobEntryTransName";
    private final String JOB_ENTRY_FILE_NAME = "JobEntryFileName";
    private final String JOB_ENTRY_FILE_DIRECTORY = "JobEntryFileDirectory";
    private final String JOB_ENTRY_DESCRIPTION = "JobEntryDescription";

    public Node getEntryNode(boolean includeTransname, ObjectLocationSpecificationMethod method) throws ParserConfigurationException, SAXException, IOException {
        JobEntryTrans jobEntryTrans = this.getJobEntryTrans();
        jobEntryTrans.setDescription("JobEntryDescription");
        jobEntryTrans.setFileName("JobEntryFileName");
        jobEntryTrans.setDirectory("JobEntryFileDirectory");
        if (includeTransname) {
            jobEntryTrans.setTransname("JobEntryFileName");
        }
        if (method != null) {
            jobEntryTrans.setSpecificationMethod(method);
        }
        String string = "<job>" + jobEntryTrans.getXML() + "</job>";
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(stream);
        Node entryNode = doc.getFirstChild();
        return entryNode;
    }

    private JobEntryTrans getJobEntryTrans() {
        JobEntryTrans jobEntryTrans = new JobEntryTrans("JobEntryTransName");
        return jobEntryTrans;
    }

    private void testJobEntry(Repository rep, boolean includeJobName, ObjectLocationSpecificationMethod method, ObjectLocationSpecificationMethod expectedMethod) throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        JobEntryTrans jobEntryTrans = this.getJobEntryTrans();
        jobEntryTrans.loadXML(this.getEntryNode(includeJobName, method), databases, slaveServers, rep, metaStore);
        Assert.assertEquals((String)"If we connect to repository then we use rep_name method", (Object)expectedMethod, (Object)jobEntryTrans.getSpecificationMethod());
    }

    @Test
    public void testChooseSpecMethodByRepositoryConnectionStatus() throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)rep.isConnected()).thenReturn((Object)true);
        this.testJobEntry(null, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, true, null, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
    }

    @Test
    public void testExecute_result_false_get_transMeta_exception() throws KettleException {
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)new JobEntryTrans("JobEntryTransName"));
        jobEntryTrans.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jobEntryTrans.setParentJob((Job)Mockito.mock(Job.class));
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        jobEntryTrans.setParentJobMeta(mockJobMeta);
        jobEntryTrans.setLogLevel(LogLevel.NOTHING);
        ((JobEntryTrans)Mockito.doThrow((Throwable)new KettleException("Error while loading transformation")).when((Object)jobEntryTrans)).getTransMeta((Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class), (VariableSpace)Mockito.any(VariableSpace.class));
        Result result = (Result)Mockito.mock(Result.class);
        jobEntryTrans.execute(result, 1);
        ((Result)Mockito.verify((Object)result)).setResult(false);
    }

    @Test
    public void testCurrDirListener() throws Exception {
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        JobEntryTrans jet = this.getJobEntryTrans();
        jet.setParentJobMeta(meta);
        jet.setParentJobMeta(null);
        ((JobMeta)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).addCurrentDirectoryChangedListener((CurrentDirectoryChangedListener)Mockito.any());
        ((JobMeta)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).removeCurrentDirectoryChangedListener((CurrentDirectoryChangedListener)Mockito.any());
    }

    @Test
    public void testExportResources() throws KettleException {
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)this.getJobEntryTrans());
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        String testName = "test";
        ((JobEntryTrans)Mockito.doReturn((Object)transMeta).when((Object)jobEntryTrans)).getTransMeta((Repository)Mockito.any(Repository.class), (VariableSpace)Mockito.any(VariableSpace.class));
        Mockito.when((Object)transMeta.exportResources((VariableSpace)Mockito.any(TransMeta.class), (Map)Mockito.any(Map.class), (ResourceNamingInterface)Mockito.any(ResourceNamingInterface.class), (Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class))).thenReturn((Object)testName);
        jobEntryTrans.exportResources(null, null, null, null, null);
        ((TransMeta)Mockito.verify((Object)transMeta)).setFilename("${Internal.Entry.Current.Directory}/" + testName);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans)).setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }

    @Test
    public void testPrepareFieldNamesParameters() throws UnknownParamException {
        String[] parameterNames = new String[]{"param1", "param2"};
        String[] parameterFieldNames = new String[]{"StreamParam1"};
        String[] parameterValues = new String[2];
        parameterValues[1] = "ValueParam2";
        JobEntryTrans jet = new JobEntryTrans();
        Variables variableSpace = new Variables();
        jet.copyVariablesFrom((VariableSpace)variableSpace);
        NamedParams namedParam = (NamedParams)Mockito.mock(NamedParamsDefault.class);
        ((NamedParams)Mockito.doReturn((Object)"value1").when((Object)namedParam)).getParameterValue("param1");
        ((NamedParams)Mockito.doReturn((Object)"value2").when((Object)namedParam)).getParameterValue("param2");
        jet.prepareFieldNamesParameters(parameterNames, parameterFieldNames, parameterValues, namedParam, jet);
        Assert.assertEquals((Object)"value1", (Object)jet.getVariable("param1"));
        Assert.assertEquals(null, (Object)jet.getVariable("param2"));
    }

    @Test
    public void testGetTransMeta() throws KettleException {
        String param1 = "param1";
        String param2 = "param2";
        String param3 = "param3";
        String parentValue1 = "parentValue1";
        String parentValue2 = "parentValue2";
        String childValue3 = "childValue3";
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)this.getJobEntryTrans());
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectory repositoryDirectory = (RepositoryDirectory)Mockito.mock(RepositoryDirectory.class);
        RepositoryDirectoryInterface repositoryDirectoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        ((Repository)Mockito.doReturn((Object)repositoryDirectoryInterface).when((Object)rep)).loadRepositoryDirectoryTree();
        ((RepositoryDirectoryInterface)Mockito.doReturn((Object)repositoryDirectory).when((Object)repositoryDirectoryInterface)).findDirectory("/home/admin");
        TransMeta meta = new TransMeta();
        meta.setVariable(param2, "childValue2 should be override");
        meta.setVariable(param3, childValue3);
        ((Repository)Mockito.doReturn((Object)meta).when((Object)rep)).loadTransformation((String)Mockito.eq((Object)"test.ktr"), (RepositoryDirectoryInterface)Mockito.anyObject(), (ProgressMonitorListener)Mockito.anyObject(), Mockito.anyBoolean(), (String)Mockito.anyObject());
        Variables parentSpace = new Variables();
        parentSpace.setVariable(param1, parentValue1);
        parentSpace.setVariable(param2, parentValue2);
        jobEntryTrans.setFileName("/home/admin/test.ktr");
        ((JobEntryTrans)Mockito.doNothing().when((Object)jobEntryTrans)).logBasic(Mockito.anyString());
        jobEntryTrans.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jobEntryTrans.setPassingAllParameters(false);
        TransMeta transMeta = jobEntryTrans.getTransMeta(rep, null, (VariableSpace)parentSpace);
        Assert.assertEquals(null, (Object)transMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)transMeta.getVariable(param2));
        Assert.assertEquals((Object)childValue3, (Object)transMeta.getVariable(param3));
        jobEntryTrans.setPassingAllParameters(true);
        transMeta = jobEntryTrans.getTransMeta(rep, null, (VariableSpace)parentSpace);
        Assert.assertEquals((Object)parentValue1, (Object)transMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)transMeta.getVariable(param2));
        Assert.assertEquals((Object)childValue3, (Object)transMeta.getVariable(param3));
    }

    @Test
    public void testGetTransMetaRepo() throws KettleException {
        String param1 = "dir";
        String param2 = "file";
        String parentValue1 = "/home/admin";
        String parentValue2 = "test";
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)this.getJobEntryTrans());
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectory repositoryDirectory = (RepositoryDirectory)Mockito.mock(RepositoryDirectory.class);
        RepositoryDirectoryInterface repositoryDirectoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        ((Repository)Mockito.doReturn((Object)repositoryDirectoryInterface).when((Object)rep)).loadRepositoryDirectoryTree();
        ((RepositoryDirectoryInterface)Mockito.doReturn((Object)repositoryDirectory).when((Object)repositoryDirectoryInterface)).findDirectory(parentValue1);
        TransMeta meta = new TransMeta();
        meta.setVariable(param2, "childValue2 should be override");
        ((Repository)Mockito.doReturn((Object)meta).when((Object)rep)).loadTransformation((String)Mockito.eq((Object)"test"), (RepositoryDirectoryInterface)Mockito.anyObject(), (ProgressMonitorListener)Mockito.anyObject(), Mockito.anyBoolean(), (String)Mockito.anyObject());
        Variables parentSpace = new Variables();
        parentSpace.setVariable(param1, parentValue1);
        parentSpace.setVariable(param2, parentValue2);
        jobEntryTrans.setDirectory("${dir}");
        jobEntryTrans.setTransname("${file}");
        ((JobEntryTrans)Mockito.doNothing().when((Object)jobEntryTrans)).logBasic(Mockito.anyString());
        jobEntryTrans.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        jobEntryTrans.setPassingAllParameters(false);
        TransMeta transMeta = jobEntryTrans.getTransMeta(rep, null, (VariableSpace)parentSpace);
        Assert.assertEquals(null, (Object)transMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)transMeta.getVariable(param2));
        jobEntryTrans.setPassingAllParameters(true);
        transMeta = jobEntryTrans.getTransMeta(rep, null, (VariableSpace)parentSpace);
        Assert.assertEquals((Object)parentValue1, (Object)transMeta.getVariable(param1));
        Assert.assertEquals((Object)parentValue2, (Object)transMeta.getVariable(param2));
    }

    @Test
    public void updateResultTest() {
        this.updateResultTest(3, 5);
    }

    @Test
    public void updateResultTestWithZeroRows() {
        this.updateResultTest(3, 0);
    }

    private void updateResultTest(int previousRowsResult, int newRowsResult) {
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)this.getJobEntryTrans());
        Trans transMock = (Trans)Mockito.mock(Trans.class);
        Whitebox.setInternalState((Object)jobEntryTrans, (String)"trans", (Object)transMock);
        Mockito.when((Object)transMock.getResult()).thenReturn((Object)this.generateDummyResult(newRowsResult));
        Result resultToBeUpdated = this.generateDummyResult(previousRowsResult);
        jobEntryTrans.updateResult(resultToBeUpdated);
        Assert.assertEquals((long)resultToBeUpdated.getRows().size(), (long)newRowsResult);
    }

    private Result generateDummyResult(int nRows) {
        Result result = new Result();
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        for (int i = 0; i < nRows; ++i) {
            rows.add(new RowMetaAndData());
        }
        result.setRows(rows);
        return result;
    }
}

