/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.net.InetAddress;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class SFTPClientTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private int port = 22;
    private String username = "admin";
    private String password = "password";
    private Session session = (Session)Mockito.mock(Session.class);
    private ChannelSftp channel = (ChannelSftp)Mockito.mock(ChannelSftp.class);
    private InetAddress server = (InetAddress)Mockito.mock(InetAddress.class);
    private JSch jSch = (JSch)Mockito.mock(JSch.class);

    @Before
    public void setUp() throws JSchException {
        System.clearProperty("userauth.gssapi.enabled");
        Mockito.when((Object)this.server.getHostAddress()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.jSch.getSession(this.username, "localhost", this.port)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.openChannel("sftp")).thenReturn((Object)this.channel);
    }

    @After
    public void tearDown() {
        System.clearProperty("userauth.gssapi.enabled");
    }

    @Test
    public void shouldExcludeGssapiFromPreferredAuthenticationsByDefault() throws Exception {
        new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        };
        ((Session)Mockito.verify((Object)this.session)).setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
    }

    @Test
    public void shouldIncludeGssapiToPreferredAuthenticationsIfSpecified() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "true");
        new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        };
        ((Session)Mockito.verify((Object)this.session)).setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password,gssapi-with-mic");
    }

    @Test
    public void shouldIncludeGssapiToPreferredAuthenticationsIfOnlySpecifiedCorrectly() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        };
        ((Session)Mockito.verify((Object)this.session)).setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
    }

    @Test(expected=KettleJobException.class)
    public void folderCreationEmptyTest() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        };
        client.login(this.password);
        client.createFolder("//");
    }

    @Test
    public void folderCreation_Relative_Simple() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = (SFTPClient)Mockito.spy((Object)new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        });
        ((SFTPClient)Mockito.doReturn((Object)"/home/admin").when((Object)client)).pwd();
        client.login(this.password);
        client.createFolder("myfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir(Matchers.anyString());
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/home/admin/myfolder");
    }

    @Test
    public void folderCreation_Relative_Nested() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = (SFTPClient)Mockito.spy((Object)new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        });
        ((SFTPClient)Mockito.doReturn((Object)"/home/admin").when((Object)client)).pwd();
        client.login(this.password);
        client.createFolder("myfolder/subfolder/finalfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)3))).mkdir(Matchers.anyString());
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/home/admin/myfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/home/admin/myfolder/subfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/home/admin/myfolder/subfolder/finalfolder");
    }

    @Test
    public void folderCreation_Absolute_Simple() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = (SFTPClient)Mockito.spy((Object)new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        });
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var");
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var/ftproot");
        client.login(this.password);
        client.createFolder("/var/ftproot/myfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir(Matchers.anyString());
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/var/ftproot/myfolder");
    }

    @Test
    public void folderCreation_Absolute_TrailingSlash() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = (SFTPClient)Mockito.spy((Object)new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        });
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var");
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var/ftproot");
        client.login(this.password);
        client.createFolder("/var/ftproot/myfolder/");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir(Matchers.anyString());
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/var/ftproot/myfolder");
    }

    @Test
    public void folderCreation_Absolute_Nested() throws Exception {
        System.setProperty("userauth.gssapi.enabled", "yes");
        SFTPClient client = (SFTPClient)Mockito.spy((Object)new SFTPClient(this.server, this.port, this.username){

            JSch createJSch() {
                return SFTPClientTest.this.jSch;
            }
        });
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var");
        ((SFTPClient)Mockito.doReturn((Object)true).when((Object)client)).folderExists("/var/ftproot");
        client.login(this.password);
        client.createFolder("/var/ftproot/myfolder/subfolder/finalfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)3))).mkdir(Matchers.anyString());
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/var/ftproot/myfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/var/ftproot/myfolder/subfolder");
        ((ChannelSftp)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).mkdir("/var/ftproot/myfolder/subfolder/finalfolder");
    }
}

