/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.setvariables;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.setvariables.JobEntrySetVariables;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobEntrySetVariablesTest {
    private Job job;
    private JobEntrySetVariables entry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleLogStore.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.job = new Job(null, new JobMeta());
        this.entry = new JobEntrySetVariables();
        this.job.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.entry));
        this.entry.setParentJob(this.job);
        this.job.setStopped(false);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testASCIIText() throws Exception {
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/ASCIIText.properties");
        this.entry.setReplaceVars(true);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"\u65e5\u672c\u8a9e", (Object)this.entry.getVariable("Japanese"));
        Assert.assertEquals((Object)"English", (Object)this.entry.getVariable("English"));
        Assert.assertEquals((Object)"\u4e2d\u6587", (Object)this.entry.getVariable("Chinese"));
    }

    @Test
    public void testUTF8Text() throws Exception {
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/UTF8Text.properties");
        this.entry.setReplaceVars(true);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"\u65e5\u672c\u8a9e", (Object)this.entry.getVariable("Japanese"));
        Assert.assertEquals((Object)"English", (Object)this.entry.getVariable("English"));
        Assert.assertEquals((Object)"\u4e2d\u6587", (Object)this.entry.getVariable("Chinese"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputStreamClosed() throws Exception {
        String propertiesFilename = "src/test/resources/org/pentaho/di/job/entries/setvariables/UTF8Text.properties";
        this.entry.setFilename(propertiesFilename);
        this.entry.setReplaceVars(true);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        try (RandomAccessFile fos = null;){
            File file = new File(propertiesFilename);
            if (file.exists()) {
                fos = new RandomAccessFile(file, "rw");
            }
        }
    }

    @Test
    public void testParentJobVariablesExecutingFilePropertiesThatChangesVariablesAndParameters() throws Exception {
        this.entry.setReplaceVars(true);
        this.entry.setFileVariableType(1);
        Job parentJob = this.entry.getParentJob();
        parentJob.addParameterDefinition("parentParam", "", "");
        parentJob.setParameterValue("parentParam", "parentValue");
        parentJob.setVariable("parentParam", "parentValue");
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/configurationA.properties");
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"a", (Object)parentJob.getVariable("propertyFile"));
        Assert.assertEquals((Object)"a", (Object)parentJob.getVariable("dynamicProperty"));
        Assert.assertEquals((Object)"parentValue", (Object)parentJob.getVariable("parentParam"));
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/configurationB.properties");
        result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"b", (Object)parentJob.getVariable("propertyFile"));
        Assert.assertEquals((Object)"new", (Object)parentJob.getVariable("newProperty"));
        Assert.assertEquals((Object)"haha", (Object)parentJob.getVariable("parentParam"));
        Assert.assertEquals((Object)"static", (Object)parentJob.getVariable("staticProperty"));
        Assert.assertEquals((Object)"", (Object)parentJob.getVariable("dynamicProperty"));
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/configurationA.properties");
        result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"a", (Object)parentJob.getVariable("propertyFile"));
        Assert.assertEquals((Object)"", (Object)parentJob.getVariable("newProperty"));
        Assert.assertEquals((Object)"parentValue", (Object)parentJob.getVariable("parentParam"));
        Assert.assertEquals((Object)"", (Object)parentJob.getVariable("staticProperty"));
        Assert.assertEquals((Object)"a", (Object)parentJob.getVariable("dynamicProperty"));
        this.entry.setFilename("src/test/resources/org/pentaho/di/job/entries/setvariables/configurationB.properties");
        result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"b", (Object)parentJob.getVariable("propertyFile"));
        Assert.assertEquals((Object)"new", (Object)parentJob.getVariable("newProperty"));
        Assert.assertEquals((Object)"haha", (Object)parentJob.getVariable("parentParam"));
        Assert.assertEquals((Object)"static", (Object)parentJob.getVariable("staticProperty"));
        Assert.assertEquals((Object)"", (Object)parentJob.getVariable("dynamicProperty"));
    }

    @Test
    public void testJobEntrySetVariablesExecute_VARIABLE_TYPE_JVM_NullVariable() throws Exception {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.entry.loadXML(this.getEntryNode("nullVariable", null, "JVM"), databases, slaveServers, repository, metaStore);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertNull((Object)System.getProperty("nullVariable"));
    }

    @Test
    public void testJobEntrySetVariablesExecute_VARIABLE_TYPE_CURRENT_JOB_NullVariable() throws Exception {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.entry.loadXML(this.getEntryNode("nullVariable", null, "CURRENT_JOB"), databases, slaveServers, repository, metaStore);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertNull((Object)this.entry.getVariable("nullVariable"));
    }

    @Test
    public void testJobEntrySetVariablesExecute_VARIABLE_TYPE_JVM_VariableNotNull() throws Exception {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.entry.loadXML(this.getEntryNode("variableNotNull", "someValue", "JVM"), databases, slaveServers, repository, metaStore);
        Assert.assertNull((Object)System.getProperty("variableNotNull"));
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"someValue", (Object)System.getProperty("variableNotNull"));
    }

    @Test
    public void testJobEntrySetVariablesExecute_VARIABLE_TYPE_CURRENT_JOB_VariableNotNull() throws Exception {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        this.entry.loadXML(this.getEntryNode("variableNotNull", "someValue", "CURRENT_JOB"), databases, slaveServers, repository, metaStore);
        Assert.assertNull((Object)System.getProperty("variableNotNull"));
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((Object)"someValue", (Object)this.entry.getVariable("variableNotNull"));
    }

    public Node getEntryNode(String variable_name, String variable_value, String variable_type) throws ParserConfigurationException, SAXException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(XMLHandler.openTag((String)"job"));
        sb.append("      ").append(XMLHandler.openTag((String)"fields"));
        sb.append("      ").append(XMLHandler.openTag((String)"field"));
        sb.append("      ").append(XMLHandler.addTagValue((String)"variable_name", (String)variable_name));
        if (variable_value != null) {
            sb.append("      ").append(XMLHandler.addTagValue((String)"variable_value", (String)variable_value));
        }
        if (variable_type != null) {
            sb.append("          ").append(XMLHandler.addTagValue((String)"variable_type", (String)variable_type));
        }
        sb.append("      ").append(XMLHandler.closeTag((String)"field"));
        sb.append("      ").append(XMLHandler.closeTag((String)"fields"));
        sb.append(XMLHandler.closeTag((String)"job"));
        ByteArrayInputStream stream = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(stream);
        Node entryNode = doc.getFirstChild();
        return entryNode;
    }
}

