/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.listeners.CurrentDirectoryChangedListener;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.w3c.dom.Node;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JobEntryJob.class})
public class JobEntryJobTest {
    private final String JOB_ENTRY_JOB_NAME = "My Job";
    private final StringObjectId JOB_ENTRY_JOB_OBJECT_ID = new StringObjectId("00x1");
    private final String JOB_ENTRY_FILE_NAME = "job.kjb";
    private final String JOB_ENTRY_FILE_DIRECTORY = "/public/test";
    private final String JOB_ENTRY_FILE_PATH = "/home/ljm/job.kjb";
    private final String JOB_ENTRY_DESCRIPTION = "This is yet another job";
    private Repository repository = (Repository)Mockito.mock(Repository.class);
    private List<DatabaseMeta> databases = (List)Mockito.mock(List.class);
    private List<SlaveServer> servers = (List)Mockito.mock(List.class);
    private IMetaStore store = (IMetaStore)Mockito.mock(IMetaStore.class);
    private VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
    private CurrentDirectoryResolver resolver = (CurrentDirectoryResolver)Mockito.mock(CurrentDirectoryResolver.class);
    private RepositoryDirectoryInterface rdi = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
    private RepositoryDirectoryInterface directory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);

    @Before
    public void setUp() throws Exception {
        ((Repository)Mockito.doReturn((Object)true).when((Object)this.repository)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)this.repository)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)this.rdi).when((Object)this.repository)).loadRepositoryDirectoryTree();
        ((RepositoryDirectoryInterface)Mockito.doReturn((Object)this.directory).when((Object)this.rdi)).findDirectory("/public/test");
        ((RepositoryDirectoryInterface)Mockito.doReturn((Object)this.directory).when((Object)this.rdi)).findDirectory("/home/admin/folder");
        ((VariableSpace)Mockito.doReturn(null).when((Object)this.space)).environmentSubstitute(Matchers.anyString());
        ((VariableSpace)Mockito.doReturn((Object)"").when((Object)this.space)).environmentSubstitute("");
        ((VariableSpace)Mockito.doReturn((Object)"/home/ljm/job.kjb").when((Object)this.space)).environmentSubstitute("/home/ljm/job.kjb");
        ((VariableSpace)Mockito.doReturn((Object)"job.kjb").when((Object)this.space)).environmentSubstitute("job.kjb");
        ((VariableSpace)Mockito.doReturn((Object)"/public/test").when((Object)this.space)).environmentSubstitute("/public/test");
        ((VariableSpace)Mockito.doReturn((Object)"hdfs://server/path/").when((Object)this.space)).environmentSubstitute("${hdfs}");
        ((VariableSpace)Mockito.doReturn((Object)"/home/admin/folder/job.kjb").when((Object)this.space)).environmentSubstitute("${repositoryfullfilepath}");
        ((VariableSpace)Mockito.doReturn((Object)"/home/admin/folder/").when((Object)this.space)).environmentSubstitute("${repositorypath}");
        ((VariableSpace)Mockito.doReturn((Object)"job.kjb").when((Object)this.space)).environmentSubstitute("${jobname}");
        ((VariableSpace)Mockito.doReturn((Object)"job").when((Object)this.space)).environmentSubstitute("job");
        ((CurrentDirectoryResolver)Mockito.doCallRealMethod().when((Object)this.resolver)).normalizeSlashes(Matchers.anyString());
        ((CurrentDirectoryResolver)Mockito.doReturn((Object)this.space).when((Object)this.resolver)).resolveCurrentDirectory((ObjectLocationSpecificationMethod)Mockito.any(ObjectLocationSpecificationMethod.class), (VariableSpace)Mockito.any(VariableSpace.class), (Repository)Mockito.any(Repository.class), (Job)Mockito.any(Job.class), Matchers.anyString());
        PowerMockito.whenNew(CurrentDirectoryResolver.class).withNoArguments().thenReturn((Object)this.resolver);
        PowerMockito.whenNew(JobMeta.class).withAnyArguments().thenReturn(Mockito.mock(JobMeta.class));
    }

    @Test
    public void testNotConnectedLoad_NoInfo() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadXML(this.getNode(jej), this.databases, this.servers, null, this.store);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
    }

    @Test
    public void testNotConnectedLoad_RepByRef() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        jej.setJobObjectId((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID);
        jej.loadXML(this.getNode(jej), this.databases, this.servers, null, this.store);
        jej.getJobMeta(null, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{null, null, this.store, null});
    }

    @Test
    public void testNotConnectedLoad_RepByName() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        jej.setJobName("job.kjb");
        jej.setDirectory("/public/test");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, null, this.store);
        jej.getJobMeta(null, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{null, null, this.store, null});
    }

    @Test
    public void testNotConnectedLoad_Filename() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jej.setFileName("/home/ljm/job.kjb");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, null, this.store);
        jej.getJobMeta(null, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"/home/ljm/job.kjb", null, this.store, null});
    }

    @Test
    public void testConnectedImport_NoInfo() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
    }

    @Test
    public void testConnectedImport_RepByRef() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        jej.setJobObjectId((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID);
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).loadJob((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, null);
    }

    @Test
    public void testConnectedImport_RepByName() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        jej.setJobName("job.kjb");
        jej.setDirectory("/public/test");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedImport_Filename() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jej.setFileName("/home/ljm/job.kjb");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"/home/ljm/job.kjb", this.repository, this.store, null});
    }

    @Test
    public void testConnectedImport_RepByRef_Guess() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setJobObjectId((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID);
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).loadJob((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, null);
    }

    @Test
    public void testConnectedImport_RepByName_Guess() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setJobName("job.kjb");
        jej.setDirectory("/public/test");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedImport_Filename_Guess() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setFileName("/home/ljm/job.kjb");
        jej.loadXML(this.getNode(jej), this.databases, this.servers, this.repository, this.store);
        jej.getJobMeta(this.repository, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"/home/ljm/job.kjb", this.repository, this.store, null});
    }

    @Test
    public void testConnectedLoad_NoInfo() throws Exception {
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(this.repository, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
    }

    @Test
    public void testConnectedLoad_RepByRef() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"rep_ref").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)this.JOB_ENTRY_JOB_OBJECT_ID.toString()).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "job_object_id");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, null);
    }

    @Test
    public void testConnectedLoad_RepByName() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn((Object)this.rdi).when((Object)myrepo)).loadRepositoryDirectoryTree();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"rep_name").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)"job.kjb").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "name");
        ((Repository)Mockito.doReturn((Object)"/public/test").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "dir_path");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedLoad_Filename() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"filename").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)"/home/ljm/job.kjb").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "file_name");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"/home/ljm/job.kjb", myrepo, this.store, null});
    }

    @Test
    public void testConnectedLoad_RepByName_HDFS() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"rep_name").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)"job").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "name");
        ((Repository)Mockito.doReturn((Object)"${hdfs}").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "dir_path");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"hdfs://server/path/job.kjb", myrepo, this.store, null});
    }

    @Test
    public void testConnectedLoad_RepByName_SingleParameter() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn((Object)this.rdi).when((Object)myrepo)).loadRepositoryDirectoryTree();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"rep_name").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)"${repositoryfullfilepath}").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "name");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedLoad_RepByName_MultipleParameters() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn((Object)this.rdi).when((Object)myrepo)).loadRepositoryDirectoryTree();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"rep_name").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "specification_method");
        ((Repository)Mockito.doReturn((Object)"${jobname}").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "name");
        ((Repository)Mockito.doReturn((Object)"${repositorypath}").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "dir_path");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedLoad_RepByRef_Guess() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)this.JOB_ENTRY_JOB_OBJECT_ID.toString()).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "job_object_id");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, null);
    }

    @Test
    public void testConnectedLoad_RepByName_Guess() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn((Object)this.rdi).when((Object)myrepo)).loadRepositoryDirectoryTree();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"job.kjb").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "name");
        ((Repository)Mockito.doReturn((Object)"/public/test").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "dir_path");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, (Object)jej.getSpecificationMethod());
        ((Repository)Mockito.verify((Object)myrepo, (VerificationMode)Mockito.times((int)1))).loadJob("job.kjb", this.directory, null, null);
    }

    @Test
    public void testConnectedLoad_Filename_Guess() throws Exception {
        Repository myrepo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn((Object)true).when((Object)myrepo)).isConnected();
        ((Repository)Mockito.doReturn(null).when((Object)myrepo)).getJobEntryAttributeString((ObjectId)Mockito.any(ObjectId.class), Matchers.anyString());
        ((Repository)Mockito.doReturn((Object)"/home/ljm/job.kjb").when((Object)myrepo)).getJobEntryAttributeString((ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, "file_name");
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.loadRep(myrepo, this.store, (ObjectId)this.JOB_ENTRY_JOB_OBJECT_ID, this.databases, this.servers);
        jej.getJobMeta(myrepo, this.store, this.space);
        Assert.assertEquals((Object)ObjectLocationSpecificationMethod.FILENAME, (Object)jej.getSpecificationMethod());
        PowerMockito.verifyNew(JobMeta.class).withArguments((Object)this.space, new Object[]{"/home/ljm/job.kjb", myrepo, this.store, null});
    }

    private Node getNode(JobEntryJob jej) throws Exception {
        String string = "<job>" + jej.getXML() + "</job>";
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(stream).getFirstChild();
    }

    @Test
    public void testCurrDirListener() throws Exception {
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        JobEntryJob jej = new JobEntryJob("My Job");
        jej.setParentJobMeta(null);
        jej.setParentJobMeta(meta);
        jej.setParentJobMeta(null);
        ((JobMeta)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).addCurrentDirectoryChangedListener((CurrentDirectoryChangedListener)Mockito.any());
        ((JobMeta)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).removeCurrentDirectoryChangedListener((CurrentDirectoryChangedListener)Mockito.any());
    }

    @Test
    public void testExportResources() throws Exception {
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        JobEntryJob jej = (JobEntryJob)Mockito.spy((Object)new JobEntryJob("My Job"));
        jej.setDescription("This is yet another job");
        ((JobEntryJob)Mockito.doReturn((Object)meta).when((Object)jej)).getJobMeta((Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class), (VariableSpace)Mockito.any(VariableSpace.class));
        ((JobMeta)Mockito.doReturn((Object)"My Job").when((Object)meta)).exportResources((VariableSpace)Mockito.any(JobMeta.class), (Map)Mockito.any(Map.class), (ResourceNamingInterface)Mockito.any(ResourceNamingInterface.class), (Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class));
        jej.exportResources(null, null, null, null, null);
        ((JobMeta)Mockito.verify((Object)meta)).setFilename("${Internal.Entry.Current.Directory}/My Job");
        ((JobEntryJob)Mockito.verify((Object)jej)).setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }
}

