/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJobRunner;

public class JobEntryJobRunnerTest {
    private JobEntryJobRunner jobRunner;
    private Job mockJob;
    private JobMeta mockJobMeta;
    private Result mockResult;
    private LogChannelInterface mockLog;
    private Job parentJob;

    @Before
    public void setUp() throws Exception {
        this.mockJob = (Job)Mockito.mock(Job.class);
        this.mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        this.mockResult = (Result)Mockito.mock(Result.class);
        this.mockLog = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        this.jobRunner = new JobEntryJobRunner(this.mockJob, this.mockResult, 0, this.mockLog);
        this.parentJob = (Job)Mockito.mock(Job.class);
    }

    @Test
    public void testRun() throws Exception {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)true);
        this.jobRunner.run();
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn(null);
        Mockito.when((Object)this.mockJob.getJobMeta()).thenReturn((Object)this.mockJobMeta);
        this.jobRunner.run();
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)true);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        this.jobRunner.run();
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        this.jobRunner.run();
    }

    @Test
    public void testRunSetsResult() throws Exception {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        this.jobRunner.run();
        ((Job)Mockito.verify((Object)this.mockJob, (VerificationMode)Mockito.times((int)1))).setResult((Result)Mockito.any(Result.class));
    }

    @Test
    public void testRunWithExceptionOnExecuteSetsResult() throws Exception {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        ((Job)Mockito.doThrow(KettleException.class).when((Object)this.mockJob)).execute(Matchers.anyInt(), (Result)Matchers.any(Result.class));
        this.jobRunner.run();
        ((Job)Mockito.verify((Object)this.mockJob, (VerificationMode)Mockito.times((int)1))).setResult((Result)Mockito.any(Result.class));
    }

    @Test
    public void testRunWithExceptionOnFireJobSetsResult() throws KettleException {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        ((Job)Mockito.doThrow(Exception.class).when((Object)this.mockJob)).fireJobFinishListeners();
        this.jobRunner.run();
        ((Job)Mockito.verify((Object)this.mockJob, (VerificationMode)Mockito.times((int)1))).setResult((Result)Mockito.any(Result.class));
        Assert.assertTrue((boolean)this.jobRunner.isFinished());
    }

    @Test
    public void testRunWithExceptionOnExecuteAndFireJobSetsResult() throws KettleException {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        ((Job)Mockito.doThrow(KettleException.class).when((Object)this.mockJob)).execute(Matchers.anyInt(), (Result)Matchers.any(Result.class));
        ((Job)Mockito.doThrow(Exception.class).when((Object)this.mockJob)).fireJobFinishListeners();
        this.jobRunner.run();
        ((Job)Mockito.verify((Object)this.mockJob, (VerificationMode)Mockito.times((int)1))).setResult((Result)Mockito.any(Result.class));
        Assert.assertTrue((boolean)this.jobRunner.isFinished());
    }

    @Test
    public void testRunWithException() throws Exception {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.mockJob.getJobMeta()).thenReturn((Object)this.mockJobMeta);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        ((Job)Mockito.doThrow(KettleException.class).when((Object)this.mockJob)).execute(Matchers.anyInt(), (Result)Matchers.any(Result.class));
        this.jobRunner.run();
        ((Result)Mockito.verify((Object)this.mockResult, (VerificationMode)Mockito.times((int)1))).setNrErrors((long)Mockito.anyInt());
        ((Job)Mockito.doThrow(Exception.class).when((Object)this.mockJob)).fireJobFinishListeners();
        this.jobRunner.run();
    }

    @Test
    public void testGetSetResult() throws Exception {
        Assert.assertEquals((Object)this.mockResult, (Object)this.jobRunner.getResult());
        this.jobRunner.setResult(null);
        Assert.assertNull((Object)this.jobRunner.getResult());
    }

    @Test
    public void testGetSetLog() throws Exception {
        Assert.assertEquals((Object)this.mockLog, (Object)this.jobRunner.getLog());
        this.jobRunner.setLog(null);
        Assert.assertNull((Object)this.jobRunner.getLog());
    }

    @Test
    public void testGetSetJob() throws Exception {
        Assert.assertEquals((Object)this.mockJob, (Object)this.jobRunner.getJob());
        this.jobRunner.setJob(null);
        Assert.assertNull((Object)this.jobRunner.getJob());
    }

    @Test
    public void testGetSetEntryNr() throws Exception {
        Assert.assertEquals((long)0L, (long)this.jobRunner.getEntryNr());
        this.jobRunner.setEntryNr(1);
        Assert.assertEquals((long)1L, (long)this.jobRunner.getEntryNr());
    }

    @Test
    public void testIsFinished() throws Exception {
        Assert.assertFalse((boolean)this.jobRunner.isFinished());
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        this.jobRunner.run();
        Assert.assertTrue((boolean)this.jobRunner.isFinished());
    }

    @Test
    public void testWaitUntilFinished() throws Exception {
        Mockito.when((Object)this.mockJob.isStopped()).thenReturn((Object)true);
        Mockito.when((Object)this.mockJob.getParentJob()).thenReturn((Object)this.parentJob);
        Mockito.when((Object)this.parentJob.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)this.mockJob.execute(Mockito.anyInt(), (Result)Mockito.any(Result.class))).thenReturn((Object)this.mockResult);
        this.jobRunner.waitUntilFinished();
    }
}

