/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.http;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.job.entries.http.JobEntryHTTP;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.metastore.api.IMetaStore;

public class JobEntryHTTPTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private JobEntryHTTP jobEntryHttp = new JobEntryHTTP();
    private KettleDatabaseRepository ktlDbRepMock = (KettleDatabaseRepository)Mockito.mock(KettleDatabaseRepository.class);
    private ObjectId objIdMock = (ObjectId)Mockito.mock(ObjectId.class);

    @BeforeClass
    public static void beforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Test
    public void testDateTimeAddedFieldIsSetInTrue_WhenRepoReturnsTrue() throws KettleException {
        Mockito.when((Object)this.ktlDbRepMock.getJobEntryAttributeBoolean(this.objIdMock, "date_time_added")).thenReturn((Object)true);
        this.jobEntryHttp.loadRep((Repository)this.ktlDbRepMock, (IMetaStore)this.ktlDbRepMock.getMetaStore(), this.objIdMock, null, null);
        ((KettleDatabaseRepository)Mockito.verify((Object)this.ktlDbRepMock, (VerificationMode)Mockito.never())).getJobEntryAttributeString(this.objIdMock, "date_time_added");
        ((KettleDatabaseRepository)Mockito.verify((Object)this.ktlDbRepMock)).getJobEntryAttributeBoolean(this.objIdMock, "date_time_added");
        Assert.assertTrue((String)"DateTimeAdded field should be TRUE.", (boolean)this.jobEntryHttp.isDateTimeAdded());
    }

    @Test
    public void testDeprecatedTargetFilenameExtension() {
        this.jobEntryHttp.setTargetFilenameExtention("txt");
        Assert.assertTrue((boolean)"txt".equals(this.jobEntryHttp.getTargetFilenameExtension()));
        this.jobEntryHttp.setTargetFilenameExtension("zip");
        Assert.assertTrue((boolean)"zip".equals(this.jobEntryHttp.getTargetFilenameExtention()));
    }
}

