/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import java.io.File;
import java.io.IOException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.entries.getpop.MailConnection;

public class MailConnectionTest {
    private Mconn conn;

    @Before
    public void beforeExec() throws KettleException, MessagingException {
        Object subj = new Object();
        LogChannel log = new LogChannel(subj);
        this.conn = new Mconn((LogChannelInterface)log);
    }

    @Test
    public void openFolderTest() throws KettleException, MessagingException {
        this.conn.openFolder("a/b", false, false);
        Folder folder = this.conn.getFolder();
        Assert.assertEquals((String)"Folder B is opened", (Object)"B", (Object)folder.getFullName());
    }

    @Test
    public void setDestinationFolderTest() throws KettleException, MessagingException {
        this.conn.setDestinationFolder("a/b/c", true);
        Assert.assertTrue((String)"Folder C created", (boolean)this.conn.cCreated);
        Assert.assertEquals((String)"Folder created with holds messages mode", (long)1L, (long)this.conn.mode.intValue());
    }

    @Test
    public void findValidTargetTest() throws IOException, KettleException {
        File aFile = null;
        String tmpFileLocation = System.getProperty("java.io.tmpdir");
        String aBaseFile = "pdi17713-.junk";
        if (!(tmpFileLocation = tmpFileLocation.replace("\\", "/")).endsWith("/")) {
            tmpFileLocation = tmpFileLocation + "/";
        }
        for (int i = 0; i < 3; ++i) {
            aFile = new File(tmpFileLocation + "pdi17713-" + i + ".junk");
            if (!aFile.exists()) {
                MailConnectionTest.makeAFile(aFile);
            }
            if ((aFile = new File(tmpFileLocation + "pdi17713-" + i)).exists()) continue;
            MailConnectionTest.makeAFile(aFile);
        }
        String validTargetTestRtn = MailConnection.findValidTarget((String)tmpFileLocation, (String)aBaseFile);
        Assert.assertTrue((String)"Original file name should be tried first.", (boolean)validTargetTestRtn.endsWith(aBaseFile));
        MailConnectionTest.makeAFile(tmpFileLocation + aBaseFile);
        validTargetTestRtn = MailConnection.findValidTarget((String)tmpFileLocation, (String)aBaseFile);
        Assert.assertTrue((String)"File extension test failed - expected pdi17713-3.junk as file name", (boolean)validTargetTestRtn.endsWith("pdi17713-3.junk"));
        aBaseFile = "pdi17713-";
        validTargetTestRtn = MailConnection.findValidTarget((String)tmpFileLocation, (String)aBaseFile);
        Assert.assertTrue((String)"Original file name should be tried first.", (boolean)validTargetTestRtn.endsWith(aBaseFile));
        MailConnectionTest.makeAFile(tmpFileLocation + aBaseFile);
        validTargetTestRtn = MailConnection.findValidTarget((String)tmpFileLocation, (String)aBaseFile);
        Assert.assertTrue((String)"File without extension test failed - expected pdi17713-3.junk as file name", (boolean)validTargetTestRtn.endsWith("pdi17713-3"));
        try {
            validTargetTestRtn = MailConnection.findValidTarget(null, (String)"wibble");
            Assert.fail((String)"Expected an IllegalArgumentException with a null parameter for folderName to findValidTarget");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            validTargetTestRtn = MailConnection.findValidTarget((String)"wibble", null);
            Assert.fail((String)"Expected an IllegalArgumentException with a null parameter for fileName to findValidTarget");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void folderExistsTest() {
        boolean actual = this.conn.folderExists("a/b");
        Assert.assertTrue((String)"Folder B exists", (boolean)actual);
    }

    private static void makeAFile(String path) throws IOException {
        File aFile = new File(path);
        MailConnectionTest.makeAFile(aFile);
    }

    private static void makeAFile(File aFile) throws IOException {
        aFile.createNewFile();
        aFile.deleteOnExit();
    }

    private class Mconn
    extends MailConnection {
        Store store;
        Folder a;
        Folder b;
        Folder c;
        Folder inbox;
        Integer mode;
        boolean cCreated;

        public Mconn(LogChannelInterface log) throws KettleException, MessagingException {
            super(log, 1, "junit", 0, "junit", "junit", false, false, "junit");
            this.mode = -1;
            this.cCreated = false;
            this.store = (Store)Mockito.mock(Store.class);
            this.inbox = (Folder)Mockito.mock(Folder.class);
            this.a = (Folder)Mockito.mock(Folder.class);
            this.b = (Folder)Mockito.mock(Folder.class);
            this.c = (Folder)Mockito.mock(Folder.class);
            Mockito.when((Object)this.a.getFullName()).thenReturn((Object)"A");
            Mockito.when((Object)this.b.getFullName()).thenReturn((Object)"B");
            Mockito.when((Object)this.c.getFullName()).thenReturn((Object)"C");
            Mockito.when((Object)this.a.exists()).thenReturn((Object)true);
            Mockito.when((Object)this.b.exists()).thenReturn((Object)true);
            Mockito.when((Object)this.c.exists()).thenReturn((Object)this.cCreated);
            Mockito.when((Object)this.c.create(Mockito.anyInt())).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    Object arg0 = invocation.getArguments()[0];
                    Mconn.this.mode = (Integer)Integer.class.cast(arg0);
                    Mconn.this.cCreated = true;
                    return true;
                }
            });
            Mockito.when((Object)this.inbox.getFolder("a")).thenReturn((Object)this.a);
            Mockito.when((Object)this.a.getFolder("b")).thenReturn((Object)this.b);
            Mockito.when((Object)this.b.getFolder("c")).thenReturn((Object)this.c);
            Mockito.when((Object)this.store.getDefaultFolder()).thenReturn((Object)this.inbox);
        }

        public Store getStore() {
            return this.store;
        }
    }
}

