/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpsget;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.vfs2.FileObject;
import org.ftp4che.FTPConnection;
import org.ftp4che.commands.Command;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.reply.Reply;
import org.ftp4che.util.ftpfile.FTPFileFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.entries.ftpsget.FTPSConnection;
import org.pentaho.di.job.entries.ftpsget.ftp4che.SecureDataFTPConnection;

public class FTPSConnectionTest {
    @Test
    public void testEnforceProtP() throws Exception {
        FTPSTestConnection connection = (FTPSTestConnection)((Object)Mockito.spy((Object)((Object)new FTPSTestConnection(6, "the.perfect.host", 2010, "warwickw", "julia", null))));
        connection.replies.put("PWD", new Reply(Arrays.asList("257 \"/la\" is current directory")));
        connection.connect();
        connection.getFileNames();
        Assert.assertEquals((String)"buffer not set", (Object)"PBSZ 0\r\n", (Object)connection.commands.get(1).toString());
        Assert.assertEquals((String)"data privacy not set", (Object)"PROT P\r\n", (Object)connection.commands.get(2).toString());
    }

    @Test
    public void testEnforceProtPOnPut() throws Exception {
        FileObject file = KettleVFS.createTempFile((String)"FTPSConnectionTest_testEnforceProtPOnPut", (KettleVFS.Suffix)KettleVFS.Suffix.TMP);
        file.createFile();
        try {
            FTPSTestConnection connection = (FTPSTestConnection)((Object)Mockito.spy((Object)((Object)new FTPSTestConnection(6, "the.perfect.host", 2010, "warwickw", "julia", null))));
            connection.replies.put("PWD", new Reply(Arrays.asList("257 \"/la\" is current directory")));
            connection.connect();
            connection.uploadFile(file.getPublicURIString(), "uploaded-file");
            Assert.assertEquals((String)"buffer not set", (Object)"PBSZ 0\r\n", (Object)connection.commands.get(0).toString());
            Assert.assertEquals((String)"data privacy not set", (Object)"PROT P\r\n", (Object)connection.commands.get(1).toString());
        }
        finally {
            file.delete();
        }
    }

    static class FTPSTestConnection
    extends FTPSConnection {
        public List<Command> commands = new ArrayList<Command>();
        public SocketProvider connectionSocketProvider;
        public Map<String, Reply> replies = new HashMap<String, Reply>();

        public FTPSTestConnection(int connectionType, String hostname, int port, String username, String password, VariableSpace nameSpace) {
            super(connectionType, hostname, port, username, password, nameSpace);
        }

        protected FTPConnection getSecureDataFTPConnection(FTPConnection connection, String password, int timeout) throws ConfigurationException {
            return new SecureDataFTPConnection(connection, password, timeout){
                private Reply dummyReply;
                {
                    super(x0, x1, x2);
                    this.dummyReply = new Reply();
                }

                public void connect() throws NotConnectedException, IOException, AuthenticationNotSupportedException, FtpIOException, FtpWorkflowException {
                    this.socketProvider = (SocketProvider)Mockito.mock(SocketProvider.class);
                    Mockito.when((Object)this.socketProvider.socket()).thenReturn(Mockito.mock(Socket.class));
                    Mockito.when((Object)this.socketProvider.read((ByteBuffer)Mockito.any())).thenReturn((Object)-1);
                    connectionSocketProvider = this.socketProvider;
                    this.factory = new FTPFileFactory("UNIX");
                }

                public SocketProvider sendPortCommand(Command command, Reply commandReply) throws IOException, FtpWorkflowException, FtpIOException {
                    return this.socketProvider;
                }

                public Reply sendCommand(Command cmd) throws IOException {
                    commands.add(cmd);
                    return Optional.ofNullable(replies.get(cmd.getCommand())).orElse(this.dummyReply);
                }
            };
        }
    }
}

