/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftp.JobEntryFTP;
import org.pentaho.di.job.entries.ftp.MockedJobEntryFTP;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.utils.TestUtils;

public class JobEntryFTPTest {
    private Job job;
    private JobEntryFTP entry;
    private String existingDir;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.job = new Job(null, new JobMeta());
        this.entry = new MockedJobEntryFTP();
        this.job.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.entry));
        this.entry.setParentJob(this.job);
        this.job.setStopped(false);
        this.entry.setServerName("some.server");
        this.entry.setUserName("anonymous");
        this.entry.setFtpDirectory(".");
        this.entry.setWildcard("robots.txt");
        this.entry.setBinaryMode(false);
        this.entry.setSuccessCondition("success_if_no_errors");
        this.existingDir = TestUtils.createTempDir();
    }

    @After
    public void tearDown() throws Exception {
        File fl = new File(this.existingDir);
        if (!fl.exists()) {
            return;
        }
        File[] fls = fl.listFiles();
        if (fls == null || fls.length == 0) {
            return;
        }
        fls[0].delete();
        fl.delete();
    }

    @Test
    public void testFixedExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory(this.existingDir);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"For existing folder should be true", (boolean)result.getResult());
        Assert.assertEquals((String)"There should be no errors", (long)0L, (long)result.getNrErrors());
    }

    @Test
    public void testFixedNonExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory(this.existingDir + File.separator + "sub");
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"For non existing folder should be false", (boolean)result.getResult());
        Assert.assertTrue((String)"There should be errors", (0L != result.getNrErrors() ? 1 : 0) != 0);
    }

    @Test
    public void testVariableExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory("${Internal.Job.Filename.Directory}");
        this.entry.setVariable("Internal.Job.Filename.Directory", this.existingDir);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"For existing folder should be true", (boolean)result.getResult());
        Assert.assertEquals((String)"There should be no errors", (long)0L, (long)result.getNrErrors());
    }

    @Test
    public void testVariableNonExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory("${Internal.Job.Filename.Directory}/Worg");
        this.entry.setVariable("Internal.Job.Filename.Directory", this.existingDir + File.separator + "sub");
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"For non existing folder should be false", (boolean)result.getResult());
        Assert.assertTrue((String)"There should be errors", (0L != result.getNrErrors() ? 1 : 0) != 0);
    }

    @Test
    public void testProtocolVariableExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory("${Internal.Job.Filename.Directory}");
        this.entry.setVariable("Internal.Job.Filename.Directory", "file://" + this.existingDir);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"For existing folder should be true", (boolean)result.getResult());
        Assert.assertEquals((String)"There should be no errors", (long)0L, (long)result.getNrErrors());
    }

    @Test
    public void testPtotocolVariableNonExistingTargetDir() throws Exception {
        this.entry.setTargetDirectory("${Internal.Job.Filename.Directory}/Worg");
        this.entry.setVariable("Internal.Job.Filename.Directory", "file://" + this.existingDir + File.separator + "sub");
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"For non existing folder should be false", (boolean)result.getResult());
        Assert.assertTrue((String)"There should be errors", (0L != result.getNrErrors() ? 1 : 0) != 0);
    }

    @Test
    public void testTargetFilenameNoDateTime() throws Exception {
        File destFolder = this.tempFolder.newFolder("pdi5558");
        destFolder.deleteOnExit();
        JobEntryFTP entry = new JobEntryFTP();
        entry.setTargetDirectory(destFolder.getAbsolutePath());
        entry.setAddDateBeforeExtension(false);
        Assert.assertNull((Object)entry.returnTargetFilename(null));
        Assert.assertEquals((Object)(destFolder.getAbsolutePath() + Const.FILE_SEPARATOR + "testFile"), (Object)entry.returnTargetFilename("testFile"));
        Assert.assertEquals((Object)(destFolder.getAbsolutePath() + Const.FILE_SEPARATOR + "testFile.txt"), (Object)entry.returnTargetFilename("testFile.txt"));
    }

    @Test
    public void testTargetFilenameWithDateTime() throws Exception {
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat HHmmssSSS = new SimpleDateFormat("HHmmssSSS");
        SimpleDateFormat yyyyMMddHHmmssSSS = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        File destFolder = this.tempFolder.newFolder("pdi5558");
        destFolder.deleteOnExit();
        String destFolderName = destFolder.getAbsolutePath();
        JobEntryFTP entry = new JobEntryFTP();
        entry.setTargetDirectory(destFolderName);
        entry.setAddDateBeforeExtension(true);
        entry.setDateInFilename(true);
        Assert.assertNull((Object)entry.returnTargetFilename(null));
        Assert.assertEquals((String)"Test Add Date without file extension", (Object)(destFolderName + Const.FILE_SEPARATOR + "testFile_" + yyyyMMdd.format(new Date())), (Object)entry.returnTargetFilename("testFile"));
        Assert.assertEquals((String)"Test Add Date with file extension", (Object)(destFolderName + Const.FILE_SEPARATOR + "testFile_" + yyyyMMdd.format(new Date()) + ".txt"), (Object)entry.returnTargetFilename("testFile.txt"));
        entry.setTimeInFilename(true);
        String beforeString = destFolderName + Const.FILE_SEPARATOR + "testFile_" + yyyyMMddHHmmssSSS.format(new Date()) + ".txt";
        String actualValue = entry.returnTargetFilename("testFile.txt");
        String afterString = destFolderName + Const.FILE_SEPARATOR + "testFile_" + yyyyMMddHHmmssSSS.format(new Date()) + ".txt";
        Pattern expectedFormat = Pattern.compile(Pattern.quote(destFolderName + Const.FILE_SEPARATOR + "testFile_" + yyyyMMdd.format(new Date()) + "_") + "([\\d]{9})\\.txt");
        Assert.assertTrue((String)"Output file matches expected format", (boolean)expectedFormat.matcher(actualValue).matches());
        Assert.assertTrue((String)"The actual time is not too early for test run", (actualValue.compareTo(beforeString) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The actual time is not too late for test run", (actualValue.compareTo(afterString) <= 0 ? 1 : 0) != 0);
        entry.setDateInFilename(false);
        beforeString = destFolderName + Const.FILE_SEPARATOR + "testFile_" + HHmmssSSS.format(new Date()) + ".txt";
        actualValue = entry.returnTargetFilename("testFile.txt");
        afterString = destFolderName + Const.FILE_SEPARATOR + "testFile_" + HHmmssSSS.format(new Date()) + ".txt";
        expectedFormat = Pattern.compile(Pattern.quote(destFolderName + Const.FILE_SEPARATOR + "testFile_") + "([\\d]{9})\\.txt");
        Assert.assertTrue((String)"Output file matches expected format", (boolean)expectedFormat.matcher(actualValue).matches());
        Assert.assertTrue((String)"The actual time is not too early for test run", (actualValue.compareTo(beforeString) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The actual time is not too late for test run", (actualValue.compareTo(afterString) <= 0 ? 1 : 0) != 0);
    }
}

