/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.folderisempty;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.folderisempty.JobEntryFolderIsEmpty;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobEntryFolderIsEmptyTest {
    private Job job;
    private JobEntryFolderIsEmpty entry;
    private String emptyDir;
    private String nonEmptyDir;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleLogStore.init();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.job = new Job(null, new JobMeta());
        this.entry = new JobEntryFolderIsEmpty();
        this.job.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.entry));
        this.entry.setParentJob(this.job);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        this.entry.setParentJobMeta(mockJobMeta);
        this.job.setStopped(false);
        File dir = Files.createTempDirectory("dir", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        this.emptyDir = dir.getPath();
        dir = Files.createTempDirectory("dir", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        this.nonEmptyDir = dir.getPath();
        File file = File.createTempFile("existingFile", "ext", dir);
        file.deleteOnExit();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSetNrErrorsSuccess() throws Exception {
        this.entry.setFoldername(this.emptyDir);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"For empty folder result should be true", (boolean)result.getResult());
        Assert.assertEquals((String)"There should be no errors", (long)0L, (long)result.getNrErrors());
    }

    @Test
    public void testSetNrErrorsNewBehaviorFail() throws Exception {
        this.entry.setFoldername(this.nonEmptyDir);
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"For non-empty folder result should be false", (boolean)result.getResult());
        Assert.assertEquals((String)"There should be still no errors", (long)0L, (long)result.getNrErrors());
    }

    @Test
    public void testSetNrErrorsOldBehaviorFail() throws Exception {
        this.entry.setFoldername(this.nonEmptyDir);
        this.entry.setVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "Y");
        Result result = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"For non-empty folder result should be false", (boolean)result.getResult());
        Assert.assertEquals((String)"According to old behaviour there should be an error", (long)1L, (long)result.getNrErrors());
    }
}

