/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefiles;

import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.deletefiles.JobEntryDeleteFiles;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;

public class JobEntryDeleteFilesTest {
    private final String PATH_TO_FILE = "path/to/file";
    private final String STRING_SPACES_ONLY = "   ";
    private JobEntryDeleteFiles jobEntry;
    private NamedClusterEmbedManager mockNamedClusterEmbedManager;

    @Before
    public void setUp() throws Exception {
        this.jobEntry = new JobEntryDeleteFiles();
        Job parentJob = (Job)Mockito.mock(Job.class);
        ((Job)Mockito.doReturn((Object)false).when((Object)parentJob)).isStopped();
        this.jobEntry.setParentJob(parentJob);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        this.mockNamedClusterEmbedManager = (NamedClusterEmbedManager)Mockito.mock(NamedClusterEmbedManager.class);
        Mockito.when((Object)mockJobMeta.getNamedClusterEmbedManager()).thenReturn((Object)this.mockNamedClusterEmbedManager);
        this.jobEntry.setParentJobMeta(mockJobMeta);
        this.jobEntry = (JobEntryDeleteFiles)Mockito.spy((Object)this.jobEntry);
        ((JobEntryDeleteFiles)Mockito.doReturn((Object)true).when((Object)this.jobEntry)).processFile(Matchers.anyString(), Matchers.anyString(), (Job)Mockito.eq((Object)parentJob));
    }

    @Test
    public void filesWithNoPath_AreNotProcessed_ArgsOfCurrentJob() throws Exception {
        this.jobEntry.setArguments(new String[]{"", "   "});
        this.jobEntry.setFilemasks(new String[]{null, null});
        this.jobEntry.setArgFromPrevious(false);
        this.jobEntry.execute(new Result(), 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry, (VerificationMode)Mockito.never())).processFile(Matchers.anyString(), Matchers.anyString(), (Job)Matchers.any(Job.class));
    }

    @Test
    public void filesWithPath_AreProcessed_ArgsOfCurrentJob() throws Exception {
        String[] args = new String[]{"path/to/file"};
        this.jobEntry.setArguments(args);
        this.jobEntry.setFilemasks(new String[]{null, null});
        this.jobEntry.setArgFromPrevious(false);
        this.jobEntry.execute(new Result(), 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry, (VerificationMode)Mockito.times((int)args.length))).processFile(Matchers.anyString(), Matchers.anyString(), (Job)Matchers.any(Job.class));
        ((NamedClusterEmbedManager)Mockito.verify((Object)this.mockNamedClusterEmbedManager)).passEmbeddedMetastoreKey((VariableSpace)Mockito.anyObject(), Matchers.anyString());
    }

    @Test
    public void filesWithNoPath_AreNotProcessed_ArgsOfPreviousMeta() throws Exception {
        this.jobEntry.setArgFromPrevious(true);
        Result prevMetaResult = new Result();
        ArrayList<RowMetaAndData> metaAndDataList = new ArrayList<RowMetaAndData>();
        metaAndDataList.add(this.constructRowMetaAndData("", null));
        metaAndDataList.add(this.constructRowMetaAndData("   ", null));
        prevMetaResult.setRows(metaAndDataList);
        this.jobEntry.execute(prevMetaResult, 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry, (VerificationMode)Mockito.never())).processFile(Matchers.anyString(), Matchers.anyString(), (Job)Matchers.any(Job.class));
    }

    @Test
    public void filesPath_AreProcessed_ArgsOfPreviousMeta() throws Exception {
        this.jobEntry.setArgFromPrevious(true);
        Result prevMetaResult = new Result();
        ArrayList<RowMetaAndData> metaAndDataList = new ArrayList<RowMetaAndData>();
        metaAndDataList.add(this.constructRowMetaAndData("path/to/file", null));
        prevMetaResult.setRows(metaAndDataList);
        this.jobEntry.execute(prevMetaResult, 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry, (VerificationMode)Mockito.times((int)metaAndDataList.size()))).processFile(Matchers.anyString(), Matchers.anyString(), (Job)Matchers.any(Job.class));
    }

    @Test
    public void filesPathVariables_AreProcessed_OnlyIfValueIsNotBlank() throws Exception {
        String pathToFileBlankValue = "pathToFileBlankValue";
        String pathToFileValidValue = "pathToFileValidValue";
        this.jobEntry.setVariable("pathToFileBlankValue", "");
        this.jobEntry.setVariable("pathToFileValidValue", "path/to/file");
        this.jobEntry.setArguments(new String[]{this.asVariable("pathToFileBlankValue"), this.asVariable("pathToFileValidValue")});
        this.jobEntry.setFilemasks(new String[]{null, null});
        this.jobEntry.setArgFromPrevious(false);
        this.jobEntry.execute(new Result(), 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry)).processFile((String)Mockito.eq((Object)"path/to/file"), Matchers.anyString(), (Job)Matchers.any(Job.class));
    }

    @Test
    public void specifyingTheSamePath_WithDifferentWildcards() throws Exception {
        String fileExtensionTxt = ".txt";
        String fileExtensionXml = ".xml";
        String[] args = new String[]{"path/to/file", "path/to/file"};
        this.jobEntry.setArguments(args);
        this.jobEntry.setFilemasks(new String[]{".txt", ".xml"});
        this.jobEntry.setArgFromPrevious(false);
        this.jobEntry.execute(new Result(), 0);
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry)).processFile((String)Mockito.eq((Object)"path/to/file"), (String)Mockito.eq((Object)".txt"), (Job)Matchers.any(Job.class));
        ((JobEntryDeleteFiles)Mockito.verify((Object)this.jobEntry)).processFile((String)Mockito.eq((Object)"path/to/file"), (String)Mockito.eq((Object)".xml"), (Job)Matchers.any(Job.class));
    }

    private RowMetaAndData constructRowMetaAndData(Object ... data) {
        RowMeta meta = new RowMeta();
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("filePath"));
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("wildcard"));
        return new RowMetaAndData((RowMetaInterface)meta, data);
    }

    private String asVariable(String variable) {
        return "${" + variable + "}";
    }
}

