/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copyfiles;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.w3c.dom.Node;

public class JobEntryCopyFilesTest {
    private JobEntryCopyFiles entry;
    private NamedClusterEmbedManager mockNamedClusterEmbedManager;
    private final String EMPTY = "";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleLogStore.init();
    }

    @Before
    public void setUp() {
        this.entry = new JobEntryCopyFiles();
        Job parentJob = new Job();
        this.entry.setParentJob(parentJob);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        this.mockNamedClusterEmbedManager = (NamedClusterEmbedManager)Mockito.mock(NamedClusterEmbedManager.class);
        Mockito.when((Object)mockJobMeta.getNamedClusterEmbedManager()).thenReturn((Object)this.mockNamedClusterEmbedManager);
        this.entry.setParentJobMeta(mockJobMeta);
        this.entry = (JobEntryCopyFiles)Mockito.spy((Object)this.entry);
    }

    @Test
    public void fileNotCopied() throws Exception {
        this.entry.source_filefolder = new String[]{""};
        this.entry.destination_filefolder = new String[]{""};
        this.entry.wildcard = new String[]{""};
        this.entry.execute(new Result(), 0);
        ((JobEntryCopyFiles)Mockito.verify((Object)this.entry, (VerificationMode)Mockito.never())).processFileFolder(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (Job)Mockito.any(Job.class), (Result)Mockito.any(Result.class));
    }

    @Test
    public void fileCopied() throws Exception {
        String srcPath = "path/to/file";
        String destPath = "path/to/dir";
        this.entry.source_filefolder = new String[]{srcPath};
        this.entry.destination_filefolder = new String[]{destPath};
        this.entry.wildcard = new String[]{""};
        Result result = this.entry.execute(new Result(), 0);
        ((JobEntryCopyFiles)Mockito.verify((Object)this.entry)).processFileFolder(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (Job)Mockito.any(Job.class), (Result)Mockito.any(Result.class));
        ((JobEntryCopyFiles)Mockito.verify((Object)this.entry, (VerificationMode)Mockito.atLeast((int)1))).preprocessfilefilder((String[])Mockito.any(String[].class));
        Assert.assertFalse((boolean)result.getResult());
        Assert.assertEquals((long)1L, (long)result.getNrErrors());
        ((NamedClusterEmbedManager)Mockito.verify((Object)this.mockNamedClusterEmbedManager)).passEmbeddedMetastoreKey((VariableSpace)Mockito.anyObject(), Mockito.anyString());
    }

    @Test
    public void filesCopied() throws Exception {
        String[] srcPath = new String[]{"path1", "path2", "path3"};
        String[] destPath = new String[]{"dest1", "dest2", "dest3"};
        this.entry.source_filefolder = srcPath;
        this.entry.destination_filefolder = destPath;
        this.entry.wildcard = new String[]{"", "", ""};
        Result result = this.entry.execute(new Result(), 0);
        ((JobEntryCopyFiles)Mockito.verify((Object)this.entry, (VerificationMode)Mockito.times((int)srcPath.length))).processFileFolder(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (Job)Mockito.any(Job.class), (Result)Mockito.any(Result.class));
        Assert.assertFalse((boolean)result.getResult());
        Assert.assertEquals((long)3L, (long)result.getNrErrors());
    }

    @Test
    public void saveLoad() throws Exception {
        String[] srcPath = new String[]{"EMPTY_SOURCE_URL-0-"};
        String[] destPath = new String[]{"EMPTY_DEST_URL-0-"};
        this.entry.source_filefolder = srcPath;
        this.entry.destination_filefolder = destPath;
        this.entry.wildcard = new String[]{""};
        String xml = "<entry>" + this.entry.getXML() + "</entry>";
        Assert.assertTrue((boolean)xml.contains(srcPath[0]));
        Assert.assertTrue((boolean)xml.contains(destPath[0]));
        JobEntryCopyFiles loadedentry = new JobEntryCopyFiles();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        loadedentry.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"entry"), new ArrayList(), null, null, null);
        Assert.assertTrue((boolean)loadedentry.destination_filefolder[0].equals(destPath[0]));
        Assert.assertTrue((boolean)loadedentry.source_filefolder[0].equals(srcPath[0]));
        ((NamedClusterEmbedManager)Mockito.verify((Object)this.mockNamedClusterEmbedManager, (VerificationMode)Mockito.times((int)2))).registerUrl(Mockito.anyString());
    }
}

