/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.columnsexist;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.columnsexist.JobEntryColumnsExist;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class JobEntryColumnsExistTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String TABLENAME = "TABLE";
    private static final String SCHEMANAME = "SCHEMA";
    private static final String[] COLUMNS = new String[]{"COLUMN1", "COLUMN2"};
    private JobEntryColumnsExist jobEntry;
    private Database db;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    @AfterClass
    public static void tearDown() {
        KettleEnvironment.reset();
    }

    @Before
    public void setUp() {
        Job parentJob = new Job(null, new JobMeta());
        this.jobEntry = (JobEntryColumnsExist)Mockito.spy((Object)new JobEntryColumnsExist(""));
        parentJob.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.jobEntry));
        parentJob.setStopped(false);
        this.jobEntry.setParentJob(parentJob);
        parentJob.setLogLevel(LogLevel.NOTHING);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        this.jobEntry.setDatabase(dbMeta);
        this.db = (Database)Mockito.spy((Object)new Database((LoggingObjectInterface)this.jobEntry, dbMeta));
        this.jobEntry.setParentJob(parentJob);
        this.jobEntry.setTablename(TABLENAME);
        this.jobEntry.setArguments(COLUMNS);
        this.jobEntry.setSchemaname(SCHEMANAME);
    }

    @Test
    public void jobFail_tableNameIsEmpty() throws KettleException {
        this.jobEntry.setTablename(null);
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be error", (long)1L, (long)result.getNrErrors());
        Assert.assertFalse((String)"Result should be false", (boolean)result.getResult());
    }

    @Test
    public void jobFail_columnsArrayIsEmpty() throws KettleException {
        this.jobEntry.setArguments(null);
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be error", (long)1L, (long)result.getNrErrors());
        Assert.assertFalse((String)"Result should be false", (boolean)result.getResult());
    }

    @Test
    public void jobFail_connectionIsNull() throws KettleException {
        this.jobEntry.setDatabase(null);
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be error", (long)1L, (long)result.getNrErrors());
        Assert.assertFalse((String)"Result should be false", (boolean)result.getResult());
    }

    @Test
    public void jobFail_tableNotExist() throws KettleException {
        Mockito.when((Object)this.jobEntry.getNewDatabaseFromMeta()).thenReturn((Object)this.db);
        ((Database)Mockito.doNothing().when((Object)this.db)).connect(Mockito.anyString(), (String)Mockito.any());
        ((Database)Mockito.doReturn((Object)false).when((Object)this.db)).checkTableExists(Mockito.anyString(), Mockito.anyString());
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be error", (long)1L, (long)result.getNrErrors());
        Assert.assertFalse((String)"Result should be false", (boolean)result.getResult());
        ((Database)Mockito.verify((Object)this.db, (VerificationMode)Mockito.atLeastOnce())).disconnect();
    }

    @Test
    public void jobFail_columnNotExist() throws KettleException {
        ((JobEntryColumnsExist)Mockito.doReturn((Object)this.db).when((Object)this.jobEntry)).getNewDatabaseFromMeta();
        ((Database)Mockito.doNothing().when((Object)this.db)).connect(Mockito.anyString(), Mockito.anyString());
        ((Database)Mockito.doReturn((Object)true).when((Object)this.db)).checkTableExists(Mockito.anyString(), Mockito.anyString());
        ((Database)Mockito.doReturn((Object)false).when((Object)this.db)).checkColumnExists(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be some errors", (long)1L, (long)result.getNrErrors());
        Assert.assertFalse((String)"Result should be false", (boolean)result.getResult());
        ((Database)Mockito.verify((Object)this.db, (VerificationMode)Mockito.atLeastOnce())).disconnect();
    }

    @Test
    public void jobSuccess() throws KettleException {
        ((JobEntryColumnsExist)Mockito.doReturn((Object)this.db).when((Object)this.jobEntry)).getNewDatabaseFromMeta();
        ((Database)Mockito.doNothing().when((Object)this.db)).connect(Mockito.anyString(), Mockito.anyString());
        ((Database)Mockito.doReturn((Object)true).when((Object)this.db)).checkColumnExists(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        ((Database)Mockito.doReturn((Object)true).when((Object)this.db)).checkTableExists(Mockito.anyString(), Mockito.anyString());
        Result result = this.jobEntry.execute(new Result(), 0);
        Assert.assertEquals((String)"Should be no error", (long)0L, (long)result.getNrErrors());
        junit.framework.Assert.assertTrue((String)"Result should be true", (boolean)result.getResult());
        Assert.assertEquals((String)"Lines written", (long)COLUMNS.length, (long)result.getNrLinesWritten());
        ((Database)Mockito.verify((Object)this.db, (VerificationMode)Mockito.atLeastOnce())).disconnect();
    }
}

