/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.JobEntryLogTable;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.powermock.reflect.Whitebox;

public class JobTest {
    private static final String STRING_DEFAULT = "<def>";
    private Job mockedJob;
    private Database mockedDataBase;
    private VariableSpace mockedVariableSpace;
    private HasDatabasesInterface hasDatabasesInterface;
    private JobMeta mockedJobMeta;
    private JobEntryCopy mockedJobEntryCopy;
    private JobEntrySpecial mockedJobEntrySpecial;
    private LogChannel mockedLogChannel;

    @Before
    public void init() {
        this.mockedDataBase = (Database)Mockito.mock(Database.class);
        this.mockedJob = (Job)Mockito.mock(Job.class);
        this.mockedVariableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.hasDatabasesInterface = (HasDatabasesInterface)Mockito.mock(HasDatabasesInterface.class);
        this.mockedJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        this.mockedJobEntryCopy = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        this.mockedJobEntrySpecial = (JobEntrySpecial)Mockito.mock(JobEntrySpecial.class);
        this.mockedLogChannel = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)this.mockedJob.createDataBase((DatabaseMeta)Matchers.any(DatabaseMeta.class))).thenReturn((Object)this.mockedDataBase);
    }

    @Test
    public void recordsCleanUpMethodIsCalled_JobEntryLogTable() throws Exception {
        JobEntryLogTable jobEntryLogTable = JobEntryLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.hasDatabasesInterface);
        this.setAllTableParamsDefault((BaseLogTable)jobEntryLogTable);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setJobEntryLogTable(jobEntryLogTable);
        Mockito.when((Object)this.mockedJob.getJobMeta()).thenReturn((Object)jobMeta);
        ((Job)Mockito.doCallRealMethod().when((Object)this.mockedJob)).writeJobEntryLogInformation();
        this.mockedJob.writeJobEntryLogInformation();
        ((Database)Mockito.verify((Object)this.mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)jobEntryLogTable);
    }

    @Test
    public void recordsCleanUpMethodIsCalled_JobLogTable() throws Exception {
        JobLogTable jobLogTable = JobLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.hasDatabasesInterface);
        this.setAllTableParamsDefault((BaseLogTable)jobLogTable);
        ((Job)Mockito.doCallRealMethod().when((Object)this.mockedJob)).writeLogTableInformation(jobLogTable, LogStatus.END);
        this.mockedJob.writeLogTableInformation(jobLogTable, LogStatus.END);
        ((Database)Mockito.verify((Object)this.mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)jobLogTable);
    }

    public void setAllTableParamsDefault(BaseLogTable table) {
        table.setSchemaName(STRING_DEFAULT);
        table.setConnectionName(STRING_DEFAULT);
        table.setTimeoutInDays(STRING_DEFAULT);
        table.setTableName(STRING_DEFAULT);
        table.setFields(new ArrayList());
    }

    @Test
    public void testNewJobWithContainerObjectId() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        String carteId = UUID.randomUUID().toString();
        ((JobMeta)Mockito.doReturn((Object)carteId).when((Object)meta)).getContainerObjectId();
        Job job = new Job(repository, meta);
        Assert.assertEquals((Object)carteId, (Object)job.getContainerObjectId());
    }

    @Test
    public void testTwoJobsGetSameLogChannelId() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        Job job1 = new Job(repository, meta);
        Job job2 = new Job(repository, meta);
        Assert.assertEquals((Object)job1.getLogChannelId(), (Object)job2.getLogChannelId());
    }

    @Test
    public void testTwoJobsGetDifferentLogChannelIdWithDifferentCarteId() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        JobMeta meta1 = (JobMeta)Mockito.mock(JobMeta.class);
        JobMeta meta2 = (JobMeta)Mockito.mock(JobMeta.class);
        String carteId1 = UUID.randomUUID().toString();
        String carteId2 = UUID.randomUUID().toString();
        ((JobMeta)Mockito.doReturn((Object)carteId1).when((Object)meta1)).getContainerObjectId();
        ((JobMeta)Mockito.doReturn((Object)carteId2).when((Object)meta2)).getContainerObjectId();
        Job job1 = new Job(repository, meta1);
        Job job2 = new Job(repository, meta2);
        Assert.assertNotEquals((Object)job1.getContainerObjectId(), (Object)job2.getContainerObjectId());
        Assert.assertNotEquals((Object)job1.getLogChannelId(), (Object)job2.getLogChannelId());
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        Job jobTest = new Job();
        boolean hasFilename = true;
        boolean hasRepoDir = false;
        jobTest.copyVariablesFrom(null);
        jobTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)jobTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithRepository() {
        Job jobTest = new Job();
        boolean hasFilename = false;
        boolean hasRepoDir = true;
        jobTest.copyVariablesFrom(null);
        jobTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"/SomeRepDirectory", (Object)jobTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilenameOrRepository() {
        Job jobTest = new Job();
        jobTest.copyVariablesFrom(null);
        boolean hasFilename = false;
        boolean hasRepoDir = false;
        jobTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobTest.setInternalEntryCurrentDirectory(hasFilename, hasRepoDir);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)jobTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void executeWithPreviousResultsNoRepeatTest() {
        this.executeWithPreviousResultsTest(false);
    }

    @Test
    public void executeWithPreviousResultsWithRepeatTest() {
        this.executeWithPreviousResultsTest(true);
    }

    private void executeWithPreviousResultsTest(boolean repeat) {
        this.setupJobMockExecution();
        try {
            Mockito.when((Object)this.mockedJobEntrySpecial.execute((Result)Matchers.any(Result.class), Matchers.anyInt())).thenReturn((Object)new Result());
            Mockito.when((Object)this.mockedJob.execute(Matchers.anyInt(), (Result)Matchers.any(Result.class))).thenCallRealMethod();
            Mockito.when((Object)this.mockedJobEntrySpecial.isRepeat()).thenReturn((Object)repeat);
            if (repeat) {
                this.scheduleStopJobExecution();
            }
            this.mockedJob.execute(0, new Result());
            ((Job)Mockito.verify((Object)this.mockedJob, (VerificationMode)(repeat ? Mockito.atLeast((int)2) : Mockito.times((int)1)))).setActive(false);
        }
        catch (KettleException e) {
            Assert.fail((String)"Could not execute job");
        }
    }

    private void setupJobMockExecution() {
        Whitebox.setInternalState((Object)this.mockedJob, (String)"jobMeta", (Object)this.mockedJobMeta);
        Whitebox.setInternalState((Object)this.mockedJob, (String)"log", (Object)this.mockedLogChannel);
        Whitebox.setInternalState((Object)this.mockedJob, (String)"jobTracker", (Object)new JobTracker(this.mockedJobMeta));
        Whitebox.setInternalState((Object)this.mockedJob, (String)"jobEntryListeners", new ArrayList());
        Whitebox.setInternalState((Object)this.mockedJob, (String)"jobEntryResults", new LinkedList());
        Whitebox.setInternalState((Object)this.mockedJob, (String)"status", (Object)new AtomicInteger(0));
        Mockito.when((Object)this.mockedJobMeta.findJobEntry("START", 0, false)).thenReturn((Object)this.mockedJobEntryCopy);
        Mockito.when((Object)this.mockedJobEntryCopy.getEntry()).thenReturn((Object)this.mockedJobEntrySpecial);
        Mockito.when((Object)this.mockedJobEntrySpecial.getLogChannel()).thenReturn((Object)this.mockedLogChannel);
        Mockito.when((Object)this.mockedJobEntrySpecial.clone()).thenReturn((Object)this.mockedJobEntrySpecial);
        Mockito.when((Object)this.mockedJob.isStopped()).thenCallRealMethod();
        ((Job)Mockito.doCallRealMethod().when((Object)this.mockedJob)).setStopped(Matchers.anyBoolean());
        KettleLogStore.init();
    }

    private void scheduleStopJobExecution() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        Runnable task = () -> this.mockedJob.setStopped(true);
        scheduler.schedule(task, 1L, TimeUnit.SECONDS);
        scheduler.shutdown();
    }
}

