/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.exception.IdNotFoundException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.exception.LookupReferencesException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.listeners.CurrentDirectoryChangedListener;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.empty.JobEntryEmpty;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JobMetaTest {
    private static final String JOB_META_NAME = "jobName";
    private JobMeta jobMeta;
    private RepositoryDirectoryInterface directoryJob;
    private ContentChangedListener listener;
    private ObjectRevision objectRevision;

    @Before
    public void setUp() {
        this.jobMeta = new JobMeta();
        this.directoryJob = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)this.directoryJob.getPath()).thenReturn((Object)"directoryPath");
        this.listener = (ContentChangedListener)Mockito.mock(ContentChangedListener.class);
        this.objectRevision = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        Mockito.when((Object)this.objectRevision.getName()).thenReturn((Object)"revisionName");
        this.jobMeta.addContentChangedListener(this.listener);
        this.jobMeta.setRepositoryDirectory(this.directoryJob);
        this.jobMeta.setName(JOB_META_NAME);
        this.jobMeta.setObjectRevision(this.objectRevision);
    }

    @Test
    public void testPathExist() throws KettleXMLException, IOException, URISyntaxException {
        Assert.assertTrue((boolean)this.testPath("je1-je4"));
    }

    @Test
    public void testPathNotExist() throws KettleXMLException, IOException, URISyntaxException {
        Assert.assertFalse((boolean)this.testPath("je2-je4"));
    }

    private boolean testPath(String branch) {
        JobEntryEmpty je1 = new JobEntryEmpty();
        je1.setName("je1");
        JobEntryEmpty je2 = new JobEntryEmpty();
        je2.setName("je2");
        JobHopMeta hop = new JobHopMeta(new JobEntryCopy((JobEntryInterface)je1), new JobEntryCopy((JobEntryInterface)je2));
        this.jobMeta.addJobHop(hop);
        JobEntryEmpty je3 = new JobEntryEmpty();
        je3.setName("je3");
        hop = new JobHopMeta(new JobEntryCopy((JobEntryInterface)je1), new JobEntryCopy((JobEntryInterface)je3));
        this.jobMeta.addJobHop(hop);
        JobEntryEmpty je4 = new JobEntryEmpty();
        je4.setName("je4");
        hop = new JobHopMeta(new JobEntryCopy((JobEntryInterface)je3), new JobEntryCopy((JobEntryInterface)je4));
        this.jobMeta.addJobHop(hop);
        if (branch.equals("je1-je4")) {
            return this.jobMeta.isPathExist((JobEntryInterface)je1, (JobEntryInterface)je4);
        }
        if (branch.equals("je2-je4")) {
            return this.jobMeta.isPathExist((JobEntryInterface)je2, (JobEntryInterface)je4);
        }
        return false;
    }

    @Test
    public void testContentChangeListener() throws Exception {
        this.jobMeta.setChanged();
        this.jobMeta.setChanged(true);
        ((ContentChangedListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.same((Object)this.jobMeta));
        this.jobMeta.clearChanged();
        this.jobMeta.setChanged(false);
        ((ContentChangedListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)2))).contentSafe(Matchers.same((Object)this.jobMeta));
        this.jobMeta.removeContentChangedListener(this.listener);
        this.jobMeta.setChanged();
        this.jobMeta.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void testLookupRepositoryReferences() throws Exception {
        this.jobMeta.clear();
        JobEntryTrans jobEntryMock = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)jobEntryMock.hasRepositoryReferences()).thenReturn((Object)true);
        JobEntryTrans brokenJobEntryMock = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)brokenJobEntryMock.hasRepositoryReferences()).thenReturn((Object)true);
        ((JobEntryTrans)Mockito.doThrow((Throwable)((Throwable)Mockito.mock(IdNotFoundException.class))).when((Object)brokenJobEntryMock)).lookupRepositoryReferences((Repository)Mockito.any(Repository.class));
        JobEntryCopy jobEntryCopy1 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy1.getEntry()).thenReturn((Object)jobEntryMock);
        this.jobMeta.addJobEntry(0, jobEntryCopy1);
        JobEntryCopy jobEntryCopy2 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy2.getEntry()).thenReturn((Object)brokenJobEntryMock);
        this.jobMeta.addJobEntry(1, jobEntryCopy2);
        JobEntryCopy jobEntryCopy3 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy3.getEntry()).thenReturn((Object)jobEntryMock);
        this.jobMeta.addJobEntry(2, jobEntryCopy3);
        try {
            this.jobMeta.lookupRepositoryReferences((Repository)Mockito.mock(Repository.class));
            Assert.fail((String)"no exception for broken entry");
        }
        catch (LookupReferencesException lookupReferencesException) {
            // empty catch block
        }
        ((JobEntryTrans)Mockito.verify((Object)jobEntryMock, (VerificationMode)Mockito.times((int)2))).lookupRepositoryReferences((Repository)Mockito.any(Repository.class));
    }

    @Test
    public void shouldUseExistingRepositoryDirectoryWhenExporting() throws KettleException {
        final JobMeta jobMetaSpy = (JobMeta)Mockito.spy((Object)this.jobMeta);
        JobMeta jobMeta = new JobMeta(){

            public Object realClone(boolean doClear) {
                return jobMetaSpy;
            }
        };
        jobMeta.setRepositoryDirectory(this.directoryJob);
        jobMeta.setName(JOB_META_NAME);
        jobMeta.exportResources(null, new HashMap(4), (ResourceNamingInterface)Mockito.mock(ResourceNamingInterface.class), null, null);
        ((JobMeta)Mockito.verify((Object)jobMetaSpy)).setRepositoryDirectory(this.directoryJob);
    }

    @Test
    public void shouldUseCoordinatesOfItsStepsAndNotesWhenCalculatingMinimumPoint() {
        Point jobEntryPoint = new Point(500, 500);
        Point notePadMetaPoint = new Point(400, 400);
        JobEntryCopy jobEntryCopy = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy.getLocation()).thenReturn((Object)jobEntryPoint);
        NotePadMeta notePadMeta = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        Mockito.when((Object)notePadMeta.getLocation()).thenReturn((Object)notePadMetaPoint);
        Point point = this.jobMeta.getMinimum();
        Assert.assertEquals((long)0L, (long)point.x);
        Assert.assertEquals((long)0L, (long)point.y);
        this.jobMeta.addJobEntry(0, jobEntryCopy);
        Point actualStepPoint = this.jobMeta.getMinimum();
        Assert.assertEquals((long)(jobEntryPoint.x - 20), (long)actualStepPoint.x);
        Assert.assertEquals((long)(jobEntryPoint.y - 20), (long)actualStepPoint.y);
        this.jobMeta.addNote(notePadMeta);
        Point stepPoint = this.jobMeta.getMinimum();
        Assert.assertEquals((long)(notePadMetaPoint.x - 20), (long)stepPoint.x);
        Assert.assertEquals((long)(notePadMetaPoint.y - 20), (long)stepPoint.y);
    }

    @Test
    public void testEquals_oneNameNull() {
        Assert.assertFalse((boolean)this.testEquals(null, null, null, null));
    }

    @Test
    public void testEquals_secondNameNull() {
        this.jobMeta.setName(null);
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, null, null, null));
    }

    @Test
    public void testEquals_sameNameOtherDir() {
        RepositoryDirectoryInterface otherDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)otherDirectory.getPath()).thenReturn((Object)"otherDirectoryPath");
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, otherDirectory, null, null));
    }

    @Test
    public void testEquals_sameNameSameDirNullRev() {
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, this.directoryJob, null, null));
    }

    @Test
    public void testEquals_sameNameSameDirDiffRev() {
        ObjectRevision otherRevision = (ObjectRevision)Mockito.mock(ObjectRevision.class);
        Mockito.when((Object)otherRevision.getName()).thenReturn((Object)"otherRevision");
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, this.directoryJob, otherRevision, null));
    }

    @Test
    public void testEquals_sameNameSameDirSameRev() {
        Assert.assertTrue((boolean)this.testEquals(JOB_META_NAME, this.directoryJob, this.objectRevision, null));
    }

    @Test
    public void testEquals_sameNameSameDirSameRevFilename() {
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, this.directoryJob, this.objectRevision, "Filename"));
    }

    @Test
    public void testEquals_sameFilename() {
        String newFilename = "Filename";
        this.jobMeta.setFilename(newFilename);
        Assert.assertFalse((boolean)this.testEquals(null, null, null, newFilename));
    }

    @Test
    public void testEquals_difFilenameSameName() {
        this.jobMeta.setFilename("Filename");
        Assert.assertFalse((boolean)this.testEquals(JOB_META_NAME, null, null, "OtherFileName"));
    }

    @Test
    public void testEquals_sameFilenameSameName() {
        String newFilename = "Filename";
        this.jobMeta.setFilename(newFilename);
        Assert.assertTrue((boolean)this.testEquals(JOB_META_NAME, null, null, newFilename));
    }

    @Test
    public void testEquals_sameFilenameDifName() {
        String newFilename = "Filename";
        this.jobMeta.setFilename(newFilename);
        Assert.assertFalse((boolean)this.testEquals("OtherName", null, null, newFilename));
    }

    private boolean testEquals(String name, RepositoryDirectoryInterface repDirectory, ObjectRevision revision, String filename) {
        JobMeta jobMeta2 = new JobMeta();
        jobMeta2.setName(name);
        jobMeta2.setRepositoryDirectory(repDirectory);
        jobMeta2.setObjectRevision(revision);
        jobMeta2.setFilename(filename);
        return this.jobMeta.equals((Object)jobMeta2);
    }

    @Test
    public void testLoadXml() throws KettleException {
        final String directory = "/home/admin";
        Node jobNode = (Node)Mockito.mock(Node.class);
        NodeList nodeList = new NodeList(){
            Node node = (Node)Mockito.mock(Node.class);
            {
                Mockito.when((Object)this.node.getNodeName()).thenReturn((Object)"directory");
                Node child = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)this.node.getFirstChild()).thenReturn((Object)child);
                Mockito.when((Object)child.getNodeValue()).thenReturn((Object)directory);
            }

            @Override
            public Node item(int index) {
                return this.node;
            }

            @Override
            public int getLength() {
                return 1;
            }
        };
        Mockito.when((Object)jobNode.getChildNodes()).thenReturn((Object)nodeList);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        RepositoryDirectory repDirectory = new RepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory(), "home"), "admin");
        Mockito.when((Object)rep.findDirectory((String)Mockito.eq((Object)directory))).thenReturn((Object)repDirectory);
        JobMeta meta = new JobMeta();
        meta.loadXML(jobNode, null, rep, (IMetaStore)Mockito.mock(IMetaStore.class), false, (OverwritePrompter)Mockito.mock(OverwritePrompter.class));
        Job job = new Job(rep, meta);
        job.setInternalKettleVariables(null);
        Assert.assertEquals((Object)repDirectory.getPath(), (Object)job.getVariable("Internal.Job.Repository.Directory"));
    }

    @Test
    public void testAddRemoveJobEntryCopySetUnsetParent() throws Exception {
        JobEntryCopy jobEntryCopy = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        this.jobMeta.addJobEntry(jobEntryCopy);
        this.jobMeta.removeJobEntry(0);
        ((JobEntryCopy)Mockito.verify((Object)jobEntryCopy, (VerificationMode)Mockito.times((int)1))).setParentJobMeta(this.jobMeta);
        ((JobEntryCopy)Mockito.verify((Object)jobEntryCopy, (VerificationMode)Mockito.times((int)1))).setParentJobMeta(null);
    }

    @Test
    public void testFireCurrentDirChanged() throws Exception {
        String pathBefore = "/path/before";
        String pathAfter = "path/after";
        RepositoryDirectoryInterface repoDirOrig = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)repoDirOrig.getPath()).thenReturn((Object)pathBefore);
        RepositoryDirectoryInterface repoDir = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)repoDir.getPath()).thenReturn((Object)pathAfter);
        this.jobMeta.setRepository((Repository)Mockito.mock(Repository.class));
        this.jobMeta.setRepositoryDirectory(repoDirOrig);
        CurrentDirectoryChangedListener listener = (CurrentDirectoryChangedListener)Mockito.mock(CurrentDirectoryChangedListener.class);
        this.jobMeta.addCurrentDirectoryChangedListener(listener);
        this.jobMeta.setRepositoryDirectory(repoDir);
        ((CurrentDirectoryChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).directoryChanged((Object)this.jobMeta, pathBefore, pathAfter);
    }

    @Test
    public void testHasLoop_simpleLoop() throws Exception {
        JobMeta jobMetaSpy = (JobMeta)Mockito.spy((Object)this.jobMeta);
        JobEntryCopy jobEntryCopyMain = this.createJobEntryCopy("mainStep");
        JobEntryCopy jobEntryCopy2 = this.createJobEntryCopy("step2");
        JobEntryCopy jobEntryCopy3 = this.createJobEntryCopy("step3");
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopyMain)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopyMain, 0)).thenReturn((Object)jobEntryCopy2);
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopy2)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopy2, 0)).thenReturn((Object)jobEntryCopy3);
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopy3)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopy3, 0)).thenReturn((Object)jobEntryCopyMain);
        Assert.assertTrue((boolean)jobMetaSpy.hasLoop(jobEntryCopyMain));
    }

    @Test
    public void testHasLoop_loopInPrevSteps() throws Exception {
        JobMeta jobMetaSpy = (JobMeta)Mockito.spy((Object)this.jobMeta);
        JobEntryCopy jobEntryCopyMain = this.createJobEntryCopy("mainStep");
        JobEntryCopy jobEntryCopy2 = this.createJobEntryCopy("step2");
        JobEntryCopy jobEntryCopy3 = this.createJobEntryCopy("step3");
        JobEntryCopy jobEntryCopy4 = this.createJobEntryCopy("step4");
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopyMain)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopyMain, 0)).thenReturn((Object)jobEntryCopy2);
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopy2)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopy2, 0)).thenReturn((Object)jobEntryCopy3);
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopy3)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopy3, 0)).thenReturn((Object)jobEntryCopy4);
        Mockito.when((Object)jobMetaSpy.findNrPrevJobEntries(jobEntryCopy4)).thenReturn((Object)1);
        Mockito.when((Object)jobMetaSpy.findPrevJobEntry(jobEntryCopy4, 0)).thenReturn((Object)jobEntryCopy3);
        Assert.assertFalse((boolean)jobMetaSpy.hasLoop(jobEntryCopyMain));
    }

    private JobEntryCopy createJobEntryCopy(String name) {
        JobEntryInterface jobEntry = (JobEntryInterface)Mockito.mock(JobEntryInterface.class);
        JobEntryCopy jobEntryCopy = new JobEntryCopy(jobEntry);
        Mockito.when((Object)jobEntryCopy.getName()).thenReturn((Object)name);
        jobEntryCopy.setNr(0);
        return jobEntryCopy;
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        JobMeta jobMetaTest = new JobMeta();
        jobMetaTest.setFilename("hasFilename");
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithRepository() {
        JobMeta jobMetaTest = new JobMeta();
        RepositoryDirectoryInterface path = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)path.getPath()).thenReturn((Object)"aPath");
        jobMetaTest.setRepository((Repository)Mockito.mock(Repository.class));
        jobMetaTest.setRepositoryDirectory(path);
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"/SomeRepDirectory", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilenameOrRepository() {
        JobMeta jobMetaTest = new JobMeta();
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.setInternalEntryCurrentDirectory();
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testUpdateCurrentDirWithFilename() {
        JobMeta jobMetaTest = new JobMeta();
        jobMetaTest.setFilename("hasFilename");
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.updateCurrentDir();
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testUpdateCurrentDirWithRepository() {
        JobMeta jobMetaTest = new JobMeta();
        RepositoryDirectoryInterface path = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)path.getPath()).thenReturn((Object)"aPath");
        jobMetaTest.setRepository((Repository)Mockito.mock(Repository.class));
        jobMetaTest.setRepositoryDirectory(path);
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.updateCurrentDir();
        Assert.assertEquals((Object)"/SomeRepDirectory", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }

    @Test
    public void testUpdateCurrentDirWithoutFilenameOrRepository() {
        JobMeta jobMetaTest = new JobMeta();
        jobMetaTest.setVariable("Internal.Entry.Current.Directory", "Original value defined at run execution");
        jobMetaTest.setVariable("Internal.Job.Filename.Directory", "file:///C:/SomeFilenameDirectory");
        jobMetaTest.setVariable("Internal.Job.Repository.Directory", "/SomeRepDirectory");
        jobMetaTest.updateCurrentDir();
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)jobMetaTest.getVariable("Internal.Entry.Current.Directory"));
    }
}

