/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobExecutionConfigurationTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testConnectRepository() throws KettleException {
        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
        RepositoriesMeta repositoriesMeta = (RepositoriesMeta)Mockito.mock(RepositoriesMeta.class);
        final RepositoryMeta repositoryMeta = (RepositoryMeta)Mockito.mock(RepositoryMeta.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        String mockRepo = "mockRepo";
        final boolean[] connectionSuccess = new boolean[]{false};
        Repository initialRepo = (Repository)Mockito.mock(Repository.class);
        jobExecutionConfiguration.setRepository(initialRepo);
        KettleLogStore.init();
        MockRepositoryPlugin mockRepositoryPlugin = (MockRepositoryPlugin)Mockito.mock(MockRepositoryPlugin.class);
        Mockito.when((Object)mockRepositoryPlugin.getIds()).thenReturn((Object)new String[]{"mockRepo"});
        Mockito.when((Object)mockRepositoryPlugin.matches("mockRepo")).thenReturn((Object)true);
        Mockito.when((Object)mockRepositoryPlugin.getName()).thenReturn((Object)"mock-repository");
        Mockito.when((Object)mockRepositoryPlugin.getClassMap()).thenAnswer(new Answer<Map<Class<?>, String>>(){

            public Map<Class<?>, String> answer(InvocationOnMock invocation) throws Throwable {
                HashMap dbMap = new HashMap();
                dbMap.put(Repository.class, repositoryMeta.getClass().getName());
                return dbMap;
            }
        });
        PluginRegistry.getInstance().registerPlugin(RepositoryPluginType.class, (PluginInterface)mockRepositoryPlugin);
        Mockito.when((Object)repositoriesMeta.findRepository(Matchers.anyString())).thenAnswer((Answer)new Answer<RepositoryMeta>(){

            public RepositoryMeta answer(InvocationOnMock invocation) throws Throwable {
                return "mockRepo".equals(invocation.getArguments()[0]) ? repositoryMeta : null;
            }
        });
        Mockito.when((Object)mockRepositoryPlugin.loadClass(Repository.class)).thenReturn((Object)repository);
        ((Repository)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                if (!"username".equals(invocation.getArguments()[0]) || !"password".equals(invocation.getArguments()[1])) {
                    connectionSuccess[0] = false;
                    throw new KettleException("Mock Repository connection failed");
                }
                connectionSuccess[0] = true;
                return null;
            }
        }).when((Object)repository)).connect(Matchers.anyString(), Matchers.anyString());
        jobExecutionConfiguration.connectRepository(repositoriesMeta, "notFound", "username", "password");
        Assert.assertEquals((String)"Repository Changed", (Object)initialRepo, (Object)jobExecutionConfiguration.getRepository());
        jobExecutionConfiguration.connectRepository(repositoriesMeta, "mockRepo", "username", "");
        Assert.assertEquals((String)"Repository Changed", (Object)initialRepo, (Object)jobExecutionConfiguration.getRepository());
        jobExecutionConfiguration.connectRepository(repositoriesMeta, "mockRepo", "username", "password");
        Assert.assertEquals((String)"Repository didn't change", (Object)repository, (Object)jobExecutionConfiguration.getRepository());
        Assert.assertTrue((String)"Repository not connected", (boolean)connectionSuccess[0]);
    }

    @Test
    public void testDefaultPassedBatchId() {
        JobExecutionConfiguration jec = new JobExecutionConfiguration();
        Assert.assertEquals((String)"default passedBatchId value must be null", null, (Object)jec.getPassedBatchId());
    }

    @Test
    public void testCopy() {
        JobExecutionConfiguration jec = new JobExecutionConfiguration();
        Long passedBatchId0 = null;
        long passedBatchId1 = 0L;
        long passedBatchId2 = 5L;
        jec.setPassedBatchId(passedBatchId0);
        JobExecutionConfiguration jecCopy = (JobExecutionConfiguration)jec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
        jec.setPassedBatchId(Long.valueOf(0L));
        jecCopy = (JobExecutionConfiguration)jec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
        jec.setPassedBatchId(Long.valueOf(5L));
        jecCopy = (JobExecutionConfiguration)jec.clone();
        Assert.assertEquals((String)"clone-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
    }

    @Test
    public void testCopyXml() throws Exception {
        JobExecutionConfiguration jec = new JobExecutionConfiguration();
        Long passedBatchId0 = null;
        long passedBatchId1 = 0L;
        long passedBatchId2 = 5L;
        jec.setPassedBatchId(passedBatchId0);
        String xml = jec.getXML();
        Document doc = XMLHandler.loadXMLString((String)xml);
        Node node = XMLHandler.getSubNode((Node)doc, (String)"job_execution_configuration");
        JobExecutionConfiguration jecCopy = new JobExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
        jec.setPassedBatchId(Long.valueOf(0L));
        xml = jec.getXML();
        doc = XMLHandler.loadXMLString((String)xml);
        node = XMLHandler.getSubNode((Node)doc, (String)"job_execution_configuration");
        jecCopy = new JobExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
        jec.setPassedBatchId(Long.valueOf(5L));
        xml = jec.getXML();
        doc = XMLHandler.loadXMLString((String)xml);
        node = XMLHandler.getSubNode((Node)doc, (String)"job_execution_configuration");
        jecCopy = new JobExecutionConfiguration(node);
        Assert.assertEquals((String)"xml-copy", (Object)jec.getPassedBatchId(), (Object)jecCopy.getPassedBatchId());
    }

    @Test
    public void testGetUsedArguments() throws KettleException {
        JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
        JobMeta jobMeta = new JobMeta();
        jobMeta.jobcopies = new ArrayList();
        String[] commandLineArguments = new String[]{};
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        JobEntryCopy jobEntryCopy0 = new JobEntryCopy();
        TransMeta transMeta0 = (TransMeta)Mockito.mock(TransMeta.class);
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("arg0", "argument0");
        Mockito.when((Object)transMeta0.getUsedArguments(commandLineArguments)).thenReturn(map0);
        JobEntryInterface jobEntryInterface0 = (JobEntryInterface)Mockito.mock(JobEntryInterface.class);
        Mockito.when((Object)jobEntryInterface0.isTransformation()).thenReturn((Object)false);
        jobEntryCopy0.setEntry(jobEntryInterface0);
        jobMeta.jobcopies.add(jobEntryCopy0);
        JobEntryCopy jobEntryCopy1 = new JobEntryCopy();
        TransMeta transMeta1 = (TransMeta)Mockito.mock(TransMeta.class);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("arg1", "argument1");
        Mockito.when((Object)transMeta1.getUsedArguments(commandLineArguments)).thenReturn(map1);
        JobEntryTrans jobEntryTrans1 = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)jobEntryTrans1.isTransformation()).thenReturn((Object)true);
        Mockito.when((Object)jobEntryTrans1.getTransMeta(executionConfiguration.getRepository(), metaStore, (VariableSpace)jobMeta)).thenReturn((Object)transMeta1);
        jobEntryCopy1.setEntry((JobEntryInterface)jobEntryTrans1);
        jobMeta.jobcopies.add(jobEntryCopy1);
        JobEntryCopy jobEntryCopy2 = new JobEntryCopy();
        TransMeta transMeta2 = (TransMeta)Mockito.mock(TransMeta.class);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("arg1", "argument1");
        map2.put("arg2", "argument2");
        Mockito.when((Object)transMeta2.getUsedArguments(commandLineArguments)).thenReturn(map2);
        JobEntryTrans jobEntryTrans2 = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)jobEntryTrans2.isTransformation()).thenReturn((Object)true);
        Mockito.when((Object)jobEntryTrans2.getTransMeta(executionConfiguration.getRepository(), metaStore, (VariableSpace)jobMeta)).thenReturn((Object)transMeta2);
        jobEntryCopy2.setEntry((JobEntryInterface)jobEntryTrans2);
        jobMeta.jobcopies.add(jobEntryCopy2);
        executionConfiguration.getUsedArguments(jobMeta, commandLineArguments, metaStore);
        Assert.assertEquals((long)2L, (long)executionConfiguration.getArguments().size());
    }

    @Test
    public void testGetUsedVariablesWithNoPreviousExecutionConfigurationVariables() throws KettleException {
        JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
        HashMap variables0 = new HashMap();
        executionConfiguration.setVariables(variables0);
        JobMeta jobMeta0 = (JobMeta)Mockito.mock(JobMeta.class);
        ArrayList<String> list0 = new ArrayList<String>();
        list0.add("var1");
        Mockito.when((Object)jobMeta0.getUsedVariables()).thenReturn(list0);
        Mockito.when((Object)jobMeta0.getVariable(Matchers.anyString())).thenReturn((Object)"internalDummyValue");
        executionConfiguration.getUsedVariables(jobMeta0);
        Assert.assertEquals((long)8L, (long)executionConfiguration.getVariables().size());
        Assert.assertEquals((Object)"", executionConfiguration.getVariables().get("var1"));
    }

    @Test
    public void testGetUsedVariablesWithSamePreviousExecutionConfigurationVariables() throws KettleException {
        JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
        HashMap<String, String> variables0 = new HashMap<String, String>();
        variables0.put("var1", "valueVar1");
        executionConfiguration.setVariables(variables0);
        JobMeta jobMeta0 = (JobMeta)Mockito.mock(JobMeta.class);
        ArrayList<String> list0 = new ArrayList<String>();
        list0.add("var1");
        Mockito.when((Object)jobMeta0.getUsedVariables()).thenReturn(list0);
        Mockito.when((Object)jobMeta0.getVariable(Matchers.anyString())).thenReturn((Object)"internalDummyValue");
        executionConfiguration.getUsedVariables(jobMeta0);
        Assert.assertEquals((long)8L, (long)executionConfiguration.getVariables().size());
        Assert.assertEquals((Object)"valueVar1", executionConfiguration.getVariables().get("var1"));
    }

    @Test
    public void testGetUsedVariablesWithDifferentPreviousExecutionConfigurationVariables() throws KettleException {
        JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
        HashMap<String, String> variables0 = new HashMap<String, String>();
        variables0.put("var2", "valueVar2");
        executionConfiguration.setVariables(variables0);
        JobMeta jobMeta0 = (JobMeta)Mockito.mock(JobMeta.class);
        ArrayList<String> list0 = new ArrayList<String>();
        list0.add("var1");
        Mockito.when((Object)jobMeta0.getUsedVariables()).thenReturn(list0);
        Mockito.when((Object)jobMeta0.getVariable(Matchers.anyString())).thenReturn((Object)"internalDummyValue");
        executionConfiguration.getUsedVariables(jobMeta0);
        Assert.assertEquals((long)9L, (long)executionConfiguration.getVariables().size());
        Assert.assertEquals((Object)"", executionConfiguration.getVariables().get("var1"));
        Assert.assertEquals((Object)"valueVar2", executionConfiguration.getVariables().get("var2"));
    }

    public static interface MockRepositoryPlugin
    extends PluginInterface,
    ClassLoadingPluginInterface {
    }
}

