/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.TransformationHasDescriptionImportRule;
import org.pentaho.di.trans.TransMeta;

public class TransformationHasDescriptionImportRuleTest {
    @Test
    public void testGetSetMinLength() {
        TransformationHasDescriptionImportRule importRule = new TransformationHasDescriptionImportRule();
        Assert.assertTrue((0 < importRule.getMinLength() ? 1 : 0) != 0);
        importRule.setMinLength(10);
        Assert.assertEquals((long)10L, (long)importRule.getMinLength());
        importRule.setMinLength(25);
        Assert.assertEquals((long)25L, (long)importRule.getMinLength());
        importRule.setMinLength(0);
        Assert.assertEquals((long)0L, (long)importRule.getMinLength());
    }

    @Test
    public void testVerifyRule_NullParameter_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NotTransMetaParameter_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        List feedbackList = importRule.verifyRule((Object)"");
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NullDescription_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription(null);
        List feedbackList = importRule.verifyRule((Object)transMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_EmptyDescription_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("");
        List feedbackList = importRule.verifyRule((Object)transMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_ShortDescription_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("short");
        List feedbackList = importRule.verifyRule((Object)transMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_SameAsMinimumLenghtDescription_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("1234567890");
        List feedbackList = importRule.verifyRule((Object)transMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.APPROVAL, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isApproval());
    }

    @Test
    public void testVerifyRule_LongDescription_EnabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, true);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("A very long description that has more characters than the minimum required to be a valid one!");
        List feedbackList = importRule.verifyRule((Object)transMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.APPROVAL, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isApproval());
    }

    @Test
    public void testVerifyRule_NullParameter_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NotTransMetaParameter_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        List feedbackList = importRule.verifyRule((Object)"");
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NullDescription_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription(null);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_EmptyDescription_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_ShortDescription_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("short");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_SameAsMinimumLenghtDescription_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("1234567890");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_LongDescription_DisabledRule() {
        TransformationHasDescriptionImportRule importRule = this.getImportRule(10, false);
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("A very long description that has more characters than the minimum required to be a valid one!");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    private TransformationHasDescriptionImportRule getImportRule(int minLength, boolean enable) {
        TransformationHasDescriptionImportRule importRule = new TransformationHasDescriptionImportRule();
        importRule.setMinLength(minLength);
        importRule.setEnabled(enable);
        return importRule;
    }
}

