/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.JobHasDescriptionImportRule;
import org.pentaho.di.job.JobMeta;

public class JobHasDescriptionImportRuleTest {
    @Test
    public void testGetSetMinLength() {
        JobHasDescriptionImportRule importRule = new JobHasDescriptionImportRule();
        Assert.assertTrue((0 < importRule.getMinLength() ? 1 : 0) != 0);
        importRule.setMinLength(10);
        Assert.assertEquals((long)10L, (long)importRule.getMinLength());
        importRule.setMinLength(25);
        Assert.assertEquals((long)25L, (long)importRule.getMinLength());
        importRule.setMinLength(0);
        Assert.assertEquals((long)0L, (long)importRule.getMinLength());
    }

    @Test
    public void testVerifyRule_NullParameter_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NotJobMetaParameter_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        List feedbackList = importRule.verifyRule((Object)"");
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NullDescription_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription(null);
        List feedbackList = importRule.verifyRule((Object)jobMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_EmptyDescription_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("");
        List feedbackList = importRule.verifyRule((Object)jobMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_ShortDescription_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("short");
        List feedbackList = importRule.verifyRule((Object)jobMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.ERROR, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isError());
    }

    @Test
    public void testVerifyRule_SameAsMinimumLenghtDescription_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("1234567890");
        List feedbackList = importRule.verifyRule((Object)jobMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.APPROVAL, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isApproval());
    }

    @Test
    public void testVerifyRule_LongDescription_EnabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, true);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("A very long description that has more characters than the minimum required to be a valid one!");
        List feedbackList = importRule.verifyRule((Object)jobMeta);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertFalse((boolean)feedbackList.isEmpty());
        ImportValidationFeedback feedback = (ImportValidationFeedback)feedbackList.get(0);
        Assert.assertNotNull((Object)feedback);
        Assert.assertEquals((Object)ImportValidationResultType.APPROVAL, (Object)feedback.getResultType());
        Assert.assertTrue((boolean)feedback.isApproval());
    }

    @Test
    public void testVerifyRule_NullParameter_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NotJobMetaParameter_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        List feedbackList = importRule.verifyRule((Object)"");
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_NullDescription_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription(null);
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_EmptyDescription_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_ShortDescription_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("short");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_SameAsMinimumLenghtDescription_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("1234567890");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    @Test
    public void testVerifyRule_LongDescription_DisabledRule() {
        JobHasDescriptionImportRule importRule = this.getImportRule(10, false);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("A very long description that has more characters than the minimum required to be a valid one!");
        List feedbackList = importRule.verifyRule(null);
        Assert.assertNotNull((Object)feedbackList);
        Assert.assertTrue((boolean)feedbackList.isEmpty());
    }

    private JobHasDescriptionImportRule getImportRule(int minLength, boolean enable) {
        JobHasDescriptionImportRule importRule = new JobHasDescriptionImportRule();
        importRule.setMinLength(minLength);
        importRule.setEnabled(enable);
        return importRule;
    }
}

