/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;

public class StepMetaPropsTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void before() throws KettleException {
        KettleEnvironment.init();
    }

    @Test
    public void testToAndFrom() {
        FooMeta foo = StepMetaPropsTest.getTestFooMeta();
        StepMetaProps fromMeta = StepMetaProps.from((StepMetaInterface)foo);
        FooMeta toMeta = new FooMeta();
        fromMeta.to((StepMetaInterface)toMeta);
        Assert.assertThat((Object)((Object)foo), (Matcher)CoreMatchers.equalTo((Object)((Object)toMeta)));
    }

    @Test
    public void testEncrypt() {
        FooMeta foo = StepMetaPropsTest.getTestFooMeta();
        foo.password = "p@ssword";
        StepMetaProps stepMetaProps = StepMetaProps.from((StepMetaInterface)foo);
        Assert.assertThat((String)"password field should be encrypted, so should not be present in the .toString of the props", (Object)stepMetaProps.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"p@ssword")));
        FooMeta toMeta = new FooMeta();
        stepMetaProps.to((StepMetaInterface)toMeta);
        Assert.assertThat((Object)((Object)foo), (Matcher)CoreMatchers.equalTo((Object)((Object)toMeta)));
        Assert.assertThat((Object)"p@ssword", (Matcher)CoreMatchers.equalTo((Object)toMeta.password));
    }

    @Test
    public void testEncryptedList() {
        FooMeta foo = StepMetaPropsTest.getTestFooMeta();
        foo.securelist = Arrays.asList("shadow", "substance");
        StepMetaProps stepMetaProps = StepMetaProps.from((StepMetaInterface)foo);
        Assert.assertThat((String)"secureList should be encrypted, so raw values should not be present in the .toString of the props", (Object)stepMetaProps.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"expectedString")));
        Arrays.asList("shadow", "substance").forEach(val -> Assert.assertThat((String)(val + " should be encrypted, so should not be present in the .toString of the props"), (Object)stepMetaProps.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)val))));
        FooMeta toMeta = new FooMeta();
        stepMetaProps.to((StepMetaInterface)toMeta);
        Assert.assertThat((Object)((Object)foo), (Matcher)CoreMatchers.equalTo((Object)((Object)toMeta)));
        Assert.assertThat(Arrays.asList("shadow", "substance"), (Matcher)CoreMatchers.equalTo(toMeta.securelist));
    }

    @Test
    public void canGetFieldProperties() {
        FooMeta fooMeta = StepMetaPropsTest.getTestFooMeta();
        StepMetaProps props = StepMetaProps.from((StepMetaInterface)fooMeta);
        Assert.assertEquals((Object)"expectedString", (Object)Encr.decryptPassword((String)((String)props.getPropertyValue("stuffGroup", "FIELD1").get(0))));
    }

    @Test
    public void testInjectionDeep() {
        FooMeta fooMeta = StepMetaPropsTest.getTestFooMeta();
        fooMeta.deep.howDeep = 50;
        fooMeta.deep.isItDeep = false;
        FooMeta toMeta = new FooMeta();
        StepMetaProps.from((StepMetaInterface)fooMeta).to((StepMetaInterface)toMeta);
        Assert.assertThat((Object)50, (Matcher)CoreMatchers.equalTo((Object)toMeta.deep.howDeep));
        Assert.assertThat((Object)false, (Matcher)CoreMatchers.equalTo((Object)toMeta.deep.isItDeep));
    }

    @Test
    public void sensitiveFieldsCheckedAtMultipleLevels() {
        Object topLevelObject = new Object(){
            @InjectionDeep
            1DeepContainer deepObj;
            {
                class 1DeepContainer {
                    @InjectionDeep
                    1DeeperContainer deeperObj;

                    1DeepContainer() {
                        class DeeperContainer {
                            @Sensitive
                            @Injection(name="Sensitive")
                            String sensitive = "very sensitive";
                            @Injection(name="NotSensitive")
                            String notSensitive = "cold and unfeeling";

                            DeeperContainer() {
                            }
                        }
                        this.deeperObj = new DeeperContainer();
                    }
                }
                this.deepObj = new 1DeepContainer();
            }
        };
        List sensitiveFields = StepMetaProps.sensitiveFields(topLevelObject.getClass());
        Assert.assertThat((Object)sensitiveFields, (Matcher)CoreMatchers.equalTo(Collections.singletonList("Sensitive")));
    }

    @Test
    public void variableSubstitutionHappens() {
        FooMeta fooMeta = StepMetaPropsTest.getTestFooMeta();
        fooMeta.field1 = "${field1Sub}";
        fooMeta.alist = Arrays.asList("noSub", "${listEntrySub}", "${listEntrySub2}", "noSubAgain");
        fooMeta.password = "${encryptedSub}";
        fooMeta.deep.deepList = Arrays.asList("deepNotSubbed", "${deepListSub}");
        FooMeta newFoo = new FooMeta();
        Variables variables = new Variables();
        variables.setVariable("field1Sub", "my substituted value");
        variables.setVariable("listEntrySub", "list sub");
        variables.setVariable("listEntrySub2", "list sub 2");
        variables.setVariable("encryptedSub", "encrypted sub");
        variables.setVariable("deepListSub", "deep list sub");
        StepMetaProps.from((StepMetaInterface)fooMeta).withVariables((VariableSpace)variables).to((StepMetaInterface)newFoo);
        Assert.assertThat((Object)"my substituted value", (Matcher)CoreMatchers.equalTo((Object)newFoo.field1));
        Assert.assertThat((Object)"list sub", (Matcher)CoreMatchers.equalTo((Object)newFoo.alist.get(1)));
        Assert.assertThat((Object)"list sub 2", (Matcher)CoreMatchers.equalTo((Object)newFoo.alist.get(2)));
        Assert.assertThat((Object)"encrypted sub", (Matcher)CoreMatchers.equalTo((Object)newFoo.password));
        Assert.assertThat((Object)"deep list sub", (Matcher)CoreMatchers.equalTo((Object)newFoo.deep.deepList.get(1)));
        Assert.assertThat((Object)"noSub", (Matcher)CoreMatchers.equalTo((Object)newFoo.alist.get(0)));
    }

    static FooMeta getTestFooMeta() {
        FooMeta foo = new FooMeta();
        foo.field1 = "expectedString";
        foo.field2 = 42;
        foo.alist = Arrays.asList("one", "two", "three", "four");
        foo.blist = Arrays.asList(true, false, false);
        foo.ilist = Arrays.asList(1, 4, 26);
        return foo;
    }

    @InjectionSupported(localizationPrefix="stuff", groups={"stuffGroup"})
    static class FooMeta
    extends BaseStreamStepMeta {
        @Sensitive
        @Injection(name="FIELD1", group="stuffGroup")
        String field1 = "default";
        @Injection(name="FIELD2", group="stuffGroup")
        int field2 = 123;
        @Sensitive
        @Injection(name="PassVerd")
        String password = "should.be.encrypted";
        @Injection(name="ALIST")
        List<String> alist = new ArrayList<String>();
        @Sensitive
        @Injection(name="SECURELIST")
        List<String> securelist = new ArrayList<String>();
        @Injection(name="BOOLEANLIST")
        List<Boolean> blist = new ArrayList<Boolean>();
        @Injection(name="IntList")
        List<Integer> ilist = new ArrayList<Integer>();
        @InjectionDeep
        SoooDeep deep = new SoooDeep();
        @InjectionDeep
        List<DeepListable> deepListables = new ArrayList<DeepListable>();
        @InjectionDeep
        DeepArrayable[] deepArrayable = new DeepArrayable[2];

        FooMeta() {
            this.deepListables.add(new DeepListable("foo", "bar"));
            this.deepListables.add(new DeepListable("foo2", "bar2"));
            this.deepArrayable[0] = new DeepArrayable("afoo", "abar");
            this.deepArrayable[1] = new DeepArrayable("afoo2", "abar2");
        }

        public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            return null;
        }

        public StepDataInterface getStepData() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FooMeta fooMeta = (FooMeta)((Object)o);
            return this.field2 == fooMeta.field2 && Objects.equals(this.field1, fooMeta.field1) && Objects.equals(this.password, fooMeta.password) && Objects.equals(this.alist, fooMeta.alist) && Objects.equals(this.securelist, fooMeta.securelist) && Objects.equals(this.blist, fooMeta.blist) && Objects.equals(this.ilist, fooMeta.ilist) && Objects.equals(this.deep, fooMeta.deep) && Objects.equals(this.deepListables, fooMeta.deepListables) && Arrays.equals(this.deepArrayable, fooMeta.deepArrayable);
        }

        public int hashCode() {
            int result = Objects.hash(this.field1, this.field2, this.password, this.alist, this.securelist, this.blist, this.ilist, this.deep, this.deepListables);
            result = 31 * result + Arrays.hashCode(this.deepArrayable);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FooMeta{");
            sb.append("field1='").append(this.field1).append('\'');
            sb.append(", \nfield2=").append(this.field2);
            sb.append(", \npassword='").append(this.password).append('\'');
            sb.append(", \nalist=").append(this.alist);
            sb.append(", \nsecurelist=").append(this.securelist);
            sb.append(", \nblist=").append(this.blist);
            sb.append(", \nilist=").append(this.ilist);
            sb.append(", \ndeep=").append(this.deep);
            sb.append(", \ndeepListables=").append(this.deepListables);
            sb.append(", \ndeepArrayable=").append(Arrays.toString(this.deepArrayable));
            sb.append('}');
            return sb.toString();
        }

        public RowMeta getRowMeta(String origin, VariableSpace space) {
            return null;
        }

        static class DeepArrayable {
            @Injection(name="AITEM")
            String item;
            @Injection(name="AITEM2")
            String item2;

            DeepArrayable(String item, String item2) {
                this.item = item;
                this.item2 = item2;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DeepArrayable that = (DeepArrayable)o;
                return Objects.equals(this.item, that.item) && Objects.equals(this.item2, that.item2);
            }

            public int hashCode() {
                return Objects.hash(this.item, this.item2);
            }
        }

        static class DeepListable {
            @Injection(name="ITEM")
            String item;
            @Injection(name="ITEM2")
            String item2;

            DeepListable(String item, String item2) {
                this.item = item;
                this.item2 = item2;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DeepListable that = (DeepListable)o;
                return Objects.equals(this.item, that.item) && Objects.equals(this.item2, that.item2);
            }

            public int hashCode() {
                return Objects.hash(this.item, this.item2);
            }
        }

        static class SoooDeep {
            @Injection(name="DEEP_FLAG")
            boolean isItDeep = true;
            @Injection(name="DEPTH")
            int howDeep = 1000;
            @Injection(name="DEEP_LIST ")
            List<String> deepList = new ArrayList<String>();
            @Sensitive
            @Injection(name="DEEP_PASSWORD")
            String password = "p@ssword";

            SoooDeep() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SoooDeep soooDeep = (SoooDeep)o;
                return this.isItDeep == soooDeep.isItDeep && this.howDeep == soooDeep.howDeep;
            }

            public int hashCode() {
                return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.isItDeep, this.howDeep});
            }
        }
    }
}

