/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.serialization.MetaXmlSerializer;
import org.pentaho.di.core.util.serialization.RepoSerializer;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.util.serialization.StepMetaPropsTest;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMetaInterface;

@RunWith(value=MockitoJUnitRunner.class)
public class RepoSerializerTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    @Mock
    private Repository repo;
    @Mock
    private ObjectId transId;
    @Mock
    private ObjectId stepId;
    private StepMetaPropsTest.FooMeta stepMeta = StepMetaPropsTest.getTestFooMeta();

    @Before
    public void before() throws KettleException {
        KettleEnvironment.init();
    }

    @Test
    public void testSerialize() throws KettleException {
        String serialized = MetaXmlSerializer.serialize((StepMetaProps)StepMetaProps.from((StepMetaInterface)this.stepMeta));
        RepoSerializer.builder().repo(this.repo).stepId(this.stepId).transId(this.transId).stepMeta((StepMetaInterface)this.stepMeta).serialize();
        ((Repository)Mockito.verify((Object)this.repo, (VerificationMode)Mockito.times((int)1))).saveStepAttribute(this.transId, this.stepId, "step-xml", serialized);
    }

    @Test
    public void testDeserialize() throws KettleException {
        StepMetaPropsTest.FooMeta blankMeta = new StepMetaPropsTest.FooMeta();
        String serialized = MetaXmlSerializer.serialize((StepMetaProps)StepMetaProps.from((StepMetaInterface)this.stepMeta));
        ((Repository)Mockito.doReturn((Object)serialized).when((Object)this.repo)).getStepAttributeString(this.stepId, "step-xml");
        RepoSerializer.builder().repo(this.repo).stepId(this.stepId).stepMeta((StepMetaInterface)blankMeta).deserialize();
        Assert.assertThat((Object)((Object)this.stepMeta), (Matcher)CoreMatchers.equalTo((Object)((Object)blankMeta)));
    }
}

