/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import java.util.Collections;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.serialization.MetaXmlSerializer;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.util.serialization.StepMetaPropsTest;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputFiles;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;

public class MetaXmlSerializerTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void before() throws KettleException {
        KettleEnvironment.init();
    }

    @Test
    public void testRoundTrip() {
        StepMetaPropsTest.FooMeta fooMeta = StepMetaPropsTest.getTestFooMeta();
        StepMetaPropsTest.FooMeta deserializedMeta = new StepMetaPropsTest.FooMeta();
        Objects.requireNonNull(MetaXmlSerializer.deserialize((String)MetaXmlSerializer.serialize((StepMetaProps)StepMetaProps.from((StepMetaInterface)fooMeta)))).to((StepMetaInterface)deserializedMeta);
        MatcherAssert.assertThat((Object)((Object)fooMeta), (Matcher)IsEqual.equalTo((Object)((Object)deserializedMeta)));
    }

    @Test
    public void testRoundTripWithEmptyList() {
        StepMetaPropsTest.FooMeta fooMeta = StepMetaPropsTest.getTestFooMeta();
        StepMetaPropsTest.FooMeta deserializedMeta = new StepMetaPropsTest.FooMeta();
        fooMeta.alist = Collections.emptyList();
        Objects.requireNonNull(MetaXmlSerializer.deserialize((String)MetaXmlSerializer.serialize((StepMetaProps)StepMetaProps.from((StepMetaInterface)fooMeta)))).to((StepMetaInterface)deserializedMeta);
        MatcherAssert.assertThat((Object)((Object)deserializedMeta), (Matcher)IsEqual.equalTo((Object)((Object)fooMeta)));
    }

    @Test
    public void testTextFileInputRoundTrip() {
        TextFileInputMeta fileInputMeta = new TextFileInputMeta();
        fileInputMeta.inputFields = new BaseFileField[]{new BaseFileField("foo", 0, 10), new BaseFileField("bar", 0, 10)};
        fileInputMeta.inputFiles = new BaseFileInputFiles();
        String[] fileNames = new String[]{"file1.txt", "file2.tsv"};
        fileInputMeta.inputFiles.fileName = fileNames;
        TextFileInputMeta rehydratedMeta = new TextFileInputMeta();
        StepMetaProps props = StepMetaProps.from((StepMetaInterface)fileInputMeta);
        MetaXmlSerializer.deserialize((String)MetaXmlSerializer.serialize((StepMetaProps)props)).to((StepMetaInterface)rehydratedMeta);
        MatcherAssert.assertThat((Object)rehydratedMeta.inputFields[0].getName(), (Matcher)IsEqual.equalTo((Object)"foo"));
        MatcherAssert.assertThat((Object)rehydratedMeta.inputFields[1].getName(), (Matcher)IsEqual.equalTo((Object)"bar"));
        MatcherAssert.assertThat((Object)rehydratedMeta.inputFiles.fileName, (Matcher)IsEqual.equalTo((Object)fileNames));
    }
}

