/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileNotFoundException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class ValueDataUtilTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static String yyyy_MM_dd = "yyyy-MM-dd";

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    @Deprecated
    @Test
    public void testLeftTrim() throws KettleValueException {
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.leftTrim((String)""));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.leftTrim((String)"string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.leftTrim((String)" string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.leftTrim((String)"  string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.leftTrim((String)"   string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.leftTrim((String)"     string"));
        Assert.assertEquals((Object)"string ", (Object)ValueDataUtil.leftTrim((String)" string "));
        Assert.assertEquals((Object)"string  ", (Object)ValueDataUtil.leftTrim((String)"  string  "));
        Assert.assertEquals((Object)"string   ", (Object)ValueDataUtil.leftTrim((String)"   string   "));
        Assert.assertEquals((Object)"string    ", (Object)ValueDataUtil.leftTrim((String)"    string    "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.leftTrim((String)" "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.leftTrim((String)"  "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.leftTrim((String)"   "));
    }

    @Deprecated
    @Test
    public void testRightTrim() throws KettleValueException {
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)""));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.rightTrim((String)"string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.rightTrim((String)"string "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.rightTrim((String)"string  "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.rightTrim((String)"string   "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.rightTrim((String)"string    "));
        Assert.assertEquals((Object)" string", (Object)ValueDataUtil.rightTrim((String)" string "));
        Assert.assertEquals((Object)"  string", (Object)ValueDataUtil.rightTrim((String)"  string  "));
        Assert.assertEquals((Object)"   string", (Object)ValueDataUtil.rightTrim((String)"   string   "));
        Assert.assertEquals((Object)"    string", (Object)ValueDataUtil.rightTrim((String)"    string    "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)" "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)"  "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)"   "));
    }

    @Deprecated
    @Test
    public void testIsSpace() throws KettleValueException {
        Assert.assertTrue((boolean)ValueDataUtil.isSpace((char)' '));
        Assert.assertTrue((boolean)ValueDataUtil.isSpace((char)'\t'));
        Assert.assertTrue((boolean)ValueDataUtil.isSpace((char)'\r'));
        Assert.assertTrue((boolean)ValueDataUtil.isSpace((char)'\n'));
        Assert.assertFalse((boolean)ValueDataUtil.isSpace((char)'S'));
        Assert.assertFalse((boolean)ValueDataUtil.isSpace((char)'b'));
    }

    @Deprecated
    @Test
    public void testTrim() throws KettleValueException {
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.trim((String)""));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"string "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"string  "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"string   "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"string    "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)" string "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"  string  "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"   string   "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"    string    "));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)" string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"  string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"   string"));
        Assert.assertEquals((Object)"string", (Object)ValueDataUtil.trim((String)"    string"));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)" "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)"  "));
        Assert.assertEquals((Object)"", (Object)ValueDataUtil.rightTrim((String)"   "));
    }

    @Test
    public void testDateDiff_A_GT_B() {
        Object daysDiff = this.calculate("2010-05-12", "2010-01-01", 3, 43);
        Assert.assertEquals((Object)new Long(131L), (Object)daysDiff);
    }

    @Test
    public void testDateDiff_A_LT_B() {
        Object daysDiff = this.calculate("2010-12-31", "2011-02-10", 3, 43);
        Assert.assertEquals((Object)new Long(-41L), (Object)daysDiff);
    }

    @Test
    public void testWorkingDaysDays_A_GT_B() {
        Object daysDiff = this.calculate("2010-05-12", "2010-01-01", 3, 65);
        Assert.assertEquals((Object)new Long(94L), (Object)daysDiff);
    }

    @Test
    public void testWorkingDaysDays_A_LT_B() {
        Object daysDiff = this.calculate("2010-12-31", "2011-02-10", 3, 65);
        Assert.assertEquals((Object)new Long(-30L), (Object)daysDiff);
    }

    @Test
    public void testPlus() throws KettleValueException {
        long longValue = 1L;
        Assert.assertEquals((Object)longValue, (Object)ValueDataUtil.plus((ValueMetaInterface)new ValueMetaInteger(), (Object)longValue, (ValueMetaInterface)new ValueMetaString(), (Object)""));
    }

    @Test
    public void checksumTest() {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)path, (String)"MD5");
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumMissingFileTest() {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5");
        Assert.assertNull((Object)checksum);
    }

    @Test
    public void checksumNullPathTest() {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5");
        Assert.assertNull((Object)checksum);
    }

    @Test
    public void checksumWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)path, (String)"MD5", (boolean)true);
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)path, (String)"MD5", (boolean)false);
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)checksum);
    }

    @Test
    public void checksumNoFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingFile = "nonExistingFile";
        String checksum = ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile, (String)"MD5", (boolean)false);
        Assert.assertNull((Object)checksum);
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void checksumFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (String)"MD5", (boolean)true);
    }

    @Test
    public void checksumNullPathNoFailTest() throws KettleFileNotFoundException {
        Assert.assertNull((Object)ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), null, (String)"MD5", (boolean)false));
    }

    @Test
    public void checksumNullPathFailTest() throws KettleFileNotFoundException {
        Assert.assertNull((Object)ValueDataUtil.createChecksum((ValueMetaInterface)new ValueMetaString(), null, (String)"MD5", (boolean)true));
    }

    @Test
    public void checksumCRC32Test() {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.ChecksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)path);
        Assert.assertEquals((long)3632233996L, (long)checksum);
    }

    @Test
    public void checksumCRC32MissingFileTest() {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.ChecksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32NullPathTest() throws Exception {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.ChecksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32WithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((long)3632233996L, (long)checksum);
    }

    @Test
    public void checksumCRC32NoFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        long checksum = ValueDataUtil.checksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void checksumCRC32FailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.checksumCRC32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void checksumCRC32NullPathNoFailTest() throws KettleFileNotFoundException {
        long checksum = ValueDataUtil.checksumCRC32((ValueMetaInterface)new ValueMetaString(), null, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumCRC32NullPathFailTest() throws KettleFileNotFoundException {
        long checksum = ValueDataUtil.checksumCRC32((ValueMetaInterface)new ValueMetaString(), null, (boolean)true);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerTest() {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.ChecksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)path);
        Assert.assertEquals((long)73204161L, (long)checksum);
    }

    @Test
    public void checksumAdlerMissingFileTest() {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.ChecksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerNullPathTest() {
        String nonExistingFile = "nonExistingFile";
        long checksum = ValueDataUtil.ChecksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingFile);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertEquals((long)73204161L, (long)checksum);
    }

    @Test
    public void checksumAdlerWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        long checksum = ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((long)73204161L, (long)checksum);
    }

    @Test
    public void checksumAdlerNoFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        long checksum = ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void checksumAdlerFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void checksumAdlerNullPathNoFailTest() throws KettleFileNotFoundException {
        long checksum = ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), null, (boolean)false);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void checksumAdlerNullPathFailTest() throws KettleFileNotFoundException {
        long checksum = ValueDataUtil.checksumAdler32((ValueMetaInterface)new ValueMetaString(), null, (boolean)true);
        Assert.assertEquals((long)0L, (long)checksum);
    }

    @Test
    public void xmlFileWellFormedTest() {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)xmlFilePath);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedTest() {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)invalidXmlFilePath);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedWithFailIfNoFileTest() throws KettleFileNotFoundException {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)xmlFilePath, (boolean)true);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedWithoutFailIfNoFileTest() throws KettleFileNotFoundException {
        String xmlFilePath = this.getClass().getResource("xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)xmlFilePath, (boolean)false);
        Assert.assertTrue((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedWithFailIfNoFileTest() throws KettleFileNotFoundException {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)invalidXmlFilePath, (boolean)true);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileBadlyFormedWithNoFailIfNoFileTest() throws KettleFileNotFoundException {
        String invalidXmlFilePath = this.getClass().getResource("invalid-xml-sample.xml").getPath();
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)invalidXmlFilePath, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedNoFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void xmlFileWellFormedFailIfNoFileTest() throws KettleFileNotFoundException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void xmlFileWellFormedNullPathNoFailTest() throws KettleFileNotFoundException {
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), null, (boolean)false);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void xmlFileWellFormedNullPathFailTest() throws KettleFileNotFoundException {
        boolean wellFormed = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)new ValueMetaString(), null, (boolean)true);
        Assert.assertFalse((boolean)wellFormed);
    }

    @Test
    public void loadFileContentInBinary() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        byte[] content = ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals("test".getBytes(), content));
    }

    @Test
    public void loadFileContentInBinaryNoFailIfNoFileTest() throws Exception {
        String nonExistingPath = "nonExistingPath";
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)false));
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void loadFileContentInBinaryFailIfNoFileTest() throws KettleFileNotFoundException, KettleValueException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void loadFileContentInBinaryNullPathNoFailTest() throws Exception {
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)new ValueMetaString(), null, (boolean)false));
    }

    @Test
    public void loadFileContentInBinaryNullPathFailTest() throws KettleFileNotFoundException, KettleValueException {
        Assert.assertNull((Object)ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)new ValueMetaString(), null, (boolean)true));
    }

    @Test
    public void getFileEncodingTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)path);
        Assert.assertEquals((Object)"US-ASCII", (Object)encoding);
    }

    @Test(expected=KettleValueException.class)
    public void getFileEncodingMissingFileTest() throws KettleValueException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath);
    }

    @Test
    public void getFileEncodingNullPathTest() throws Exception {
        Assert.assertNull((Object)ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), null));
    }

    @Test
    public void getFileEncodingWithFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)true);
        Assert.assertEquals((Object)"US-ASCII", (Object)encoding);
    }

    @Test
    public void getFileEncodingWithoutFailIfNoFileTest() throws Exception {
        String path = this.getClass().getResource("txt-sample.txt").getPath();
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)path, (boolean)false);
        Assert.assertEquals((Object)"US-ASCII", (Object)encoding);
    }

    @Test
    public void getFileEncodingNoFailIfNoFileTest() throws Exception {
        String nonExistingPath = "nonExistingPath";
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)false);
        Assert.assertNull((Object)encoding);
    }

    @Test(expected=KettleFileNotFoundException.class)
    public void getFileEncodingFailIfNoFileTest() throws KettleFileNotFoundException, KettleValueException {
        String nonExistingPath = "nonExistingPath";
        ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), (Object)nonExistingPath, (boolean)true);
    }

    @Test
    public void getFileEncodingNullPathNoFailTest() throws Exception {
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), null, (boolean)false);
        Assert.assertNull((Object)encoding);
    }

    @Test
    public void getFileEncodingNullPathFailTest() throws KettleFileNotFoundException, KettleValueException {
        String encoding = ValueDataUtil.getFileEncoding((ValueMetaInterface)new ValueMetaString(), null, (boolean)true);
        Assert.assertNull((Object)encoding);
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((Object)Double.valueOf("3.0"), (Object)this.calculate("1", "2", 1, 3));
        Assert.assertEquals((Object)Double.valueOf("0.0"), (Object)this.calculate("2", "-2", 1, 3));
        Assert.assertEquals((Object)Double.valueOf("30.0"), (Object)this.calculate("10", "20", 1, 3));
        Assert.assertEquals((Object)Double.valueOf("-50.0"), (Object)this.calculate("-100", "50", 1, 3));
        Assert.assertEquals((Object)Long.valueOf("3"), (Object)this.calculate("1", "2", 5, 3));
        Assert.assertEquals((Object)Long.valueOf("0"), (Object)this.calculate("2", "-2", 5, 3));
        Assert.assertEquals((Object)Long.valueOf("30"), (Object)this.calculate("10", "20", 5, 3));
        Assert.assertEquals((Object)Long.valueOf("-50"), (Object)this.calculate("-100", "50", 5, 3));
        Assert.assertEquals((long)0L, (long)new BigDecimal("2.0").compareTo((BigDecimal)this.calculate("1", "1", 6, 3)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("0.0").compareTo((BigDecimal)this.calculate("2", "-2", 6, 3)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("30.0").compareTo((BigDecimal)this.calculate("10", "20", 6, 3)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("-50.0").compareTo((BigDecimal)this.calculate("-100", "50", 6, 3)));
    }

    @Test
    public void testAdd3() {
        Assert.assertEquals((Object)Double.valueOf("6.0"), (Object)this.calculate("1", "2", "3", 1, 44));
        Assert.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("2", "-2", "10", 1, 44));
        Assert.assertEquals((Object)Double.valueOf("27.0"), (Object)this.calculate("10", "20", "-3", 1, 44));
        Assert.assertEquals((Object)Double.valueOf("-55.0"), (Object)this.calculate("-100", "50", "-5", 1, 44));
        Assert.assertEquals((Object)Long.valueOf("3"), (Object)this.calculate("1", "1", "1", 5, 44));
        Assert.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("2", "-2", "10", 5, 44));
        Assert.assertEquals((Object)Long.valueOf("27"), (Object)this.calculate("10", "20", "-3", 5, 44));
        Assert.assertEquals((Object)Long.valueOf("-55"), (Object)this.calculate("-100", "50", "-5", 5, 44));
        Assert.assertEquals((long)0L, (long)new BigDecimal("6.0").compareTo((BigDecimal)this.calculate("1", "2", "3", 6, 44)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("10.0").compareTo((BigDecimal)this.calculate("2", "-2", "10", 6, 44)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("27.0").compareTo((BigDecimal)this.calculate("10", "20", "-3", 6, 44)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("-55.0").compareTo((BigDecimal)this.calculate("-100", "50", "-5", 6, 44)));
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("20", "10", 1, 4));
        Assert.assertEquals((Object)Double.valueOf("-10.0"), (Object)this.calculate("10", "20", 1, 4));
        Assert.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("20", "10", 5, 4));
        Assert.assertEquals((Object)Long.valueOf("-10"), (Object)this.calculate("10", "20", 5, 4));
        Assert.assertEquals((long)0L, (long)new BigDecimal("10").compareTo((BigDecimal)this.calculate("20", "10", 6, 4)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("-10").compareTo((BigDecimal)this.calculate("10", "20", 6, 4)));
    }

    @Test
    public void testDivide() {
        Assert.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("2", "1", 1, 6));
        Assert.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("4", "2", 1, 6));
        Assert.assertEquals((Object)Double.valueOf("0.5"), (Object)this.calculate("10", "20", 1, 6));
        Assert.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("100", "50", 1, 6));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "1", 5, 6));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("4", "2", 5, 6));
        Assert.assertEquals((Object)Long.valueOf("0"), (Object)this.calculate("10", "20", 5, 6));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("100", "50", 5, 6));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("2", "1", 6, 6));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("4", "2", 6, 6));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("0.5")), (Object)this.calculate("10", "20", 6, 6));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("100", "50", 6, 6));
    }

    @Test
    public void testMulitplyBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("246913578024691357802.2469135780246913578");
        BigDecimal expResult3 = new BigDecimal("123456789012345678901.1200000000000000000");
        BigDecimal expResult4 = new BigDecimal("246913578024691357802");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field2, null));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field3, null));
        Assert.assertEquals((Object)expResult3, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field2, (MathContext)new MathContext(23)));
        Assert.assertEquals((Object)expResult4, (Object)ValueDataUtil.multiplyBigDecimals((BigDecimal)field1, (BigDecimal)field3, (MathContext)new MathContext(21)));
    }

    @Test
    public void testDivisionBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("61728394506172839450.56172839450617283945");
        BigDecimal expResult3 = new BigDecimal("123456789012345678901.12");
        BigDecimal expResult4 = new BigDecimal("61728394506172839450.6");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field2, null));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field3, null));
        Assert.assertEquals((Object)expResult3, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field2, (MathContext)new MathContext(23)));
        Assert.assertEquals((Object)expResult4, (Object)ValueDataUtil.divideBigDecimals((BigDecimal)field1, (BigDecimal)field3, (MathContext)new MathContext(21)));
    }

    @Test
    public void testRemainderBigNumbers() throws Exception {
        BigDecimal field1 = new BigDecimal("123456789012345678901.1234567890123456789");
        BigDecimal field2 = new BigDecimal("1.0");
        BigDecimal field3 = new BigDecimal("2.0");
        BigDecimal expResult1 = new BigDecimal("0.1234567890123456789");
        BigDecimal expResult2 = new BigDecimal("1.1234567890123456789");
        Assert.assertEquals((Object)expResult1, (Object)ValueDataUtil.remainder((ValueMetaInterface)new ValueMetaBigNumber(), (Object)field1, (ValueMetaInterface)new ValueMetaBigNumber(), (Object)field2));
        Assert.assertEquals((Object)expResult2, (Object)ValueDataUtil.remainder((ValueMetaInterface)new ValueMetaBigNumber(), (Object)field1, (ValueMetaInterface)new ValueMetaBigNumber(), (Object)field3));
    }

    @Test
    public void testPercent1() {
        Assert.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("10", "100", 1, 9));
        Assert.assertEquals((Object)Double.valueOf("100.0"), (Object)this.calculate("2", "2", 1, 9));
        Assert.assertEquals((Object)Double.valueOf("50.0"), (Object)this.calculate("10", "20", 1, 9));
        Assert.assertEquals((Object)Double.valueOf("200.0"), (Object)this.calculate("100", "50", 1, 9));
        Assert.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "100", 5, 9));
        Assert.assertEquals((Object)Long.valueOf("100"), (Object)this.calculate("2", "2", 5, 9));
        Assert.assertEquals((Object)Long.valueOf("50"), (Object)this.calculate("10", "20", 5, 9));
        Assert.assertEquals((Object)Long.valueOf("200"), (Object)this.calculate("100", "50", 5, 9));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("10")), (Object)this.calculate("10", "100", 6, 9));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("100")), (Object)this.calculate("2", "2", 6, 9));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("50")), (Object)this.calculate("10", "20", 6, 9));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("200")), (Object)this.calculate("100", "50", 6, 9));
    }

    @Test
    public void testPercent2() {
        Assert.assertEquals((Object)Double.valueOf("0.99"), (Object)this.calculate("1", "1", 1, 10));
        Assert.assertEquals((Object)Double.valueOf("1.96"), (Object)this.calculate("2", "2", 1, 10));
        Assert.assertEquals((Object)Double.valueOf("8.0"), (Object)this.calculate("10", "20", 1, 10));
        Assert.assertEquals((Object)Double.valueOf("50.0"), (Object)this.calculate("100", "50", 1, 10));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 10));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 10));
        Assert.assertEquals((Object)Long.valueOf("8"), (Object)this.calculate("10", "20", 5, 10));
        Assert.assertEquals((Object)Long.valueOf("50"), (Object)this.calculate("100", "50", 5, 10));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("0.99")), (Object)this.calculate("1", "1", 6, 10));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("1.96")), (Object)this.calculate("2", "2", 6, 10));
        Assert.assertEquals((Object)new BigDecimal("8.0"), (Object)this.calculate("10", "20", 6, 10));
        Assert.assertEquals((Object)new BigDecimal("50.0"), (Object)this.calculate("100", "50", 6, 10));
    }

    @Test
    public void testPercent3() {
        Assert.assertEquals((Object)Double.valueOf("1.01"), (Object)this.calculate("1", "1", 1, 11));
        Assert.assertEquals((Object)Double.valueOf("2.04"), (Object)this.calculate("2", "2", 1, 11));
        Assert.assertEquals((Object)Double.valueOf("12.0"), (Object)this.calculate("10", "20", 1, 11));
        Assert.assertEquals((Object)Double.valueOf("150.0"), (Object)this.calculate("100", "50", 1, 11));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 11));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 11));
        Assert.assertEquals((Object)Long.valueOf("12"), (Object)this.calculate("10", "20", 5, 11));
        Assert.assertEquals((Object)Long.valueOf("150"), (Object)this.calculate("100", "50", 5, 11));
        Assert.assertEquals((long)0L, (long)new BigDecimal("1.01").compareTo((BigDecimal)this.calculate("1", "1", 6, 11)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("2.04").compareTo((BigDecimal)this.calculate("2", "2", 6, 11)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("12").compareTo((BigDecimal)this.calculate("10", "20", 6, 11)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("150").compareTo((BigDecimal)this.calculate("100", "50", 6, 11)));
    }

    @Test
    public void testCombination1() {
        Assert.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("1", "1", "1", 1, 12));
        Assert.assertEquals((Object)Double.valueOf("22.0"), (Object)this.calculate("2", "2", "10", 1, 12));
        Assert.assertEquals((Object)Double.valueOf("70.0"), (Object)this.calculate("10", "20", "3", 1, 12));
        Assert.assertEquals((Object)Double.valueOf("350"), (Object)this.calculate("100", "50", "5", 1, 12));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("1", "1", "1", 5, 12));
        Assert.assertEquals((Object)Long.valueOf("22"), (Object)this.calculate("2", "2", "10", 5, 12));
        Assert.assertEquals((Object)Long.valueOf("70"), (Object)this.calculate("10", "20", "3", 5, 12));
        Assert.assertEquals((Object)Long.valueOf("350"), (Object)this.calculate("100", "50", "5", 5, 12));
        Assert.assertEquals((long)0L, (long)new BigDecimal("2.0").compareTo((BigDecimal)this.calculate("1", "1", "1", 6, 12)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("22.0").compareTo((BigDecimal)this.calculate("2", "2", "10", 6, 12)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("70.0").compareTo((BigDecimal)this.calculate("10", "20", "3", 6, 12)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("350.0").compareTo((BigDecimal)this.calculate("100", "50", "5", 6, 12)));
    }

    @Test
    public void testCombination2() {
        Assert.assertEquals((Object)Double.valueOf("1.4142135623730951"), (Object)this.calculate("1", "1", 1, 13));
        Assert.assertEquals((Object)Double.valueOf("2.8284271247461903"), (Object)this.calculate("2", "2", 1, 13));
        Assert.assertEquals((Object)Double.valueOf("22.360679774997898"), (Object)this.calculate("10", "20", 1, 13));
        Assert.assertEquals((Object)Double.valueOf("111.80339887498948"), (Object)this.calculate("100", "50", 1, 13));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 13));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 13));
        Assert.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "20", 5, 13));
        Assert.assertEquals((Object)Long.valueOf("100"), (Object)this.calculate("100", "50", 5, 13));
        Assert.assertEquals((long)0L, (long)new BigDecimal("1.4142135623730951").compareTo((BigDecimal)this.calculate("1", "1", 6, 13)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("2.8284271247461903").compareTo((BigDecimal)this.calculate("2", "2", 6, 13)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("22.360679774997898").compareTo((BigDecimal)this.calculate("10", "20", 6, 13)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("111.80339887498948").compareTo((BigDecimal)this.calculate("100", "50", 6, 13)));
    }

    @Test
    public void testRound() {
        Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)this.calculate("1", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("103.0"), (Object)this.calculate("103.01", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("1235.0"), (Object)this.calculate("1234.6", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("1235.0"), (Object)this.calculate("1234.5", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("1236.0"), (Object)this.calculate("1235.5", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("-1234.0"), (Object)this.calculate("-1234.5", 1, 14));
        Assert.assertEquals((Object)Double.valueOf("-1235.0"), (Object)this.calculate("-1235.5", 1, 14));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", 5, 14));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", 5, 14));
        Assert.assertEquals((Object)Long.valueOf("-103"), (Object)this.calculate("-103", 5, 14));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)this.calculate("1", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("103")), (Object)this.calculate("103.01", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("1235")), (Object)this.calculate("1234.6", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("1235")), (Object)this.calculate("1234.5", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("1236")), (Object)this.calculate("1235.5", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("-1234")), (Object)this.calculate("-1234.5", 6, 14));
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("-1235")), (Object)this.calculate("-1235.5", 6, 14));
    }

    @Test
    public void testRound2() {
        Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)this.calculate("1", "1", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("2.1"), (Object)this.calculate("2.06", "1", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("103.0"), (Object)this.calculate("103.01", "1", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("12.35"), (Object)this.calculate("12.346", "2", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("12.0", "-1", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("12.35"), (Object)this.calculate("12.345", "2", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("12.36"), (Object)this.calculate("12.355", "2", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("-12.34"), (Object)this.calculate("-12.345", "2", 1, 15));
        Assert.assertEquals((Object)Double.valueOf("-12.35"), (Object)this.calculate("-12.355", "2", 1, 15));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("103"), (Object)this.calculate("103", "3", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("12"), (Object)this.calculate("12", "4", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("100"), (Object)this.calculate("120", "-2", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("12350"), (Object)this.calculate("12345", "-1", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("12360"), (Object)this.calculate("12355", "-1", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("-12340"), (Object)this.calculate("-12345", "-1", 5, 15));
        Assert.assertEquals((Object)Long.valueOf("-12350"), (Object)this.calculate("-12355", "-1", 5, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("1.0")), (Object)this.calculate("1", "1", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("2.1")), (Object)this.calculate("2.06", "1", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("103.0")), (Object)this.calculate("103.01", "1", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("12.35")), (Object)this.calculate("12.346", "2", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("10.0")).setScale(-1), (Object)this.calculate("12.0", "-1", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("12.35")), (Object)this.calculate("12.345", "2", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("12.36")), (Object)this.calculate("12.355", "2", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("-12.34")), (Object)this.calculate("-12.345", "2", 6, 15));
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("-12.35")), (Object)this.calculate("-12.355", "2", 6, 15));
    }

    @Test
    public void testNVL() {
        Assert.assertEquals((Object)Double.valueOf("1.0"), (Object)this.calculate("1", "", 1, 20));
        Assert.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("", "2", 1, 20));
        Assert.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("10", "20", 1, 20));
        Assert.assertEquals(null, (Object)this.calculate("", "", 1, 20));
        Assert.assertEquals((Object)"1", (Object)this.calculate("1", "", 2, 20));
        Assert.assertEquals((Object)"2", (Object)this.calculate("", "2", 2, 20));
        Assert.assertEquals((Object)"10", (Object)this.calculate("10", "20", 2, 20));
        Assert.assertEquals(null, (Object)this.calculate("", "", 2, 20));
        Assert.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "", 5, 20));
        Assert.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("", "2", 5, 20));
        Assert.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "20", 5, 20));
        Assert.assertEquals(null, (Object)this.calculate("", "", 5, 20));
        Assert.assertEquals((long)0L, (long)new BigDecimal("1").compareTo((BigDecimal)this.calculate("1", "", 6, 20)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("2").compareTo((BigDecimal)this.calculate("", "2", 6, 20)));
        Assert.assertEquals((long)0L, (long)new BigDecimal("10").compareTo((BigDecimal)this.calculate("10", "20", 6, 20)));
        Assert.assertEquals(null, (Object)this.calculate("", "", 6, 20));
        Assert.assertEquals((Object)true, (Object)this.calculate("true", "", 4, 20));
        Assert.assertEquals((Object)false, (Object)this.calculate("", "false", 4, 20));
        Assert.assertEquals((Object)false, (Object)this.calculate("false", "true", 4, 20));
        Assert.assertEquals(null, (Object)this.calculate("", "", 4, 20));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(yyyy_MM_dd);
        try {
            Assert.assertEquals((Object)simpleDateFormat.parse("2012-04-11"), (Object)this.calculate("2012-04-11", "", 3, 20));
            Assert.assertEquals((Object)simpleDateFormat.parse("2012-11-04"), (Object)this.calculate("", "2012-11-04", 3, 20));
            Assert.assertEquals((Object)simpleDateFormat.parse("1965-07-01"), (Object)this.calculate("1965-07-01", "1967-04-11", 3, 20));
            Assert.assertNull((Object)this.calculate("", "", 3, 20));
        }
        catch (ParseException pe) {
            Assert.fail((String)pe.getMessage());
        }
        ValueMetaString stringValueMeta = new ValueMetaString("string");
        try {
            byte[] data = stringValueMeta.getBinary((Object)"101");
            byte[] calculated = (byte[])this.calculate("101", "", 8, 20);
            Assert.assertTrue((boolean)Arrays.equals(data, calculated));
            data = stringValueMeta.getBinary((Object)"011");
            calculated = (byte[])this.calculate("", "011", 8, 20);
            Assert.assertTrue((boolean)Arrays.equals(data, calculated));
            data = stringValueMeta.getBinary((Object)"110");
            calculated = (byte[])this.calculate("110", "011", 8, 20);
            Assert.assertTrue((boolean)Arrays.equals(data, calculated));
            calculated = (byte[])this.calculate("", "", 8, 20);
            Assert.assertNull((Object)calculated);
        }
        catch (KettleValueException kve) {
            Assert.fail((String)kve.getMessage());
        }
    }

    @Test
    public void testRemainder() throws Exception {
        Assert.assertNull((Object)this.calculate(null, null, 5, 88));
        Assert.assertNull((Object)this.calculate(null, "3", 5, 88));
        Assert.assertNull((Object)this.calculate("10", null, 5, 88));
        Assert.assertEquals((Object)new Long("1"), (Object)this.calculate("10", "3", 5, 88));
        Assert.assertEquals((Object)new Long("-1"), (Object)this.calculate("-10", "3", 5, 88));
        Double comparisonDelta = new Double("0.0000000000001");
        Assert.assertNull((Object)this.calculate(null, null, 1, 88));
        Assert.assertNull((Object)this.calculate(null, "4.1", 1, 88));
        Assert.assertNull((Object)this.calculate("17.8", null, 1, 88));
        Assert.assertEquals((double)new Double("1.4"), (double)((Double)this.calculate("17.8", "4.1", 1, 88)), (double)comparisonDelta);
        Assert.assertEquals((double)new Double("1.4"), (double)((Double)this.calculate("17.8", "-4.1", 1, 88)), (double)comparisonDelta);
        Assert.assertEquals((double)new Double("-1.4"), (double)((Double)this.calculate("-17.8", "-4.1", 1, 88)), (double)comparisonDelta);
        Assert.assertNull((Object)this.calculate(null, null, 6, 88));
        Assert.assertNull((Object)this.calculate(null, "16.12", 6, 88));
        Assert.assertNull((Object)this.calculate("-144.144", null, 6, 88));
        Assert.assertEquals((Object)new BigDecimal("-15.184"), (Object)this.calculate("-144.144", "16.12", 6, 88));
        Assert.assertEquals((Object)new Double("2.6000000000000005"), (Object)this.calculate("12.5", "3.3", 1, 88));
        Assert.assertEquals((Object)new Double("4.0"), (Object)this.calculate("12.5", "4.25", 1, 88));
        Assert.assertEquals((Object)new Long("1"), (Object)this.calculate("10", "3.3", null, 5, 1, 1, 88));
    }

    @Test
    public void testSumWithNullValues() throws Exception {
        ValueMetaInteger metaA = new ValueMetaInteger();
        metaA.setStorageType(0);
        ValueMetaInteger metaB = new ValueMetaInteger();
        metaA.setStorageType(0);
        Assert.assertNull((Object)ValueDataUtil.sum((ValueMetaInterface)metaA, null, (ValueMetaInterface)metaB, null));
        Long valueB = new Long(2L);
        ValueDataUtil.sum((ValueMetaInterface)metaA, null, (ValueMetaInterface)metaB, (Object)valueB);
    }

    @Test
    public void testSumConvertingStorageTypeToNormal() throws Exception {
        ValueMetaInterface metaA = (ValueMetaInterface)Mockito.mock(ValueMetaInteger.class);
        metaA.setStorageType(1);
        ValueMetaInteger metaB = new ValueMetaInteger();
        metaB.setStorageType(1);
        String valueB = "2";
        Mockito.when((Object)metaA.convertData((ValueMetaInterface)metaB, (Object)valueB)).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                return new Long(2L);
            }
        });
        Object returnValue = ValueDataUtil.sum((ValueMetaInterface)metaA, null, (ValueMetaInterface)metaB, (Object)valueB);
        ((ValueMetaInterface)Mockito.verify((Object)metaA)).convertData((ValueMetaInterface)metaB, (Object)valueB);
        Assert.assertEquals((Object)2L, (Object)returnValue);
        Assert.assertEquals((long)metaA.getStorageType(), (long)0L);
    }

    @Test
    public void testJaro() {
        Assert.assertEquals((Object)new Double("0.0"), (Object)this.calculate("abcd", "defg", 2, 72));
        Assert.assertEquals((Object)new Double("0.44166666666666665"), (Object)this.calculate("elephant", "hippo", 2, 72));
        Assert.assertEquals((Object)new Double("0.8666666666666667"), (Object)this.calculate("hello", "hallo", 2, 72));
    }

    @Test
    public void testJaroWinkler() {
        Assert.assertEquals((Object)new Double("0.0"), (Object)this.calculate("abcd", "defg", 2, 73));
    }

    private Object calculate(String string_dataA, int valueMetaInterfaceType, int calculatorMetaFunction) {
        return this.calculate(string_dataA, null, null, valueMetaInterfaceType, calculatorMetaFunction);
    }

    private Object calculate(String string_dataA, String string_dataB, int valueMetaInterfaceType, int calculatorMetaFunction) {
        return this.calculate(string_dataA, string_dataB, null, valueMetaInterfaceType, calculatorMetaFunction);
    }

    private Object createObject(String string_value, int valueMetaInterfaceType, ValueMetaInterface parameterValueMeta) throws KettleValueException {
        if (valueMetaInterfaceType == 1) {
            return !Utils.isEmpty((CharSequence)string_value) ? Double.valueOf(string_value) : null;
        }
        if (valueMetaInterfaceType == 5) {
            return !Utils.isEmpty((CharSequence)string_value) ? Long.valueOf(string_value) : null;
        }
        if (valueMetaInterfaceType == 3) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(yyyy_MM_dd);
            try {
                return !Utils.isEmpty((CharSequence)string_value) ? simpleDateFormat.parse(string_value) : null;
            }
            catch (ParseException pe) {
                Assert.fail((String)pe.getMessage());
                return null;
            }
        }
        if (valueMetaInterfaceType == 6) {
            return !Utils.isEmpty((CharSequence)string_value) ? BigDecimal.valueOf(Double.valueOf(string_value)) : null;
        }
        if (valueMetaInterfaceType == 2) {
            return !Utils.isEmpty((CharSequence)string_value) ? string_value : null;
        }
        if (valueMetaInterfaceType == 8) {
            ValueMetaBinary binaryValueMeta = new ValueMetaBinary("binary_data");
            return !Utils.isEmpty((CharSequence)string_value) ? binaryValueMeta.convertData(parameterValueMeta, (Object)string_value) : null;
        }
        if (valueMetaInterfaceType == 4) {
            if (!Utils.isEmpty((CharSequence)string_value)) {
                return string_value.equalsIgnoreCase("true");
            }
            return null;
        }
        Assert.fail((String)"Invalid ValueMetaInterface type.");
        return null;
    }

    private Object calculate(String string_dataA, String string_dataB, String string_dataC, int valueMetaInterfaceTypeABC, int calculatorMetaFunction) {
        return this.calculate(string_dataA, string_dataB, string_dataC, valueMetaInterfaceTypeABC, valueMetaInterfaceTypeABC, valueMetaInterfaceTypeABC, calculatorMetaFunction);
    }

    private Object calculate(String string_dataA, String string_dataB, String string_dataC, int valueMetaInterfaceTypeA, int valueMetaInterfaceTypeB, int valueMetaInterfaceTypeC, int calculatorMetaFunction) {
        try {
            ValueMetaString parameterValueMeta = new ValueMetaString("parameter");
            ValueMetaInterface valueMetaA = this.createValueMeta("data_A", valueMetaInterfaceTypeA);
            ValueMetaInterface valueMetaB = this.createValueMeta("data_B", valueMetaInterfaceTypeB);
            ValueMetaInterface valueMetaC = this.createValueMeta("data_C", valueMetaInterfaceTypeC);
            Object dataA = this.createObject(string_dataA, valueMetaInterfaceTypeA, (ValueMetaInterface)parameterValueMeta);
            Object dataB = this.createObject(string_dataB, valueMetaInterfaceTypeB, (ValueMetaInterface)parameterValueMeta);
            Object dataC = this.createObject(string_dataC, valueMetaInterfaceTypeC, (ValueMetaInterface)parameterValueMeta);
            if (calculatorMetaFunction == 3) {
                return ValueDataUtil.plus((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 44) {
                return ValueDataUtil.plus3((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB, (ValueMetaInterface)valueMetaC, (Object)dataC);
            }
            if (calculatorMetaFunction == 4) {
                return ValueDataUtil.minus((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 6) {
                return ValueDataUtil.divide((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 9) {
                return ValueDataUtil.percent1((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 10) {
                return ValueDataUtil.percent2((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 11) {
                return ValueDataUtil.percent3((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 12) {
                return ValueDataUtil.combination1((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB, (ValueMetaInterface)valueMetaC, (Object)dataC);
            }
            if (calculatorMetaFunction == 13) {
                return ValueDataUtil.combination2((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 14) {
                return ValueDataUtil.round((ValueMetaInterface)valueMetaA, (Object)dataA);
            }
            if (calculatorMetaFunction == 15) {
                return ValueDataUtil.round((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 20) {
                return ValueDataUtil.nvl((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 43) {
                return ValueDataUtil.DateDiff((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB, (String)"");
            }
            if (calculatorMetaFunction == 65) {
                return ValueDataUtil.DateWorkingDiff((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 88) {
                return ValueDataUtil.remainder((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 72) {
                return ValueDataUtil.getJaro_Similitude((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 73) {
                return ValueDataUtil.getJaroWinkler_Similitude((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 5) {
                return ValueDataUtil.multiply((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            Assert.fail((String)"Invalid CalculatorMetaFunction specified.");
            return null;
        }
        catch (KettleValueException kve) {
            Assert.fail((String)kve.getMessage());
            return null;
        }
    }

    private ValueMetaInterface createValueMeta(String name, int valueType) {
        try {
            return ValueMetaFactory.createValueMeta((String)name, (int)valueType);
        }
        catch (KettlePluginException e) {
            throw new RuntimeException(e);
        }
    }
}

