/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.reflection;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.reflection.StringSearcher;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;

public class StringSearcherTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init();
    }

    @Test
    public void testSearchConditionCase() {
        String dummyStepname = "Output";
        DummyTransMeta dummyMeta = new DummyTransMeta();
        String dummyStepPid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)dummyMeta);
        StepMeta dummyStep = new StepMeta(dummyStepPid, dummyStepname, (StepMetaInterface)dummyMeta);
        ArrayList stringList = new ArrayList();
        StringSearcher.findMetaData((Object)dummyStep, (int)0, stringList, (Object)dummyMeta, (Object)0);
        int checkCount = 0;
        String aResult = null;
        for (int i = 0; i < stringList.size(); ++i) {
            aResult = ((StringSearchResult)stringList.get(i)).toString();
            if (aResult.endsWith("Dummy (stepid)")) {
                ++checkCount;
            } else if (aResult.endsWith("Output (name)")) {
                ++checkCount;
            }
            if (checkCount == 2) break;
        }
        Assert.assertEquals((long)2L, (long)checkCount);
        FilterRowsMeta filterRowsMeta = new FilterRowsMeta();
        Condition condition = new Condition();
        condition.setNegated(false);
        condition.setLeftValuename("wibble_t");
        condition.setRightValuename("wobble_s");
        condition.setFunction(0);
        filterRowsMeta.setDefault();
        filterRowsMeta.setCondition(condition);
        String filterRowsPluginPid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)filterRowsMeta);
        StepMeta filterRowsStep = new StepMeta(filterRowsPluginPid, "Filter Rows", (StepMetaInterface)filterRowsMeta);
        stringList.clear();
        StringSearcher.findMetaData((Object)filterRowsStep, (int)0, stringList, (Object)filterRowsMeta, (Object)0);
        checkCount = 0;
        for (int i = 0; i < stringList.size(); ++i) {
            aResult = ((StringSearchResult)stringList.get(i)).toString();
            if (aResult.endsWith("FilterRows (stepid)")) {
                ++checkCount;
            } else if (aResult.endsWith("Filter Rows (name)")) {
                ++checkCount;
            }
            if (checkCount == 2) break;
        }
        Assert.assertEquals((long)2L, (long)checkCount);
    }
}

