/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LoggingBuffer;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KettleLogStore.class, Utils.class, Const.class})
public class BaseLogTableTest {
    @Test
    public void testRemoveChannelFromBufferCallInGetLogBufferInFirstJobExecution() {
        StringBuffer sb = new StringBuffer("");
        LoggingBuffer lb = (LoggingBuffer)Mockito.mock(LoggingBuffer.class);
        ((LoggingBuffer)Mockito.doReturn((Object)sb).when((Object)lb)).getBuffer(Matchers.anyString(), Matchers.anyBoolean());
        PowerMockito.mockStatic(KettleLogStore.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Const.class, (Class[])new Class[0]);
        Mockito.when((Object)KettleLogStore.getAppender()).thenReturn((Object)lb);
        BaseLogTable baseLogTable = (BaseLogTable)Mockito.mock(BaseLogTable.class);
        ((BaseLogTable)Mockito.doCallRealMethod().when((Object)baseLogTable)).getLogBuffer((VariableSpace)Matchers.any(VariableSpace.class), Matchers.anyString(), (LogStatus)Matchers.any(LogStatus.class), Matchers.anyString());
        VariableSpace vs = (VariableSpace)Mockito.mock(VariableSpace.class);
        String s1 = baseLogTable.getLogBuffer(vs, "1", LogStatus.START, null);
        String s2 = baseLogTable.getLogBuffer(vs, "1", LogStatus.END, null);
        Assert.assertEquals((Object)(Const.CR + "START" + Const.CR), (Object)s1);
        Assert.assertEquals((String)(Const.CR + "START" + Const.CR), (Object)(s1 + Const.CR + "END" + Const.CR), (Object)s2);
        ((LoggingBuffer)Mockito.verify((Object)lb, (VerificationMode)Mockito.times((int)1))).removeChannelFromBuffer("1");
    }

    @Test
    public void testRemoveChannelFromBufferCallInGetLogBufferInRecursiveJobExecution() {
        StringBuffer sb = new StringBuffer("Event previously executed for the same Job");
        LoggingBuffer lb = (LoggingBuffer)Mockito.mock(LoggingBuffer.class);
        ((LoggingBuffer)Mockito.doReturn((Object)sb).when((Object)lb)).getBuffer(Matchers.anyString(), Matchers.anyBoolean());
        PowerMockito.mockStatic(KettleLogStore.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Const.class, (Class[])new Class[0]);
        Mockito.when((Object)KettleLogStore.getAppender()).thenReturn((Object)lb);
        BaseLogTable baseLogTable = (BaseLogTable)Mockito.mock(BaseLogTable.class);
        ((BaseLogTable)Mockito.doCallRealMethod().when((Object)baseLogTable)).getLogBuffer((VariableSpace)Matchers.any(VariableSpace.class), Matchers.anyString(), (LogStatus)Matchers.any(LogStatus.class), Matchers.anyString());
        VariableSpace vs = (VariableSpace)Mockito.mock(VariableSpace.class);
        String s1 = baseLogTable.getLogBuffer(vs, "1", LogStatus.START, null);
        String s2 = baseLogTable.getLogBuffer(vs, "1", LogStatus.END, null);
        s1 = s1.replace("Event previously executed for the same Job", "");
        s2 = s2.replace("Event previously executed for the same Job", "");
        Assert.assertEquals((Object)(Const.CR + "START" + Const.CR), (Object)s1);
        Assert.assertEquals((String)(Const.CR + "START" + Const.CR), (Object)(s1 + Const.CR + "END" + Const.CR), (Object)s2);
        ((LoggingBuffer)Mockito.verify((Object)lb, (VerificationMode)Mockito.times((int)1))).removeChannelFromBuffer("1");
    }
}

