/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.listeners.impl;

import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.listeners.impl.EntryCurrentDirectoryChangedListener;

public class EntryCurrentDirectoryChangedListenerTest {
    private static final String VAR = "${Internal.Entry.Current.Directory}";

    @Test
    public void testDirectoryChanged() {
        String path1 = "${Internal.Entry.Current.Directory}/ahoy/file";
        TestPathRef pathRefRepName = new TestPathRef();
        pathRefRepName.setSpecification(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        pathRefRepName.setPath("${Internal.Entry.Current.Directory}/ahoy/file");
        TestPathRef pathRefRepRef = new TestPathRef();
        pathRefRepRef.setSpecification(ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        pathRefRepRef.setPath(VAR);
        TestPathRef pathRefFile = new TestPathRef();
        pathRefFile.setSpecification(ObjectLocationSpecificationMethod.FILENAME);
        pathRefFile.setPath("${Internal.Entry.Current.Directory}/ahoy/file");
        EntryCurrentDirectoryChangedListener listener = new EntryCurrentDirectoryChangedListener(new EntryCurrentDirectoryChangedListener.PathReference[]{pathRefRepName, pathRefRepRef, pathRefFile});
        listener.directoryChanged(new Object(), "/home/user", "/home/user/ahoy");
        String path1After = "${Internal.Entry.Current.Directory}/file";
        Assert.assertEquals((Object)"${Internal.Entry.Current.Directory}/file", (Object)pathRefRepName.getPath());
        Assert.assertEquals((Object)"${Internal.Entry.Current.Directory}/file", (Object)pathRefFile.getPath());
        Assert.assertEquals((Object)VAR, (Object)pathRefRepRef.getPath());
    }

    @Test
    public void testDirectoryChangedNotAncestor() {
        String path1 = "${Internal.Entry.Current.Directory}/file";
        TestPathRef pathRefRepName = new TestPathRef();
        pathRefRepName.setSpecification(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        pathRefRepName.setPath("${Internal.Entry.Current.Directory}/file");
        EntryCurrentDirectoryChangedListener listener = new EntryCurrentDirectoryChangedListener(pathRefRepName::getSpecification, pathRefRepName::getPath, pathRefRepName::setPath);
        listener.directoryChanged(new Object(), "/home/user/ahoy", "/some/where/over/the/rainbow");
        Assert.assertEquals((Object)"/home/user/ahoy/file", (Object)pathRefRepName.getPath());
    }

    public class TestPathRef
    implements EntryCurrentDirectoryChangedListener.PathReference {
        private String path;
        private ObjectLocationSpecificationMethod spec;

        public ObjectLocationSpecificationMethod getSpecification() {
            return this.spec;
        }

        public void setSpecification(ObjectLocationSpecificationMethod value) {
            this.spec = value;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }
    }
}

