/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.injection.MetaBeanLevel1;
import org.pentaho.di.core.injection.MetaBeanLevel2;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanInjector;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;
import org.pentaho.di.core.logging.KettleLogStore;

public class BeanInjectorTest {
    @Before
    public void before() {
        KettleLogStore.init();
    }

    @Test
    public void allocateCollectionField_List() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[]{"one", "two", "three", "four"});
        Assert.assertNull(mbl1.getSub().getAscending());
        bi.allocateCollectionField((Object)mbl1.getSub(), bii, "ASCENDING_LIST");
        Assert.assertEquals((long)4L, (long)mbl1.getSub().getAscending().size());
    }

    @Test
    public void allocateCollectionField_Array() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setAscending(Arrays.asList(true, false));
        Assert.assertNull((Object)mbl1.getSub().getFilenames());
        bi.allocateCollectionField((Object)mbl1.getSub(), bii, "FILENAME_ARRAY");
        Assert.assertEquals((long)2L, (long)mbl1.getSub().getFilenames().length);
    }

    @Test
    public void allocateCollectionField_NonCollection() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        Assert.assertNull((Object)mbl1.getSub().getFilenames());
        Assert.assertNull(mbl1.getSub().getAscending());
        bi.allocateCollectionField((Object)mbl1.getSub(), bii, "SEPARATOR");
        Assert.assertNull((Object)mbl1.getSub().getFilenames());
        Assert.assertNull(mbl1.getSub().getAscending());
    }

    @Test
    public void allocateCollectionField_Property_Array_IntiallyNull() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        BeanInjectionInfo.Property arrayProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("FILENAME_ARRAY")).findFirst().orElse(null);
        Assert.assertNull((Object)mbl1.getSub().getFilenames());
        bi.allocateCollectionField(arrayProperty, (Object)mbl1.getSub(), 7);
        Assert.assertEquals((long)7L, (long)mbl1.getSub().getFilenames().length);
    }

    @Test
    public void allocateCollectionField_Property_Array_IntiallyEmpty() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[0]);
        BeanInjectionInfo.Property arrayProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("FILENAME_ARRAY")).findFirst().orElse(null);
        Assert.assertEquals((long)0L, (long)mbl1.getSub().getFilenames().length);
        bi.allocateCollectionField(arrayProperty, (Object)mbl1.getSub(), 7);
        Assert.assertEquals((long)7L, (long)mbl1.getSub().getFilenames().length);
    }

    @Test
    public void allocateCollectionField_Property_List_IntiallyNull() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        BeanInjectionInfo.Property listProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("ASCENDING_LIST")).findFirst().orElse(null);
        Assert.assertNull(mbl1.getSub().getAscending());
        bi.allocateCollectionField(listProperty, (Object)mbl1.getSub(), 6);
        Assert.assertEquals((long)6L, (long)mbl1.getSub().getAscending().size());
    }

    @Test
    public void allocateCollectionField_Property_List_IntiallyEmpty() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setAscending(new ArrayList<Boolean>());
        BeanInjectionInfo.Property listProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("ASCENDING_LIST")).findFirst().orElse(null);
        Assert.assertEquals((long)0L, (long)mbl1.getSub().getAscending().size());
        bi.allocateCollectionField(listProperty, (Object)mbl1.getSub(), 6);
        Assert.assertEquals((long)6L, (long)mbl1.getSub().getAscending().size());
    }

    @Test
    public void isCollection_True() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        BeanInjectionInfo.Property collectionProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("FILENAME_ARRAY")).findFirst().orElse(null);
        Assert.assertTrue((boolean)bi.isCollection(collectionProperty));
    }

    @Test
    public void isCollection_False() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        BeanInjectionInfo.Property seperatorProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("SEPARATOR")).findFirst().orElse(null);
        Assert.assertFalse((boolean)bi.isCollection(seperatorProperty));
    }

    @Test
    public void isCollection_BeanLevelInfo() {
        BeanInjector bi = new BeanInjector(null);
        BeanLevelInfo bli_list = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.LIST;
        Assert.assertTrue((boolean)bi.isCollection(bli_list));
        BeanLevelInfo bli_array = new BeanLevelInfo();
        bli_array.dim = BeanLevelInfo.DIMENSION.ARRAY;
        Assert.assertTrue((boolean)bi.isCollection(bli_array));
        BeanLevelInfo bli_none = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.NONE;
        Assert.assertFalse((boolean)bi.isCollection(bli_none));
    }

    @Test
    public void isArray() {
        BeanInjector bi = new BeanInjector(null);
        BeanLevelInfo bli_list = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.LIST;
        Assert.assertFalse((boolean)bi.isArray(bli_list));
        BeanLevelInfo bli_array = new BeanLevelInfo();
        bli_array.dim = BeanLevelInfo.DIMENSION.ARRAY;
        Assert.assertTrue((boolean)bi.isArray(bli_array));
        BeanLevelInfo bli_none = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.NONE;
        Assert.assertFalse((boolean)bi.isArray(bli_none));
    }

    @Test
    public void isList() {
        BeanInjector bi = new BeanInjector(null);
        BeanLevelInfo bli_list = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.LIST;
        Assert.assertTrue((boolean)bi.isList(bli_list));
        BeanLevelInfo bli_array = new BeanLevelInfo();
        bli_array.dim = BeanLevelInfo.DIMENSION.ARRAY;
        Assert.assertFalse((boolean)bi.isList(bli_array));
        BeanLevelInfo bli_none = new BeanLevelInfo();
        bli_list.dim = BeanLevelInfo.DIMENSION.NONE;
        Assert.assertFalse((boolean)bi.isList(bli_none));
    }

    @Test
    public void getFinalPath_Null() {
        BeanInjectionInfo bii;
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo beanInjectionInfo = bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        beanInjectionInfo.getClass();
        BeanInjectionInfo.Property noPathProperty = new BeanInjectionInfo.Property(beanInjectionInfo, "name", "groupName", Collections.EMPTY_LIST);
        Assert.assertNull((Object)bi.getFinalPath(noPathProperty));
    }

    @Test
    public void getFinalPath_Found() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        BeanInjectionInfo.Property seperatorProperty = bii.getProperties().values().stream().filter(p -> p.getName().equals("SEPARATOR")).findFirst().orElse(null);
        Assert.assertEquals(seperatorProperty.getPath().get(2), (Object)bi.getFinalPath(seperatorProperty));
    }

    @Test
    public void getProperty_Found() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        BeanInjectionInfo.Property actualProperty = bi.getProperty(bii, "SEPARATOR");
        Assert.assertNotNull((Object)actualProperty);
        Assert.assertEquals((Object)"SEPARATOR", (Object)actualProperty.getName());
    }

    @Test
    public void getProperty_NotFound() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        BeanInjectionInfo.Property actualProperty = bi.getProperty(bii, "DOES_NOT_EXIST");
        Assert.assertNull((Object)actualProperty);
    }

    @Test
    public void getGroupProperties_NonEmptyGroup() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[]{"file1", "file2", "file3"});
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        mbl1.getSub().setSeparator("/");
        List actualProperties = bi.getGroupProperties(bii, "FILENAME_LINES2");
        Assert.assertNotNull((Object)actualProperties);
        Assert.assertEquals((long)2L, (long)actualProperties.size());
        Assert.assertNotNull(bii.getProperties().values().stream().filter(p -> p.getName().equals("ASCENDING_LIST")));
        Assert.assertNotNull(bii.getProperties().values().stream().filter(p -> p.getName().equals("FILENAME_ARRAY")));
    }

    @Test
    public void getGroupProperties_GroupDoesNotExist() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[]{"file1", "file2", "file3"});
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        mbl1.getSub().setSeparator("/");
        List actualProperties = bi.getGroupProperties(bii, "GLOBAL_DOES_NOT_EXIST");
        Assert.assertNotNull((Object)actualProperties);
        Assert.assertEquals((long)0L, (long)actualProperties.size());
    }

    @Test
    public void getMaxSize_Collections() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[]{"file1", "file2", "file3"});
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        mbl1.getSub().setSeparator("/");
        Assert.assertEquals((Object)new Integer(4), (Object)bi.getMaxSize(bii.getProperties().values(), (Object)mbl1.getSub()));
    }

    @Test
    public void getMaxSize_OnlyOneField() {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setSeparator("/");
        Assert.assertEquals((Object)new Integer(1), (Object)bi.getMaxSize(bii.getProperties().values(), (Object)mbl1.getSub()));
    }

    @Test
    public void getCollectionSize_Property_Array() throws Exception {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setFilenames(new String[]{"file1", "file2", "file3"});
        BeanInjectionInfo.Property property = bii.getProperties().values().stream().filter(p -> p.getName().equals("FILENAME_ARRAY")).findFirst().orElse(null);
        Assert.assertEquals((long)3L, (long)bi.getCollectionSize(property, (Object)mbl1.getSub()));
    }

    @Test
    public void getCollectionSize_Property_List() throws Exception {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        BeanInjectionInfo.Property property = bii.getProperties().values().stream().filter(p -> p.getName().equals("ASCENDING_LIST")).findFirst().orElse(null);
        Assert.assertEquals((long)4L, (long)bi.getCollectionSize(property, (Object)mbl1.getSub()));
    }

    @Test
    public void getCollectionSize_BeanLevelInfo_Exception() throws Exception {
        BeanInjector bi = new BeanInjector(null);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        BeanLevelInfo mockBeanLevelInfo = (BeanLevelInfo)Mockito.mock(BeanLevelInfo.class);
        ((BeanLevelInfo)Mockito.doThrow((Throwable)new RuntimeException("SOME ERROR")).when((Object)mockBeanLevelInfo)).getField();
        Assert.assertEquals((long)-1L, (long)bi.getCollectionSize(mockBeanLevelInfo, (Object)mbl1));
    }

    @Test
    public void getCollectionSize_Property_NonCollection() throws Exception {
        BeanInjector bi = new BeanInjector(null);
        BeanInjectionInfo bii = new BeanInjectionInfo(MetaBeanLevel1.class);
        MetaBeanLevel1 mbl1 = new MetaBeanLevel1();
        mbl1.setSub(new MetaBeanLevel2());
        mbl1.getSub().setAscending(Arrays.asList(true, false, false, true));
        BeanInjectionInfo.Property property = bii.getProperties().values().stream().filter(p -> p.getName().equals("SEPARATOR")).findFirst().orElse(null);
        Assert.assertEquals((long)-1L, (long)bi.getCollectionSize(property, (Object)mbl1.getSub()));
    }
}

