/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanInjector;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;

@Ignore
public abstract class BaseMetadataInjectionTest<T> {
    protected BeanInjectionInfo info;
    protected BeanInjector injector;
    protected T meta;
    protected Set<String> nonTestedProperties;

    protected void setup(T meta) {
        KettleLogStore.init();
        this.meta = meta;
        this.info = new BeanInjectionInfo(meta.getClass());
        this.injector = new BeanInjector(this.info);
        this.nonTestedProperties = new HashSet(this.info.getProperties().keySet());
    }

    @After
    public void after() {
        Assert.assertTrue((String)("Some properties where not tested: " + this.nonTestedProperties), (boolean)this.nonTestedProperties.isEmpty());
    }

    protected List<RowMetaAndData> setValue(ValueMetaInterface valueMeta, Object ... values) {
        RowMeta rowsMeta = new RowMeta();
        rowsMeta.addValueMeta(valueMeta);
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        if (values != null) {
            for (Object v : values) {
                rows.add(new RowMetaAndData((RowMetaInterface)rowsMeta, new Object[]{v}));
            }
        }
        return rows;
    }

    protected void skipPropertyTest(String propertyName) {
        this.nonTestedProperties.remove(propertyName);
    }

    protected void check(String propertyName, BooleanGetter getter) throws KettleException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "Y"), "f");
        Assert.assertEquals((Object)true, (Object)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "N"), "f");
        Assert.assertEquals((Object)false, (Object)getter.get());
        ValueMetaBoolean valueMetaBoolean = new ValueMetaBoolean("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaBoolean, true), "f");
        Assert.assertEquals((Object)true, (Object)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaBoolean, false), "f");
        Assert.assertEquals((Object)false, (Object)getter.get());
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, StringGetter getter, String ... values) throws KettleException {
        ValueMetaString valueMeta = new ValueMetaString("f");
        if (values.length == 0) {
            values = new String[]{"v", "v2", null};
        }
        String correctValue = null;
        for (String v : values) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMeta, v), "f");
            if (v != null) {
                correctValue = v;
            }
            Assert.assertEquals((Object)correctValue, (Object)getter.get());
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, EnumGetter getter, Class<?> enumType) throws KettleException {
        ?[] values;
        ValueMetaString valueMeta = new ValueMetaString("f");
        for (Object v : values = enumType.getEnumConstants()) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMeta, v), "f");
            Assert.assertEquals(v, getter.get());
        }
        try {
            this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMeta, "###"), "f");
            Assert.fail((String)"Should be passed to enum");
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, IntGetter getter) throws KettleException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "1"), "f");
        Assert.assertEquals((long)1L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "45"), "f");
        Assert.assertEquals((long)45L, (long)getter.get());
        ValueMetaInteger valueMetaInteger = new ValueMetaInteger("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaInteger, 1234L), "f");
        Assert.assertEquals((long)1234L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaInteger, Integer.MAX_VALUE), "f");
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)getter.get());
        this.skipPropertyTest(propertyName);
    }

    protected void checkStringToInt(String propertyName, IntGetter getter, String[] codes, int[] ids) throws KettleException {
        if (codes.length != ids.length) {
            throw new RuntimeException("Wrong codes/ids sizes");
        }
        ValueMetaString valueMetaString = new ValueMetaString("f");
        for (int i = 0; i < codes.length; ++i) {
            this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, codes[i]), "f");
            Assert.assertEquals((long)ids[i], (long)getter.get());
        }
        this.skipPropertyTest(propertyName);
    }

    protected void check(String propertyName, LongGetter getter) throws KettleException {
        ValueMetaString valueMetaString = new ValueMetaString("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "1"), "f");
        Assert.assertEquals((long)1L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaString, "45"), "f");
        Assert.assertEquals((long)45L, (long)getter.get());
        ValueMetaInteger valueMetaInteger = new ValueMetaInteger("f");
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaInteger, 1234L), "f");
        Assert.assertEquals((long)1234L, (long)getter.get());
        this.injector.setProperty(this.meta, propertyName, this.setValue((ValueMetaInterface)valueMetaInteger, Long.MAX_VALUE), "f");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)getter.get());
        this.skipPropertyTest(propertyName);
    }

    public static int[] getTypeCodes(String[] typeNames) {
        int[] typeCodes = new int[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            typeCodes[i] = ValueMetaBase.getType((String)typeNames[i]);
        }
        return typeCodes;
    }

    public static interface LongGetter {
        public long get();
    }

    public static interface IntGetter {
        public int get();
    }

    public static interface EnumGetter {
        public Enum<?> get();
    }

    public static interface StringGetter {
        public String get();
    }

    public static interface BooleanGetter {
        public boolean get();
    }
}

