/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.zip.ZIPCompressionInputStream;
import org.pentaho.di.core.compress.zip.ZIPCompressionOutputStream;
import org.pentaho.di.core.compress.zip.ZIPCompressionProvider;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class ZIPCompressionProviderTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    public static final String PROVIDER_NAME = "Zip";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        ZIPCompressionProvider ncp = new ZIPCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        ZIPCompressionProvider provider = (ZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        ZIPCompressionProvider provider = (ZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"ZIP compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertEquals((Object)"zip", (Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        ZIPCompressionProvider provider = (ZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
        ZipInputStream zis = new ZipInputStream(in);
        ZIPCompressionInputStream inStream = new ZIPCompressionInputStream((InputStream)in, (CompressionProvider)provider);
        Assert.assertNotNull((Object)inStream);
        ZIPCompressionInputStream ncis = provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
        ZIPCompressionInputStream ncis2 = provider.createInputStream((InputStream)zis);
        Assert.assertNotNull((Object)ncis2);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        ZIPCompressionProvider provider = (ZIPCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        ZIPCompressionOutputStream outStream = new ZIPCompressionOutputStream((OutputStream)out, (CompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        ZIPCompressionOutputStream ncis = provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
        ZIPCompressionOutputStream ncis2 = provider.createOutputStream((OutputStream)zos);
        Assert.assertNotNull((Object)ncis2);
    }
}

