/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.snappy.SnappyCompressionInputStream;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCompressionInputStreamTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    public static final String PROVIDER_NAME = "Snappy";
    protected CompressionProviderFactory factory = null;
    protected SnappyCompressionInputStream inStream = null;
    protected CompressionProvider provider = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        this.provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        this.inStream = new SnappyCompressionInputStream((InputStream)this.createSnappyInputStream(), this.provider){};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.inStream);
    }

    @Test
    public void getCompressionProvider() {
        Assert.assertEquals((Object)this.provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testNextEntry() throws IOException {
        Assert.assertNull((Object)this.inStream.nextEntry());
    }

    @Test
    public void testClose() throws IOException {
        this.inStream = new SnappyCompressionInputStream((InputStream)this.createSnappyInputStream(), this.provider);
        this.inStream.close();
    }

    @Test
    public void testRead() throws IOException {
        Assert.assertEquals((long)this.inStream.available(), (long)this.inStream.read(new byte[100], 0, this.inStream.available()));
    }

    private SnappyInputStream createSnappyInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SnappyOutputStream sos = new SnappyOutputStream((OutputStream)baos);
        byte[] testBytes = "Test".getBytes();
        sos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        sos.close();
        return new SnappyInputStream((InputStream)in);
    }
}

