/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.gzip.GZIPCompressionInputStream;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class GZIPCompressionInputStreamTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    public static final String PROVIDER_NAME = "GZip";
    protected CompressionProviderFactory factory = null;
    protected GZIPCompressionInputStream inStream = null;
    protected CompressionProvider provider = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
        this.provider = this.factory.getCompressionProviderByName(PROVIDER_NAME);
        this.inStream = new GZIPCompressionInputStream(this.createGZIPInputStream(), this.provider){};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        Assert.assertNotNull((Object)this.inStream);
    }

    @Test
    public void getZIPCompressionProvider() {
        CompressionProvider provider = this.inStream.getCompressionProvider();
        Assert.assertEquals((Object)provider.getName(), (Object)PROVIDER_NAME);
    }

    @Test
    public void testNextEntry() throws IOException {
        Assert.assertNull((Object)this.inStream.nextEntry());
    }

    @Test
    public void testClose() throws IOException {
        this.inStream = new GZIPCompressionInputStream(this.createGZIPInputStream(), this.provider){};
        this.inStream.close();
    }

    @Test
    public void testRead() throws IOException {
        this.inStream = new GZIPCompressionInputStream(this.createGZIPInputStream(), this.provider){};
        this.inStream.read(new byte[100], 0, this.inStream.available());
    }

    protected InputStream createGZIPInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        byte[] testBytes = "Test".getBytes();
        gos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        return in;
    }
}

