/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.pentaho.di.core.attributes.AttributesUtil;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.w3c.dom.Node;

@PrepareForTest(value={AttributesUtil.class})
@RunWith(value=PowerMockRunner.class)
public class AttributesUtilTest {
    private static final String CUSTOM_TAG = "customTag";
    private static final String A_KEY = "aKEY";
    private static final String A_VALUE = "aVALUE";
    private static final String A_GROUP = "attributesGroup";

    @Before
    public void setUp() {
        PowerMockito.mockStatic(AttributesUtil.class, (Class[])new Class[0]);
    }

    @Test
    public void testGetAttributesXml_DefaultTag() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)))).thenCallRealMethod();
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        HashMap<String, String> attributesGroup = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> attributesMap = new HashMap<String, HashMap<String, String>>();
        attributesGroup.put(A_KEY, A_VALUE);
        attributesMap.put(A_GROUP, attributesGroup);
        String attributesXml = AttributesUtil.getAttributesXml(attributesMap);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains("attributes"));
        Assert.assertTrue((boolean)attributesXml.contains(A_GROUP));
        Assert.assertTrue((boolean)attributesXml.contains(A_KEY));
        Assert.assertTrue((boolean)attributesXml.contains(A_VALUE));
        PowerMockito.verifyStatic(AttributesUtil.class);
        AttributesUtil.getAttributesXml(attributesMap, (String)"attributes");
    }

    @Test
    public void testGetAttributesXml_CustomTag() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        HashMap<String, String> attributesGroup = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> attributesMap = new HashMap<String, HashMap<String, String>>();
        attributesGroup.put(A_KEY, A_VALUE);
        attributesMap.put(A_GROUP, attributesGroup);
        String attributesXml = AttributesUtil.getAttributesXml(attributesMap, (String)CUSTOM_TAG);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains(CUSTOM_TAG));
        Assert.assertTrue((boolean)attributesXml.contains(A_GROUP));
        Assert.assertTrue((boolean)attributesXml.contains(A_KEY));
        Assert.assertTrue((boolean)attributesXml.contains(A_VALUE));
    }

    @Test
    public void testGetAttributesXml_DefaultTag_NullParameter() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)))).thenCallRealMethod();
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        String attributesXml = AttributesUtil.getAttributesXml(null);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains("attributes"));
    }

    @Test
    public void testGetAttributesXml_CustomTag_NullParameter() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        String attributesXml = AttributesUtil.getAttributesXml(null, (String)CUSTOM_TAG);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains(CUSTOM_TAG));
    }

    @Test
    public void testGetAttributesXml_DefaultTag_EmptyMap() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)))).thenCallRealMethod();
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        HashMap attributesMap = new HashMap();
        String attributesXml = AttributesUtil.getAttributesXml(attributesMap);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains("attributes"));
    }

    @Test
    public void testGetAttributesXml_CustomTag_EmptyMap() {
        PowerMockito.when((Object)AttributesUtil.getAttributesXml((Map)((Map)Matchers.any(Map.class)), (String)Matchers.anyString())).thenCallRealMethod();
        HashMap attributesMap = new HashMap();
        String attributesXml = AttributesUtil.getAttributesXml(attributesMap, (String)CUSTOM_TAG);
        Assert.assertNotNull((Object)attributesXml);
        Assert.assertTrue((boolean)attributesXml.contains(CUSTOM_TAG));
    }

    @Test
    public void testLoadAttributes_NullParameter() {
        PowerMockito.when((Object)AttributesUtil.loadAttributes((Node)((Node)Matchers.any(Node.class)))).thenCallRealMethod();
        Map attributesMap = AttributesUtil.loadAttributes(null);
        Assert.assertNotNull((Object)attributesMap);
        Assert.assertTrue((boolean)attributesMap.isEmpty());
    }
}

