/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.ConcurrentMapProperties;

public class ConcurrentMapPropertiesTest {
    @Test
    public void runMapTests() throws IOException {
        Properties p = new Properties();
        ConcurrentMapProperties c = new ConcurrentMapProperties();
        for (int i = 0; i < 10000; ++i) {
            Iterator unique = UUID.randomUUID().toString();
            p.put(unique, unique);
            c.put((Object)unique, (Object)unique);
        }
        Assert.assertTrue((boolean)p.equals(c));
        Assert.assertEquals((long)p.size(), (long)c.size());
        ArrayList<String> removeKeys = new ArrayList<String>(c.size());
        for (Object e : c.keySet()) {
            if (!(Math.random() > 0.2)) continue;
            removeKeys.add((String)e);
        }
        for (String string : removeKeys) {
            c.remove((Object)string);
            p.remove(string);
        }
        Assert.assertEquals((long)p.size(), (long)c.size());
        Assert.assertTrue((boolean)p.equals(c));
        p.clear();
        c.clear();
        Assert.assertTrue((boolean)p.equals(c));
        Assert.assertEquals((long)0L, (long)p.size());
        Assert.assertEquals((long)0L, (long)c.size());
        Map<String, String> addKeys = removeKeys.stream().collect(Collectors.toMap(x -> x, x -> x));
        p.putAll(addKeys);
        c.putAll(addKeys);
        Assert.assertTrue((boolean)p.equals(c));
        for (String property : removeKeys) {
            Assert.assertEquals((Object)p.getProperty(property), (Object)c.getProperty(property));
        }
        Path path = Files.createTempFile("propstest", "props", new FileAttribute[0]);
        c.store((OutputStream)new FileOutputStream(path.toFile()), "No Comments");
        c.clear();
        Assert.assertEquals((long)0L, (long)c.size());
        c.load((InputStream)new FileInputStream(path.toFile()));
        Assert.assertEquals((Object)c, (Object)p);
    }
}

