/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.SocketPortAllocation;
import org.pentaho.di.www.TransformationMap;

public class TransformationMapConcurrentTest {
    TransformationMap transformationMap;
    int numberOfSameAllocations = 10;
    int numberOfSameSourceAndTargetSlaveNameAllocations = 40;
    int numberOfDifferentAllocations = 100;
    int numberOfSameHosts = 100;
    int numberOfDeallocateTasks = 100;
    List<ConcurrentAllocate> concurrentAllocateTasks;
    List<ConcurrentDeallocate> concurrentDeallocateTasks;

    @Before
    public void setup() throws Exception {
        int i;
        this.transformationMap = new TransformationMap();
        this.concurrentAllocateTasks = new ArrayList<ConcurrentAllocate>();
        this.concurrentDeallocateTasks = new ArrayList<ConcurrentDeallocate>();
        for (i = 1; i <= this.numberOfSameAllocations; ++i) {
            this.concurrentAllocateTasks.add(new ConcurrentAllocate(40000, "host0", "id0", "trans0", "slave0", "source0", "0", "slave-0", "target0", "0"));
        }
        for (i = 1; i <= this.numberOfSameSourceAndTargetSlaveNameAllocations; ++i) {
            this.concurrentAllocateTasks.add(new ConcurrentAllocate(40000, "host1", "id" + i, "trans" + i, "slave-1", "source" + i, "" + i, "slave-2", "target" + i, "" + i));
        }
        for (i = 2; i <= this.numberOfDifferentAllocations + 1; ++i) {
            this.concurrentAllocateTasks.add(new ConcurrentAllocate(40000, "host" + i, "id" + i, "trans" + i, "slave-" + i, "source" + i, "" + i, "slave-" + i, "target" + i, "" + i));
        }
        for (i = 1; i <= this.numberOfSameHosts; ++i) {
            this.concurrentAllocateTasks.add(new ConcurrentAllocate(40000, "host" + i, "diff", "diff", "diff", "diff", "diff", "diff", "diff", "diff"));
        }
        for (i = 0; i < this.numberOfDeallocateTasks; ++i) {
            CarteObjectEntry carteObjectEntry = new CarteObjectEntry("trans" + i, "id1");
            this.concurrentDeallocateTasks.add(new ConcurrentDeallocate(i, "host" + i, carteObjectEntry));
        }
    }

    @Test
    public void testConcurrentAllocateServerSocketPort() throws Exception {
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(this.concurrentAllocateTasks, Collections.emptyList(), (AtomicBoolean)new AtomicBoolean(true));
    }

    @Test
    public void testConcurrentAllocateAndDeallocateServerSocketPort() throws Exception {
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(this.concurrentDeallocateTasks, this.concurrentAllocateTasks, (AtomicBoolean)new AtomicBoolean(true));
    }

    private class ConcurrentDeallocate
    implements Callable<Object> {
        int port;
        String hostname;
        CarteObjectEntry entry;

        ConcurrentDeallocate(int port, String hostname, CarteObjectEntry entry) {
            this.port = port;
            this.hostname = hostname;
            this.entry = entry;
        }

        @Override
        public Object call() throws Exception {
            TransformationMapConcurrentTest.this.transformationMap.deallocateServerSocketPorts(this.entry);
            TransformationMapConcurrentTest.this.transformationMap.deallocateServerSocketPort(this.port, this.hostname);
            return null;
        }
    }

    private class ConcurrentAllocate
    implements Callable<SocketPortAllocation> {
        int portRangeStart;
        String hostname;
        String clusteredRunId;
        String transformationName;
        String sourceSlaveName;
        String sourceStepName;
        String sourceStepCopy;
        String targetSlaveName;
        String targetStepName;
        String targetStepCopy;

        public ConcurrentAllocate(int portRangeStart, String hostname, String clusteredRunId, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) {
            this.portRangeStart = portRangeStart;
            this.hostname = hostname;
            this.clusteredRunId = clusteredRunId;
            this.transformationName = transformationName;
            this.sourceSlaveName = sourceSlaveName;
            this.sourceStepName = sourceStepName;
            this.sourceStepCopy = sourceStepCopy;
            this.targetSlaveName = targetSlaveName;
            this.targetStepName = targetStepName;
            this.targetStepCopy = targetStepCopy;
        }

        @Override
        public SocketPortAllocation call() throws Exception {
            return TransformationMapConcurrentTest.this.transformationMap.allocateServerSocketPort(this.portRangeStart, this.hostname, this.clusteredRunId, this.transformationName, this.sourceSlaveName, this.sourceStepName, this.sourceStepCopy, this.targetSlaveName, this.targetStepName, this.targetStepCopy);
        }
    }
}

