/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;

public class SlaveServerConcurrentTest {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String HOST_NAME = "hostName";
    private static final String PORT = "port";
    private static final String WEB_APP_NAME = "webAppName";
    private static final String USERNAME = "userName";
    private static final String PASSWORD = "password";
    private static final String PROXY_HOST_NAME = "proxyHostName";
    private static final String PROXY_PORT = "proxyPort";
    private static final String NON_PROXY_HOSTS = "nonProxyHosts";
    private static final int NUMBER_OF_REPLACES = 200;
    private static final int NUMBER_OF_GETTERS = 100;
    private static final int REPLACE_CIRCLES = 100;
    private SlaveServer sharedSlaveServer;

    @Before
    public void setUp() throws Exception {
        this.sharedSlaveServer = this.generateSlaveServer();
    }

    @Test
    public void getAndReplaceConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        List<Getter> getters = this.generateGetters(condition);
        List<Replacer> replacers = this.generateReplacers(condition);
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(replacers, getters, (AtomicBoolean)condition);
    }

    private List<Getter> generateGetters(AtomicBoolean condition) {
        ArrayList<Getter> consistencyCheckers = new ArrayList<Getter>();
        for (int i = 0; i < 100; ++i) {
            consistencyCheckers.add(new Getter(condition));
        }
        return consistencyCheckers;
    }

    private List<Replacer> generateReplacers(AtomicBoolean condition) {
        ArrayList<Replacer> replacers = new ArrayList<Replacer>();
        for (int i = 0; i < 200; ++i) {
            replacers.add(new Replacer(condition));
        }
        return replacers;
    }

    private SlaveServer generateSlaveServer() {
        Random random = new Random();
        int id = random.nextInt();
        SlaveServer slaveServer = new SlaveServer();
        slaveServer.setName(NAME + id);
        slaveServer.setHostname(HOST_NAME + id);
        slaveServer.setPort(PORT + id);
        slaveServer.setWebAppName(WEB_APP_NAME + id);
        slaveServer.setUsername(USERNAME + id);
        slaveServer.setPassword(PASSWORD + id);
        slaveServer.setProxyHostname(PROXY_HOST_NAME + id);
        slaveServer.setProxyPort(PROXY_PORT + id);
        slaveServer.setNonProxyHosts(NON_PROXY_HOSTS + id);
        slaveServer.setObjectId((ObjectId)new StringObjectId(ID + id));
        return slaveServer;
    }

    private class Getter
    extends StopOnErrorCallable<Object> {
        Getter(AtomicBoolean condition) {
            super(condition);
        }

        public Object doCall() {
            while (this.condition.get()) {
                this.checkConsistency((SlaveServer)SlaveServerConcurrentTest.this.sharedSlaveServer.clone());
            }
            return null;
        }

        private void checkConsistency(SlaveServer slaveServer) {
            String id = this.extractId(slaveServer.getName());
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getHostname()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getPort()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getWebAppName()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getUsername()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getPassword()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getProxyHostname()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getProxyPort()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getNonProxyHosts()));
            Assert.assertEquals((Object)id, (Object)this.extractId(slaveServer.getObjectId().getId()));
        }

        private String extractId(String string) {
            return string.replaceAll("\\D+", "");
        }
    }

    private class Replacer
    extends StopOnErrorCallable<Object> {
        Replacer(AtomicBoolean condition) {
            super(condition);
        }

        public Object doCall() {
            for (int i = 0; i < 100; ++i) {
                SlaveServerConcurrentTest.this.sharedSlaveServer.replaceMeta(SlaveServerConcurrentTest.this.generateSlaveServer());
            }
            return null;
        }
    }
}

