/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.extension.ExtensionPointPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

@Ignore
public class PluginRegistryConcurrencyTest {
    private static final Class<? extends PluginTypeInterface> type1 = TwoWayPasswordEncoderPluginType.class;
    private static final Class<? extends PluginTypeInterface> type2 = ExtensionPointPluginType.class;
    private final Map<Class<? extends PluginTypeInterface>, List<PluginInterface>> plugins = new HashMap<Class<? extends PluginTypeInterface>, List<PluginInterface>>();

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() {
        this.plugins.clear();
    }

    @After
    public void tearDown() {
        PluginRegistry registry = PluginRegistry.getInstance();
        for (Map.Entry<Class<? extends PluginTypeInterface>, List<PluginInterface>> entry : this.plugins.entrySet()) {
            Class<? extends PluginTypeInterface> type = entry.getKey();
            for (PluginInterface plugin : entry.getValue()) {
                registry.removePlugin(type, plugin);
            }
        }
    }

    private synchronized void addUsedPlugins(Class<? extends PluginTypeInterface> type, List<PluginInterface> list) {
        List<PluginInterface> existing = this.plugins.get(type);
        if (existing == null) {
            existing = new ArrayList<PluginInterface>();
            this.plugins.put(type, existing);
        }
        existing.addAll(list);
    }

    @Test
    public void getPlugins_WhenRegisteringPluginTypes() throws Exception {
        int gettersAmount = 30;
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Getter> getters = new ArrayList<Getter>(30);
        for (int i = 0; i < 30; ++i) {
            Class<? extends PluginTypeInterface> type = i % 2 == 0 ? type1 : type2;
            getters.add(new Getter(condition, type));
        }
        PluginTypeInterface type = (PluginTypeInterface)Mockito.mock(PluginTypeInterface.class);
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(Collections.singletonList(new Registrar(condition, type.getClass(), 1, "")), getters, (AtomicBoolean)condition);
    }

    @Test
    public void getPlugins_WhenRegisteringPlugins() throws Exception {
        int gettersAmount = 30;
        int cycles = 100;
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Getter> getters = new ArrayList<Getter>(30);
        for (int i = 0; i < 30; ++i) {
            Class<? extends PluginTypeInterface> type = i % 2 == 0 ? type1 : type2;
            getters.add(new Getter(condition, type));
        }
        List<Registrar> registrars = Arrays.asList(new Registrar(condition, type1, 100, type1.getName()), new Registrar(condition, type2, 100, type2.getName()));
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(registrars, getters, (AtomicBoolean)condition);
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final Class<? extends PluginTypeInterface> type;

        public Getter(AtomicBoolean condition, Class<? extends PluginTypeInterface> type) {
            super(condition);
            this.type = type;
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                PluginRegistry.getInstance().getPlugins(this.type);
            }
            return null;
        }
    }

    private class Registrar
    extends StopOnErrorCallable<Object> {
        private final Class<? extends PluginTypeInterface> type;
        private final int cycles;
        private final String nameSeed;

        public Registrar(AtomicBoolean condition, Class<? extends PluginTypeInterface> type, int cycles, String nameSeed) {
            super(condition);
            this.type = type;
            this.cycles = cycles;
            this.nameSeed = nameSeed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object doCall() throws Exception {
            ArrayList<PluginInterface> registered = new ArrayList<PluginInterface>(this.cycles);
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    String id = this.nameSeed + '_' + i;
                    PluginInterface mock = (PluginInterface)Mockito.mock(PluginInterface.class);
                    Mockito.when((Object)mock.getName()).thenReturn((Object)id);
                    Mockito.when((Object)mock.getIds()).thenReturn((Object)new String[]{id});
                    Mockito.when((Object)mock.getPluginType()).thenAnswer((Answer)new Answer<Object>(){

                        public Object answer(InvocationOnMock invocation) throws Throwable {
                            return Registrar.this.type;
                        }
                    });
                    registered.add(mock);
                    PluginRegistry.getInstance().registerPlugin(this.type, mock);
                }
            }
            finally {
                PluginRegistryConcurrencyTest.this.addUsedPlugins(this.type, registered);
            }
            return null;
        }
    }
}

