/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.ListUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;

@RunWith(value=Parameterized.class)
@Ignore
public class JobTrackerConcurrencyTest {
    private static final int gettersAmount = 10;
    private static final int searchersAmount = 20;
    private static final int updatersAmount = 5;
    private static final int updatersCycles = 10;
    private static final int jobsLimit = 20;
    private final JobTracker tracker;

    @BeforeClass
    public static void setUp() {
        int jobsToBeAdded = 50;
        Assert.assertTrue((String)"The limit of stored jobs must be less than the amount of children to be added", (20 < jobsToBeAdded ? 1 : 0) != 0);
    }

    @Parameterized.Parameters
    public static List<Object[]> getData() {
        return Arrays.asList({new JobTracker(JobTrackerConcurrencyTest.mockJobMeta("parent"))}, {new JobTracker(JobTrackerConcurrencyTest.mockJobMeta("parent"), 20)});
    }

    private static JobMeta mockJobMeta(String name) {
        JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
        Mockito.when((Object)meta.getName()).thenReturn((Object)name);
        return meta;
    }

    public JobTrackerConcurrencyTest(JobTracker tracker) {
        this.tracker = tracker;
    }

    @Test
    public void readAndUpdateTrackerConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Getter> getters = new ArrayList<Getter>(10);
        for (int i = 0; i < 10; ++i) {
            getters.add(new Getter(condition, this.tracker));
        }
        ArrayList<Searcher> searchers = new ArrayList<Searcher>(20);
        for (int i = 0; i < 20; ++i) {
            int lookingFor = 25 + i;
            Assert.assertTrue((String)"We are looking for reachable index", (lookingFor < 50 ? 1 : 0) != 0);
            searchers.add(new Searcher(condition, this.tracker, JobTrackerConcurrencyTest.mockJobEntryCopy("job-entry-" + lookingFor, lookingFor)));
        }
        AtomicInteger generator = new AtomicInteger(0);
        ArrayList<Updater> updaters = new ArrayList<Updater>(5);
        for (int i = 0; i < 5; ++i) {
            updaters.add(new Updater(this.tracker, 10, generator, "job-entry-%d"));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(updaters, (List)ListUtils.union(getters, searchers), (AtomicBoolean)condition);
        Assert.assertEquals((long)50L, (long)generator.get());
    }

    static JobEntryCopy mockJobEntryCopy(String name, int number) {
        JobEntryCopy copy = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)copy.getName()).thenReturn((Object)name);
        Mockito.when((Object)copy.getNr()).thenReturn((Object)number);
        return copy;
    }

    private static class Updater
    implements Callable<Exception> {
        private final JobTracker tracker;
        private final int cycles;
        private final AtomicInteger idGenerator;
        private final String resultNameTemplate;

        public Updater(JobTracker tracker, int cycles, AtomicInteger idGenerator, String resultNameTemplate) {
            this.tracker = tracker;
            this.cycles = cycles;
            this.idGenerator = idGenerator;
            this.resultNameTemplate = resultNameTemplate;
        }

        @Override
        public Exception call() throws Exception {
            Exception exception = null;
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    int id = this.idGenerator.getAndIncrement();
                    JobEntryResult result = new JobEntryResult();
                    result.setJobEntryName(String.format(this.resultNameTemplate, id));
                    result.setJobEntryNr(id);
                    JobTracker child = new JobTracker(JobTrackerConcurrencyTest.mockJobMeta("child-" + id), result);
                    this.tracker.addJobTracker(child);
                }
            }
            catch (Exception e) {
                exception = e;
            }
            return exception;
        }
    }

    private static class Searcher
    extends StopOnErrorCallable<Object> {
        private final JobTracker tracker;
        private final JobEntryCopy copy;

        public Searcher(AtomicBoolean condition, JobTracker tracker, JobEntryCopy copy) {
            super(condition);
            this.tracker = tracker;
            this.copy = copy;
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                this.tracker.findJobTracker(this.copy);
            }
            return null;
        }
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final JobTracker tracker;
        private final Random random;

        public Getter(AtomicBoolean condition, JobTracker tracker) {
            super(condition);
            this.tracker = tracker;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            while (this.condition.get()) {
                int i;
                JobTracker t;
                int amount = this.tracker.nrJobTrackers();
                if (amount == 0 || (t = this.tracker.getJobTracker(i = this.random.nextInt(amount))) != null) continue;
                throw new IllegalStateException(String.format("Returned tracker must not be null. Index = %d, trackers' amount = %d", i, amount));
            }
            return null;
        }
    }
}

